/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.world.Block;
import mindustry.world.Tile;

public class TallBlock
extends Block {
    public float shadowOffset = -3.0f;
    public float layer = 71.0f;
    public float shadowLayer = 69.0f;
    public float rotationRand = 20.0f;
    public float shadowAlpha = 0.6f;

    public TallBlock(String name) {
        super(name);
        this.solid = true;
        this.clipSize = 90.0f;
        this.customShadow = true;
    }

    @Override
    public void init() {
        super.init();
        this.hasShadow = true;
    }

    @Override
    public void drawBase(Tile tile) {
        float rot = Mathf.randomSeedRange(tile.pos() + 1, this.rotationRand);
        Draw.z(this.shadowLayer);
        Draw.color(0.0f, 0.0f, 0.0f, this.shadowAlpha);
        Draw.rect(this.variants > 0 ? this.variantShadowRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantShadowRegions.length - 1))] : this.customShadowRegion, tile.worldx() + this.shadowOffset, tile.worldy() + this.shadowOffset, rot);
        Draw.color();
        Draw.z(this.layer);
        Draw.rect(this.variants > 0 ? this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))] : this.region, tile.worldx(), tile.worldy(), rot);
    }

    @Override
    public void drawShadow(Tile tile) {
    }

    @Override
    public TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.variants == 0) {
            textureRegionArray = super.icons();
        } else {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = Core.atlas.find(this.name + "1");
        }
        return textureRegionArray;
    }
}

