/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.input.KeyBind;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import java.util.Locale;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;

public class KeybindDialog
extends Dialog {
    protected KeyBind rebindKey = null;
    protected boolean rebindAxis = false;
    protected boolean rebindMin = true;
    protected KeyCode minKey = null;
    protected Dialog rebindDialog;
    protected Table bindsTable;
    private String searchText = "";

    public KeybindDialog() {
        super(Core.bundle.get("keybind.title"));
        this.addCloseButton();
        this.setFillParent(true);
        this.title.setAlignment(1);
        this.titleTable.row();
        this.titleTable.add(new Image()).growX().height(3.0f).pad(4.0f).get().setColor(Pal.accent);
        this.bindsTable = new Table();
        ScrollPane pane = new ScrollPane((Element)this.bindsTable);
        pane.setFadeScrollBars(false);
        this.top();
        this.cont.table((Table table) -> {
            table.left();
            table.image(Icon.zoom);
            TextField field = table.field(this.searchText, res -> {
                this.searchText = res;
                this.rebuildBinds();
            }).growX().get();
            this.shown(() -> {
                this.searchText = "";
                field.setText("");
                this.rebuildBinds();
                Core.app.post(field::requestKeyboard);
            });
        }).fillX().padBottom(4.0f).top();
        this.cont.row();
        this.cont.add(pane).grow();
        this.rebuildBinds();
    }

    @Override
    public void addCloseButton() {
        this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
        this.keyDown(key -> {
            if (key == KeyCode.escape || key == KeyCode.back) {
                this.hide();
            }
        });
    }

    private void rebuildBinds() {
        Table table = this.bindsTable;
        this.bindsTable.clear();
        table.add().height(10.0f);
        table.row();
        String lastCategory = null;
        TextButton.TextButtonStyle tstyle = Styles.grayt;
        float bw = 140.0f;
        float bh = 40.0f;
        for (KeyBind keybind : KeyBind.all) {
            if (!this.searchText.isEmpty() && !Core.bundle.get("keybind." + keybind.name + ".name", keybind.name).toLowerCase(Locale.ROOT).contains(this.searchText.toLowerCase(Locale.ROOT))) continue;
            if (lastCategory != keybind.category && keybind.category != null) {
                table.add(Core.bundle.get("category." + keybind.category + ".name", Strings.capitalize(keybind.category))).color(Color.gray).colspan(4).pad(10.0f).padBottom(4.0f).row();
                table.image().color(Color.gray).fillX().height(3.0f).pad(6.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
                lastCategory = keybind.category;
            }
            if (keybind.defaultValue instanceof KeyBind.Axis) {
                table.add((CharSequence)Core.bundle.get("keybind." + keybind.name + ".name", Strings.capitalize(keybind.name)), Color.white).left().padRight(40.0f).padLeft(8.0f);
                table.labelWrap(() -> {
                    KeyBind.Axis axis = keybind.value;
                    return axis.key != null ? axis.key.toString() : axis.min + " [red]/[] " + axis.max;
                }).color(Pal.accent).left().minWidth(90.0f).fillX().padRight(20.0f);
                table.button("@settings.rebind", tstyle, () -> {
                    this.rebindAxis = true;
                    this.rebindMin = true;
                    this.openDialog(keybind);
                }).size(bw, bh);
            } else {
                table.add((CharSequence)Core.bundle.get("keybind." + keybind.name + ".name", Strings.capitalize(keybind.name)), Color.white).left().padRight(40.0f).padLeft(8.0f);
                table.label(() -> keybind.value.key.toString()).color(Pal.accent).left().minWidth(90.0f).padRight(20.0f);
                table.button("@settings.rebind", tstyle, () -> {
                    this.rebindAxis = false;
                    this.rebindMin = false;
                    this.openDialog(keybind);
                }).size(bw, bh);
            }
            table.button("@settings.resetKey", tstyle, keybind::resetToDefault).disabled(t -> keybind.isDefault()).size(bw, bh).pad(2.0f).padLeft(4.0f);
            table.row();
        }
        table.button("@settings.reset", (Drawable)Icon.refresh, tstyle, KeyBind::resetAll).minWidth(200.0f).colspan(4).padTop(4.0f).margin(10.0f).height(50.0f).fill();
    }

    void rebind(KeyBind bind, KeyCode newKey) {
        if (this.rebindKey == null) {
            return;
        }
        this.rebindDialog.hide();
        boolean isAxis = bind.defaultValue instanceof KeyBind.Axis;
        if (isAxis) {
            if (newKey.axis || !this.rebindMin) {
                bind.value = newKey.axis ? new KeyBind.Axis(newKey) : new KeyBind.Axis(this.minKey, newKey);
            }
        } else {
            bind.value = new KeyBind.Axis(newKey);
        }
        bind.save();
        if (this.rebindAxis && isAxis && this.rebindMin && !newKey.axis) {
            this.rebindMin = false;
            this.minKey = newKey;
            this.openDialog(this.rebindKey);
        } else {
            this.rebindKey = null;
            this.rebindAxis = false;
        }
    }

    private void openDialog(final KeyBind name) {
        this.rebindDialog = new Dialog(this.rebindAxis ? Core.bundle.get("keybind.press.axis") : Core.bundle.get("keybind.press"));
        this.rebindKey = name;
        this.rebindDialog.titleTable.getCells().first().pad(4.0f);
        this.rebindDialog.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (Core.app.isAndroid()) {
                    return false;
                }
                KeybindDialog.this.rebind(name, button);
                return false;
            }

            @Override
            public boolean keyDown(InputEvent event, KeyCode keycode) {
                KeybindDialog.this.rebindDialog.hide();
                KeybindDialog.this.rebind(name, keycode);
                return false;
            }

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                if (!KeybindDialog.this.rebindAxis) {
                    return false;
                }
                KeybindDialog.this.rebindDialog.hide();
                KeybindDialog.this.rebind(name, KeyCode.scroll);
                return false;
            }
        });
        this.rebindDialog.show();
        Time.runTask(1.0f, () -> this.getScene().setScrollFocus(this.rebindDialog));
    }
}

