/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.units;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.Predict;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Weapon;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.meta.BlockFlag;

public class AIController
implements UnitController {
    protected static final Vec2 vec = new Vec2();
    protected static final float rotateBackTimer = 300.0f;
    protected static final int timerTarget = 0;
    protected static final int timerTarget2 = 1;
    protected static final int timerTarget3 = 2;
    protected static final int timerTarget4 = 3;
    protected Unit unit;
    protected Interval timer = new Interval(4);
    @Nullable
    protected AIController fallback;
    protected float noTargetTime;
    @Nullable
    protected Teamc target;
    @Nullable
    protected Teamc bomberTarget;

    public AIController() {
        this.resetTimers();
    }

    protected void resetTimers() {
        this.timer.reset(0, Mathf.random(40.0f));
        this.timer.reset(1, Mathf.random(60.0f));
    }

    @Override
    public void updateUnit() {
        if (this.useFallback() && (this.fallback != null || (this.fallback = this.fallback()) != null)) {
            if (this.fallback.unit != this.unit) {
                this.fallback.unit(this.unit);
            }
            this.fallback.updateUnit();
            return;
        }
        this.updateVisuals();
        this.updateTargeting();
        this.updateMovement();
    }

    public void stanceChanged() {
    }

    public boolean keepState() {
        return false;
    }

    @Override
    public void afterRead(Unit unit) {
    }

    @Override
    public boolean isLogicControllable() {
        return true;
    }

    public void stopShooting() {
        for (WeaponMount mount : this.unit.mounts) {
            mount.shoot = false;
        }
    }

    @Nullable
    public AIController fallback() {
        return null;
    }

    public boolean useFallback() {
        return false;
    }

    public void updateVisuals() {
        if (this.unit.isFlying()) {
            if (this.unit.type.wobble) {
                this.unit.wobble();
            }
            this.unit.lookAt(this.unit.prefRotation());
        }
    }

    public void updateMovement() {
    }

    public void updateTargeting() {
        if (this.unit.hasWeapons()) {
            this.updateWeapons();
        }
    }

    public void faceTarget() {
        if (this.unit.type.omniMovement || this.unit instanceof Mechc) {
            if (!Units.invalidateTarget(this.target, this.unit, this.unit.range()) && this.unit.type.faceTarget && this.unit.type.hasWeapons()) {
                this.unit.lookAt(Predict.intercept((Position)this.unit, (Position)this.target, this.unit.type.weapons.first().bullet));
            } else if (this.unit.moving()) {
                this.unit.lookAt(this.unit.vel().angle());
            }
        }
    }

    public void faceMovement() {
        if ((this.unit.type.omniMovement || this.unit instanceof Mechc) && this.unit.moving()) {
            this.unit.lookAt(this.unit.vel().angle());
        }
    }

    public boolean invalid(Teamc target) {
        return Units.invalidateTarget(target, this.unit.team, this.unit.x, this.unit.y);
    }

    public void pathfind(int pathTarget) {
        this.pathfind(pathTarget, true);
    }

    public void pathfind(int pathTarget, boolean stopAtTargetTile) {
        this.pathfind(pathTarget, stopAtTargetTile, false);
    }

    public void pathfind(int pathTarget, boolean stopAtTargetTile, boolean avoidance) {
        int costType = this.unit.type.flowfieldPathType;
        Tile tile = this.unit.tileOn();
        if (tile == null) {
            return;
        }
        Tile targetTile = Vars.pathfinder.getField(this.unit.team, costType, pathTarget).getNextTile(tile, avoidance && this.unit.collisionLayer() == 0 ? this.unit.id : 0);
        if (tile == targetTile && stopAtTargetTile || !this.unit.canPass(targetTile.x, targetTile.y)) {
            return;
        }
        this.unit.movePref(vec.trns(this.unit.angleTo(targetTile.worldx(), targetTile.worldy()), this.prefSpeed()));
    }

    public Vec2 alterPathfind(Vec2 vec) {
        return vec;
    }

    public void targetInvalidated() {
    }

    public void updateWeapons() {
        float rotation = this.unit.rotation - 90.0f;
        boolean ret = this.retarget();
        if (ret) {
            this.target = this.findMainTarget(this.unit.x, this.unit.y, this.unit.range(), this.unit.type.targetAir, this.unit.type.targetGround);
        }
        this.noTargetTime += Time.delta;
        if (this.invalid(this.target)) {
            if (this.target != null && !this.target.isAdded()) {
                this.targetInvalidated();
            }
            this.target = null;
        } else {
            this.noTargetTime = 0.0f;
        }
        this.unit.isShooting = false;
        for (WeaponMount mount : this.unit.mounts) {
            Weapon weapon = mount.weapon;
            float wrange = weapon.range();
            if (!weapon.controllable || weapon.noAttack) continue;
            if (!weapon.aiControllable) {
                mount.rotate = false;
                continue;
            }
            float mountX = this.unit.x + Angles.trnsx(rotation, weapon.x, weapon.y);
            float mountY = this.unit.y + Angles.trnsy(rotation, weapon.x, weapon.y);
            if (this.unit.type.singleTarget) {
                mount.target = this.target;
            } else {
                if (ret) {
                    mount.target = this.findTarget(mountX, mountY, wrange, weapon.bullet.collidesAir, weapon.bullet.collidesGround);
                }
                if (this.checkTarget(mount.target, mountX, mountY, wrange)) {
                    mount.target = null;
                }
            }
            boolean shoot = false;
            if (mount.target != null) {
                float f;
                Teamc teamc;
                Teamc teamc2 = teamc = mount.target;
                if (teamc instanceof Sized) {
                    Sized s = (Sized)((Object)teamc);
                    f = s.hitSize() / 2.0f;
                } else {
                    f = 0.0f;
                }
                boolean bl = shoot = teamc2.within(mountX, mountY, wrange + f) && this.shouldShoot();
                if (this.unit.type.autoDropBombs && !shoot) {
                    if (this.bomberTarget == null || !this.bomberTarget.isAdded() || !this.bomberTarget.within(this.unit, this.unit.hitSize / 2.0f + ((Sized)((Object)this.bomberTarget)).hitSize() / 2.0f)) {
                        this.bomberTarget = Units.closestTarget(this.unit.team, this.unit.x, this.unit.y, this.unit.hitSize, u -> !u.isFlying(), t -> true);
                    }
                    shoot = this.bomberTarget != null;
                }
                Vec2 to = Predict.intercept((Position)this.unit, (Position)mount.target, weapon.bullet);
                mount.aimX = to.x;
                mount.aimY = to.y;
            }
            mount.shoot = mount.rotate = shoot;
            if (!this.shouldFire()) {
                mount.shoot = false;
            }
            this.unit.isShooting |= mount.shoot;
            if (mount.target == null && !shoot && !Angles.within(mount.rotation, mount.weapon.baseRotation, 0.01f) && this.noTargetTime >= 300.0f) {
                mount.rotate = true;
                Tmp.v1.trns(this.unit.rotation + mount.weapon.baseRotation, 5.0f);
                mount.aimX = mountX + Tmp.v1.x;
                mount.aimY = mountY + Tmp.v1.y;
            }
            if (!shoot) continue;
            this.unit.aimX = mount.aimX;
            this.unit.aimY = mount.aimY;
        }
    }

    public boolean checkTarget(Teamc target, float x, float y, float range) {
        return Units.invalidateTarget(target, this.unit.team, x, y, range);
    }

    public boolean shouldFire() {
        return true;
    }

    public boolean shouldShoot() {
        return true;
    }

    public Teamc targetFlag(float x, float y, BlockFlag flag, boolean enemy) {
        if (this.unit.team == Team.derelict) {
            return null;
        }
        return Geometry.findClosest(x, y, enemy ? Vars.indexer.getEnemy(this.unit.team, flag) : Vars.indexer.getFlagged(this.unit.team, flag));
    }

    public Teamc target(float x, float y, float range, boolean air, boolean ground) {
        return Units.closestTarget(this.unit.team, x, y, range, u -> u.checkTarget(air, ground), t -> ground && (this.unit.type.targetUnderBlocks || !t.block.underBullets));
    }

    public boolean retarget() {
        return this.timer.get(0, this.target == null ? 40.0f : 90.0f);
    }

    public Teamc findMainTarget(float x, float y, float range, boolean air, boolean ground) {
        return this.findTarget(x, y, range, air, ground);
    }

    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        return this.target(x, y, range, air, ground);
    }

    public void commandTarget(Teamc moveTo) {
    }

    public void commandPosition(Vec2 pos) {
    }

    public void init() {
    }

    @Nullable
    public Tile getClosestSpawner() {
        return Geometry.findClosest(this.unit.x, this.unit.y, Vars.spawner.getSpawns());
    }

    public void unloadPayloads() {
        Payloadc pay;
        Unit unit = this.unit;
        if (unit instanceof Payloadc && (pay = (Payloadc)((Object)unit)).hasPayload() && this.target instanceof Building && pay.payloads().peek() instanceof UnitPayload && this.target.within(this.unit, Math.max(this.unit.type().range + 1.0f, 75.0f))) {
            pay.dropLastPayload();
        }
    }

    public void circleAttack(float circleLength) {
        vec.set(this.target).sub(this.unit);
        float ang = this.unit.angleTo(this.target);
        float diff = Angles.angleDist(ang, this.unit.rotation());
        if (diff > 70.0f && vec.len() < circleLength) {
            vec.setAngle(this.unit.vel().angle());
        } else {
            vec.setAngle(Angles.moveToward(this.unit.vel().angle(), vec.angle(), 6.0f));
        }
        vec.setLength(this.prefSpeed());
        this.unit.movePref(vec);
    }

    public void circle(Position target, float circleLength) {
        this.circle(target, circleLength, this.prefSpeed());
    }

    public void circle(Position target, float circleLength, float speed) {
        if (target == null) {
            return;
        }
        vec.set(target).sub(this.unit);
        if (vec.len() < circleLength) {
            vec.rotate((circleLength - vec.len()) / circleLength * 180.0f);
        }
        vec.setLength(speed);
        this.unit.movePref(vec);
    }

    public void moveTo(Position target, float circleLength) {
        this.moveTo(target, circleLength, 100.0f);
    }

    public void moveTo(Position target, float circleLength, float smooth) {
        this.moveTo(target, circleLength, smooth, this.unit.isFlying(), null);
    }

    public void moveTo(Position target, float circleLength, float smooth, boolean keepDistance, @Nullable Vec2 offset) {
        this.moveTo(target, circleLength, smooth, keepDistance, offset, false);
    }

    public void moveTo(Position target, float circleLength, float smooth, boolean keepDistance, @Nullable Vec2 offset, boolean arrive) {
        if (target == null) {
            return;
        }
        float speed = this.prefSpeed();
        vec.set(target).sub(this.unit);
        float length = circleLength <= 0.001f ? 1.0f : Mathf.clamp((this.unit.dst(target) - circleLength) / smooth, -1.0f, 1.0f);
        vec.setLength(speed * length);
        if (arrive) {
            Tmp.v3.set(-this.unit.vel.x / this.unit.type.accel * 2.0f, -this.unit.vel.y / this.unit.type.accel * 2.0f).add(target.getX() - this.unit.x, target.getY() - this.unit.y);
            vec.add(Tmp.v3).limit(speed * length);
        }
        if (length < -0.5f) {
            if (keepDistance) {
                vec.rotate(180.0f);
            } else {
                vec.setZero();
            }
        } else if (length < 0.0f) {
            vec.setZero();
        }
        if (offset != null) {
            vec.add(offset);
            vec.setLength(speed * length);
        }
        if (vec.isNaN() || vec.isInfinite() || vec.isZero()) {
            return;
        }
        if (!this.unit.type.omniMovement && this.unit.type.rotateMoveFirst) {
            float angle = vec.angle();
            this.unit.lookAt(angle);
            if (Angles.within(this.unit.rotation, angle, 3.0f)) {
                this.unit.movePref(vec);
            }
        } else {
            this.unit.movePref(vec);
        }
    }

    public float prefSpeed() {
        return this.unit.speed();
    }

    @Override
    public void unit(Unit unit) {
        if (this.unit == unit) {
            return;
        }
        this.unit = unit;
        this.init();
    }

    @Override
    public Unit unit() {
        return this.unit;
    }
}

