/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.bullet.ContinuousBulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;

public class ContinuousLaserBulletType
extends ContinuousBulletType {
    public float fadeTime = 16.0f;
    public float lightStroke = 40.0f;
    public int divisions = 13;
    public Color[] colors = new Color[]{Color.valueOf("ec745855"), Color.valueOf("ec7458aa"), Color.valueOf("ff9c5a"), Color.white};
    public float strokeFrom = 2.0f;
    public float strokeTo = 0.5f;
    public float pointyScaling = 0.75f;
    public float backLength = 7.0f;
    public float frontLength = 35.0f;
    public float width = 9.0f;
    public float oscScl = 0.8f;
    public float oscMag = 1.5f;

    public ContinuousLaserBulletType(float damage) {
        this.shake = 1.0f;
        this.largeHit = true;
        this.hitEffect = Fx.hitBeam;
        this.hitSize = 4.0f;
        this.drawSize = 420.0f;
        this.lifetime = 16.0f;
        this.hitColor = this.colors[2];
        this.incendAmount = 1;
        this.incendSpread = 5.0f;
        this.incendChance = 0.4f;
        this.lightColor = Color.orange;
        this.lightOpacity = 0.7f;
        this.damage = damage;
    }

    public ContinuousLaserBulletType() {
        this.shake = 1.0f;
        this.largeHit = true;
        this.hitEffect = Fx.hitBeam;
        this.hitSize = 4.0f;
        this.drawSize = 420.0f;
        this.lifetime = 16.0f;
        this.hitColor = this.colors[2];
        this.incendAmount = 1;
        this.incendSpread = 5.0f;
        this.incendChance = 0.4f;
        this.lightColor = Color.orange;
        this.lightOpacity = 0.7f;
    }

    @Override
    public void draw(Bullet b) {
        float fout = Mathf.clamp(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f);
        float realLength = Damage.findLength(b, this.length * fout, this.laserAbsorb, this.pierceCap);
        float rot = b.rotation();
        for (int i = 0; i < this.colors.length; ++i) {
            Draw.color(Tmp.c1.set(this.colors[i]).mul(1.0f + Mathf.absin(Time.time, 1.0f, 0.1f)));
            float colorFin = (float)i / (float)(this.colors.length - 1);
            float baseStroke = Mathf.lerp(this.strokeFrom, this.strokeTo, colorFin);
            float stroke = (this.width + Mathf.absin(Time.time, this.oscScl, this.oscMag)) * fout * baseStroke;
            float ellipseLenScl = Mathf.lerp(1.0f - (float)i / (float)this.colors.length, 1.0f, this.pointyScaling);
            Lines.stroke(stroke);
            Lines.lineAngle(b.x, b.y, rot, Math.max(0.0f, realLength - this.frontLength), false);
            Drawf.flameFront(b.x, b.y, this.divisions, rot + 180.0f, this.backLength, stroke / 2.0f);
            Tmp.v1.trnsExact(rot, Math.max(0.0f, realLength - this.frontLength));
            Drawf.flameFront(b.x + Tmp.v1.x, b.y + Tmp.v1.y, this.divisions, rot, this.frontLength * ellipseLenScl, stroke / 2.0f);
        }
        Tmp.v1.trns(b.rotation(), realLength * 1.1f);
        Drawf.light(b.x, b.y, b.x + Tmp.v1.x, b.y + Tmp.v1.y, this.lightStroke, this.lightColor, this.lightOpacity);
        Draw.reset();
    }

    @Override
    public void drawLight(Bullet b) {
    }

    @Override
    public float currentLength(Bullet b) {
        float fout = Mathf.clamp(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f);
        return this.length * fout;
    }
}

