/*
 * Decompiled with CFR 0.152.
 */
package mindustry.audio;

import arc.Core;
import arc.audio.Sound;
import arc.struct.Seq;
import mindustry.gen.Sounds;

public class SoundPriority {
    public static void init() {
        SoundPriority.set(2.0f, Sounds.laserbig, Sounds.beam);
        SoundPriority.set(1.5f, Sounds.railgun, Sounds.largeCannon);
        SoundPriority.set(1.0f, Sounds.conveyor, Sounds.smelter, Sounds.drill, Sounds.extractLoop, Sounds.flux, Sounds.hum, Sounds.respawning);
        Sounds.shootBig.setMinConcurrentInterrupt(Sounds.shootBig.getLength() * 0.9f);
        for (Sound sound : Core.assets.getAll(Sound.class, new Seq())) {
            sound.setMinConcurrentInterrupt(Math.min(0.25f, sound.getLength() * 0.5f));
            sound.setMaxConcurrent(7);
        }
    }

    static void set(float value, Sound ... sounds) {
        for (Sound s : sounds) {
            s.setPriority(value);
        }
    }
}

