/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.math.FloatCounter;
import arc.util.Log;
import arc.util.Time;

public class PerformanceCounter {
    private static final float nano2seconds = 1.0E-9f;
    public final FloatCounter time;
    public final FloatCounter load;
    public final String name;
    public float current = 0.0f;
    public boolean valid = false;
    private long startTime = 0L;
    private long lastTick = 0L;

    public PerformanceCounter(String name) {
        this(name, 5);
    }

    public PerformanceCounter(String name, int windowSize) {
        this.name = name;
        this.time = new FloatCounter(windowSize);
        this.load = new FloatCounter(1);
    }

    public void tick() {
        long t = Time.nanos();
        if (this.lastTick > 0L) {
            this.tick((float)(t - this.lastTick) * 1.0E-9f);
        }
        this.lastTick = t;
    }

    public void tick(float delta) {
        if (!this.valid) {
            Log.err("[PerformanceCounter] Invalid data, check if you called PerformanceCounter#stop()", new Object[0]);
            return;
        }
        this.time.put(this.current / 1.0E-9f);
        float currentLoad = delta == 0.0f ? 0.0f : this.current / delta;
        this.load.put(delta > 1.0f ? currentLoad : delta * currentLoad + (1.0f - delta) * this.load.latest);
        this.current = 0.0f;
        this.valid = false;
    }

    public void start() {
        this.startTime = Time.nanos();
        this.valid = false;
    }

    public void stop() {
        if (this.startTime > 0L) {
            this.current += (float)(Time.nanos() - this.startTime) * 1.0E-9f;
            this.startTime = 0L;
            this.valid = true;
        }
    }

    public void reset() {
        this.time.reset();
        this.load.reset();
        this.startTime = 0L;
        this.lastTick = 0L;
        this.current = 0.0f;
        this.valid = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return this.toString(sb).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append(this.name).append(":\n  time: ");
        this.commas(sb, (int)this.time.value);
        sb.append("\n  load: ").append((int)(this.load.value * 100.0f)).append('%');
        return sb;
    }

    private void commas(StringBuilder builder, int number) {
        StringBuilder sub = new StringBuilder();
        int index = 0;
        while (number > 0) {
            int digit = number % 10;
            sub.append(digit);
            if (++index % 3 != 0 || (number /= 10) <= 0) continue;
            sub.append(',');
        }
        builder.append((CharSequence)sub.reverse());
    }
}

