/*
 * Decompiled with CFR 0.152.
 */
package arc.packer;

import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.TextureAtlas;
import java.io.File;

public class TextureUnpacker {
    private static final String DEFAULT_OUTPUT_PATH = "output";
    private static final int NINEPATCH_PADDING = 1;
    private static final String HELP = "Usage: atlasFile [imageDir] [outputDir]";
    private static final String ATLAS_FILE_EXTENSION = ".aatls";

    private int parseArguments(String[] args) {
        int numArgs = args.length;
        if (numArgs < 1) {
            return 0;
        }
        boolean extension = args[0].endsWith(ATLAS_FILE_EXTENSION);
        boolean directory = true;
        if (numArgs >= 2) {
            directory = this.checkDirectoryValidity(args[1]);
        }
        if (numArgs == 3) {
            directory &= this.checkDirectoryValidity(args[2]);
        }
        return extension && directory ? numArgs : 0;
    }

    private boolean checkDirectoryValidity(String directory) {
        File checkFile = new File(directory);
        boolean path = true;
        try {
            checkFile.getCanonicalPath();
        }
        catch (Exception e) {
            path = false;
        }
        return path;
    }

    public void splitAtlas(TextureAtlas.TextureAtlasData atlas, String outputDir, boolean quiet) {
        File outputDirFile = new File(outputDir);
        if (!outputDirFile.exists()) {
            outputDirFile.mkdirs();
            if (!quiet) {
                System.out.printf("Creating directory: %s%n", outputDirFile.getPath());
            }
        }
        for (TextureAtlas.TextureAtlasData.AtlasPage page : atlas.getPages()) {
            File file = page.textureFile.file();
            if (!file.exists()) {
                throw new RuntimeException("Unable to find atlas image: " + file.getAbsolutePath());
            }
            Pixmap img = new Pixmap(new Fi(file));
            for (TextureAtlas.TextureAtlasData.Region region : atlas.getRegions()) {
                if (!quiet) {
                    System.out.printf("Processing image for %s: x[%s] y[%s] w[%s] h[%s], rotate[%s]%n", region.name, region.left, region.top, region.width, region.height, region.rotate);
                }
                if (region.page != page) continue;
                Pixmap splitImage = null;
                String extension = null;
                if (region.splits == null) {
                    splitImage = this.extractImage(img, region, 0);
                    if (region.width != region.originalWidth || region.height != region.originalHeight) {
                        Pixmap originalImg = new Pixmap(region.originalWidth, region.originalHeight);
                        originalImg.draw(splitImage, (int)region.offsetX, (int)((float)(region.originalHeight - region.height) - region.offsetY));
                        splitImage = originalImg;
                    }
                    extension = ".png";
                } else {
                    splitImage = this.extractNinePatch(img, region);
                    extension = "9.png";
                }
                File imgOutput = new File(outputDirFile, region.name + extension);
                File imgDir = imgOutput.getParentFile();
                if (!imgDir.exists()) {
                    if (!quiet) {
                        System.out.printf("Creating directory: %s%n", imgDir.getPath());
                    }
                    imgDir.mkdirs();
                }
                new Fi(imgOutput).writePng(splitImage);
            }
        }
    }

    private Pixmap extractImage(Pixmap page, TextureAtlas.TextureAtlasData.Region region, int padding) {
        Pixmap splitImage = page.crop(region.left, region.top, region.width, region.height);
        if (padding > 0) {
            Pixmap paddedImage = new Pixmap(splitImage.getWidth() + padding * 2, splitImage.getHeight() + padding * 2);
            paddedImage.draw(splitImage, padding, padding);
            return paddedImage;
        }
        return splitImage;
    }

    private Pixmap extractNinePatch(Pixmap page, TextureAtlas.TextureAtlasData.Region region) {
        Pixmap splitImage = this.extractImage(page, region, 1);
        int startX = region.splits[0] + 1;
        int endX = region.width - region.splits[1] + 1 - 1;
        int startY = region.splits[2] + 1;
        int endY = region.height - region.splits[3] + 1 - 1;
        if (endX >= startX) {
            splitImage.drawLine(startX, 0, endX, 0, Color.blackRgba);
        }
        if (endY >= startY) {
            splitImage.drawLine(0, startY, 0, endY, Color.blackRgba);
        }
        if (region.pads != null) {
            int padStartX = region.pads[0] + 1;
            int padEndX = region.width - region.pads[1] + 1 - 1;
            int padStartY = region.pads[2] + 1;
            int padEndY = region.height - region.pads[3] + 1 - 1;
            splitImage.drawLine(padStartX, splitImage.getHeight() - 1, padEndX, splitImage.getHeight() - 1, Color.blackRgba);
            splitImage.drawLine(splitImage.getWidth() - 1, padStartY, splitImage.getWidth() - 1, padEndY, Color.blackRgba);
        }
        return splitImage;
    }

    public static void main(String[] args) {
        TextureUnpacker unpacker = new TextureUnpacker();
        String atlasFile = null;
        String imageDir = null;
        String outputDir = null;
        switch (unpacker.parseArguments(args)) {
            case 0: {
                System.out.println(HELP);
                return;
            }
            case 3: {
                outputDir = args[2];
            }
            case 2: {
                imageDir = args[1];
            }
            case 1: {
                atlasFile = args[0];
            }
        }
        File atlasFileHandle = new File(atlasFile).getAbsoluteFile();
        if (!atlasFileHandle.exists()) {
            throw new RuntimeException("Atlas file not found: " + atlasFileHandle.getAbsolutePath());
        }
        String atlasParentPath = atlasFileHandle.getParentFile().getAbsolutePath();
        if (imageDir == null) {
            imageDir = atlasParentPath;
        }
        if (outputDir == null) {
            outputDir = new File(atlasParentPath, DEFAULT_OUTPUT_PATH).getAbsolutePath();
        }
        TextureAtlas.TextureAtlasData atlas = new TextureAtlas.TextureAtlasData(new Fi(atlasFile), new Fi(imageDir), false);
        unpacker.splitAtlas(atlas, outputDir, false);
    }
}

