/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.func.Intc2;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;

public class Bresenham2 {
    private final Seq<Point2> points = new Seq();
    private final Pool<Point2> pool = Pools.get(Point2.class, Point2::new);

    public static void line(int startX, int startY, int endX, int endY, Intc2 consumer) {
        int dx = Math.abs(endX - startX);
        int dy = Math.abs(endY - startY);
        int sx = startX < endX ? 1 : -1;
        int sy = startY < endY ? 1 : -1;
        int err = dx - dy;
        while (true) {
            consumer.get(startX, startY);
            if (startX == endX && startY == endY) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                startX += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            startY += sy;
        }
    }

    public Seq<Point2> line(Point2 start, Point2 end) {
        return this.line(start.x, start.y, end.x, end.y);
    }

    public Seq<Point2> line(int startX, int startY, int endX, int endY) {
        this.pool.freeAll(this.points);
        this.points.clear();
        return this.line(startX, startY, endX, endY, this.pool, this.points);
    }

    public Seq<Point2> line(int startX, int startY, int endX, int endY, Pool<Point2> pool, Seq<Point2> output) {
        int w = endX - startX;
        int h = endY - startY;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
            dx2 = -1;
        } else if (w > 0) {
            dx1 = 1;
            dx2 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
        }
        int numerator = longest >> 1;
        for (int i = 0; i <= longest; ++i) {
            Point2 point = pool.obtain();
            point.set(startX, startY);
            output.add(point);
            if ((numerator += shortest) > longest) {
                numerator -= longest;
                startX += dx1;
                startY += dy1;
                continue;
            }
            startX += dx2;
            startY += dy2;
        }
        return output;
    }

    public Seq<Point2> lineNoDiagonal(int startX, int startY, int endX, int endY, Pool<Point2> pool, Seq<Point2> output) {
        int xDist = Math.abs(endX - startX);
        int yDist = -Math.abs(endY - startY);
        int xStep = startX < endX ? 1 : -1;
        int yStep = startY < endY ? 1 : -1;
        int error = xDist + yDist;
        output.add(pool.obtain().set(startX, startY));
        while (startX != endX || startY != endY) {
            if (2 * error - yDist > xDist - 2 * error) {
                error += yDist;
                startX += xStep;
            } else {
                error += xDist;
                startY += yStep;
            }
            output.add(pool.obtain().set(startX, startY));
        }
        return output;
    }
}

