/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.graphics.CacheLayer;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.TileBitmask;
import mindustry.world.blocks.environment.Prop;

public class StaticWall
extends Prop {
    public TextureRegion large;
    public TextureRegion[][] split;
    public boolean autotile;
    public int autotileMidVariants = 1;
    protected TextureRegion[] autotileRegions;
    protected TextureRegion[] autotileMidRegions;

    public StaticWall(String name) {
        super(name);
        this.unitMoveBreakable = false;
        this.alwaysReplace = false;
        this.breakable = false;
        this.solid = true;
        this.variants = 2;
        this.cacheLayer = CacheLayer.walls;
        this.allowRectanglePlacement = true;
        this.placeEffect = Fx.rotateBlock;
        this.instantBuild = true;
        this.ignoreBuildDarkness = true;
        this.placeableLiquid = true;
    }

    @Override
    public void drawBase(Tile tile) {
        if (this.autotile) {
            int bits = 0;
            for (int i = 0; i < 8; ++i) {
                Tile other = tile.nearby(Geometry.d8[i]);
                if (!this.checkAutotileSame(tile, other)) continue;
                bits |= 1 << i;
            }
            int bit = TileBitmask.values[bits];
            TextureRegion region = bit == 13 && this.autotileMidVariants > 1 ? this.autotileMidRegions[this.variant(tile.x, tile.y, this.autotileMidRegions.length)] : this.autotileRegions[bit];
            Draw.rect(region, tile.worldx(), tile.worldy());
        } else {
            int rx = tile.x / 2 * 2;
            int ry = tile.y / 2 * 2;
            if (Core.atlas.isFound(this.large) && this.eq(rx, ry) && (double)Mathf.randomSeed(Point2.pack(rx, ry)) < 0.5 && this.split.length >= 2 && this.split[0].length >= 2) {
                Draw.rect(this.split[tile.x % 2][1 - tile.y % 2], tile.worldx(), tile.worldy());
            } else if (this.variants > 0) {
                Draw.rect(this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx(), tile.worldy());
            } else {
                Draw.rect(this.region, tile.worldx(), tile.worldy());
            }
        }
        if (tile.overlay().wallOre) {
            tile.overlay().drawBase(tile);
        }
    }

    public int variant(int x, int y, int max) {
        return Mathf.randomSeed((long)Point2.pack(x, y), 0, Math.max(0, max - 1));
    }

    public boolean checkAutotileSame(Tile tile, @Nullable Tile other) {
        return other != null && other.block() == this;
    }

    @Override
    public void load() {
        super.load();
        int size = this.large.width / 2;
        this.split = this.large.split(size, size);
        if (this.split != null) {
            TextureRegion[][] textureRegionArray = this.split;
            int n = textureRegionArray.length;
            for (int i = 0; i < n; ++i) {
                TextureRegion[] arr;
                for (TextureRegion reg : arr = textureRegionArray[i]) {
                    reg.scale = this.region.scale;
                }
            }
        }
        if (this.autotile) {
            this.autotileRegions = TileBitmask.load(this.name);
            if (this.autotileMidVariants > 1) {
                this.autotileMidRegions = new TextureRegion[this.autotileMidVariants];
                for (int i = 0; i < this.autotileMidVariants; ++i) {
                    this.autotileMidRegions[i] = Core.atlas.find(i == 0 ? this.name + "-13" : this.name + "-mid-" + (i + 1));
                }
            }
        }
    }

    @Override
    public boolean canReplace(Block other) {
        return other instanceof StaticWall || super.canReplace(other);
    }

    boolean eq(int rx, int ry) {
        return rx < Vars.world.width() - 1 && ry < Vars.world.height() - 1 && Vars.world.tile(rx + 1, ry).block() == this && Vars.world.tile(rx, ry + 1).block() == this && Vars.world.tile(rx, ry).block() == this && Vars.world.tile(rx + 1, ry + 1).block() == this;
    }
}

