/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;

public class ClearFilter
extends GenerateFilter {
    public Block target = Blocks.stone;
    public Block replace = Blocks.air;
    public Block ignore = Blocks.air;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.BlockOption("target", () -> this.target, b -> {
            this.target = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("replacement", () -> this.replace, b -> {
            this.replace = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("ignore", () -> this.ignore, b -> {
            this.ignore = b;
        }, FilterOption.anyOptional)};
    }

    @Override
    public char icon() {
        return '\uf8ec';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        if (this.ignore != Blocks.air && (in.block == this.ignore || in.floor == this.ignore || in.overlay == this.ignore)) {
            return;
        }
        if (in.block == this.target || in.floor == this.target || this.target.isOverlay() && in.overlay == this.target) {
            if (this.replace == Blocks.air) {
                if (in.overlay == this.target) {
                    in.overlay = Blocks.air;
                } else {
                    in.block = Blocks.air;
                }
            } else if (this.replace.isOverlay()) {
                in.overlay = this.replace;
            } else if (this.replace.isFloor()) {
                in.floor = this.replace;
            } else {
                in.block = this.replace;
            }
        }
    }
}

