/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.graphics.Shaders;

public class CacheLayer {
    public static CacheLayer water;
    public static CacheLayer mud;
    public static CacheLayer cryofluid;
    public static CacheLayer tar;
    public static CacheLayer slag;
    public static CacheLayer arkycite;
    public static CacheLayer space;
    public static CacheLayer normal;
    public static CacheLayer walls;
    public static CacheLayer[] all;
    public int id;
    public boolean liquid;

    public static void add(CacheLayer ... layers) {
        for (CacheLayer layer : layers) {
            CacheLayer.add(7, layer);
        }
    }

    public static void addLast(CacheLayer ... layers) {
        int newSize = all.length + layers.length;
        CacheLayer[] prev = all;
        all = new CacheLayer[newSize];
        System.arraycopy(prev, 0, all, 0, prev.length);
        System.arraycopy(layers, 0, all, prev.length, layers.length);
        for (int i = 0; i < all.length; ++i) {
            CacheLayer.all[i].id = i;
        }
    }

    public static void add(int index, CacheLayer layer) {
        index = Mathf.clamp(index, 0, all.length - 1);
        CacheLayer[] prev = all;
        all = new CacheLayer[all.length + 1];
        System.arraycopy(prev, 0, all, 0, index);
        System.arraycopy(prev, index, all, index + 1, prev.length - index);
        CacheLayer.all[index] = layer;
        for (int i = 0; i < all.length; ++i) {
            CacheLayer.all[i].id = i;
        }
    }

    public static void init() {
        water = new ShaderLayer(Shaders.water);
        mud = new ShaderLayer(Shaders.mud);
        tar = new ShaderLayer(Shaders.tar);
        slag = new ShaderLayer(Shaders.slag);
        arkycite = new ShaderLayer(Shaders.arkycite);
        cryofluid = new ShaderLayer(Shaders.cryofluid);
        space = new ShaderLayer(Shaders.space, false);
        normal = new CacheLayer();
        walls = new CacheLayer();
        CacheLayer.addLast(water, mud, tar, slag, arkycite, cryofluid, space, normal, walls);
    }

    public void begin() {
    }

    public void end() {
    }

    static {
        all = new CacheLayer[0];
    }

    public static class ShaderLayer
    extends CacheLayer {
        @Nullable
        public Shader shader;

        public ShaderLayer(Shader shader) {
            this(shader, true);
        }

        public ShaderLayer(@Nullable Shader shader, boolean liquid) {
            this.liquid = liquid;
            this.shader = shader;
        }

        @Override
        public void begin() {
            if (!Vars.renderer.animateWater) {
                return;
            }
            Vars.renderer.effectBuffer.begin();
            Core.graphics.clear(Color.clear);
            Vars.renderer.blocks.floor.beginDraw();
        }

        @Override
        public void end() {
            if (!Vars.renderer.animateWater) {
                return;
            }
            Vars.renderer.effectBuffer.end();
            Vars.renderer.effectBuffer.blit(this.shader);
            Vars.renderer.blocks.floor.beginDraw();
        }
    }
}

