/*
 * Decompiled with CFR 0.152.
 */
package arc.util.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public class ByteBufferOutput
implements DataOutput {
    public ByteBuffer buffer;

    public ByteBufferOutput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferOutput() {
    }

    @Override
    public void write(int i) {
        this.buffer.put((byte)i);
    }

    @Override
    public void write(byte[] bytes) {
        this.buffer.put(bytes);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.buffer.put(bytes, off, len);
    }

    @Override
    public void writeBoolean(boolean b) {
        this.buffer.put(b ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int i) {
        this.buffer.put((byte)i);
    }

    @Override
    public void writeShort(int i) {
        this.buffer.putShort((short)i);
    }

    @Override
    public void writeChar(int i) {
        this.buffer.putChar((char)i);
    }

    @Override
    public void writeInt(int i) {
        this.buffer.putInt(i);
    }

    @Override
    public void writeLong(long l) {
        this.buffer.putLong(l);
    }

    @Override
    public void writeFloat(float v) {
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void writeChars(String s) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void writeUTF(String s) throws IOException {
        char c;
        int strlen;
        int utflen = strlen = s.length();
        for (int i = 0; i < strlen; ++i) {
            char c2 = s.charAt(i);
            if (c2 < '\u0080' && c2 != '\u0000') continue;
            utflen += c2 >= '\u0800' ? 2 : 1;
        }
        if (utflen > 65535 || utflen < strlen) {
            throw new UTFDataFormatException("encoded string too long");
        }
        byte[] bytearr = new byte[utflen + 2];
        int count = 0;
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = s.charAt(i)) < '\u0080' && c != '\u0000'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = s.charAt(i);
            if (c < '\u0080' && c != '\u0000') {
                bytearr[count++] = (byte)c;
            } else if (c >= '\u0800') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.write(bytearr, 0, utflen + 2);
    }
}

