/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Sounds;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Prop;

public class WobbleProp
extends Prop {
    public float wscl = 25.0f;
    public float wmag = 0.4f;
    public float wtscl = 1.0f;
    public float wmag2 = 1.0f;

    public WobbleProp(String name) {
        super(name);
        this.breakSound = Sounds.plantBreak;
    }

    @Override
    public void drawBase(Tile tile) {
        TextureRegion region = this.variants > 0 ? this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))] : this.region;
        Draw.rectv(region, tile.worldx(), tile.worldy(), (float)region.width * region.scl(), (float)region.height * region.scl(), 0.0f, vec -> vec.add(Mathf.sin(vec.y * 3.0f + Time.time, this.wscl, this.wmag) + Mathf.sin(vec.x * 3.0f - Time.time, 70.0f * this.wtscl, 0.8f * this.wmag2), Mathf.cos(vec.x * 3.0f + Time.time + 8.0f, this.wscl + 6.0f, this.wmag * 1.1f) + Mathf.sin(vec.y * 3.0f - Time.time, 50.0f * this.wtscl, 0.2f * this.wmag2)));
    }
}

