/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.Slider;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Tmp;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.ui.dialogs.BaseDialog;

public class ColorPicker
extends BaseDialog {
    private static Texture hueTex;
    private Cons<Color> cons = c -> {};
    Color current = new Color();
    float h;
    float s;
    float v;
    float a;
    TextField hexField;
    Slider hSlider;
    Slider sSlider;
    Slider vSlider;
    Slider aSlider;

    public ColorPicker() {
        super("@pickcolor");
    }

    public void show(Color color, Cons<Color> consumer) {
        this.show(color, true, consumer);
    }

    public void show(Color color, boolean alpha, Cons<Color> consumer) {
        this.current.set(color);
        this.cons = consumer;
        this.show();
        if (hueTex == null) {
            hueTex = Pixmaps.hueTexture(128, 1);
            hueTex.setFilter(Texture.TextureFilter.linear);
        }
        float[] values = color.toHsv(new float[3]);
        this.h = values[0];
        this.s = values[1];
        this.v = values[2];
        this.a = color.a;
        this.cont.clear();
        this.cont.pane((Table t) -> {
            t.table(Tex.pane, i -> i.stack(new Image(Tex.alphaBg), new Image(){
                {
                    this.setColor(ColorPicker.this.current);
                    this.update(() -> this.setColor(ColorPicker.this.current));
                }
            }).size(200.0f)).colspan(2).padBottom(5.0f);
            t.row();
            t.defaults().padBottom(6.0f).width(370.0f).height(44.0f);
            Element[] elementArray = new Element[2];
            elementArray[0] = new Image(new TextureRegion(hueTex));
            this.hSlider = new Slider(0.0f, 360.0f, 0.3f, false){
                {
                    this.setValue(ColorPicker.this.h);
                    this.moved(value -> {
                        ColorPicker.this.h = value;
                        ColorPicker.this.updateColor();
                    });
                }
            };
            elementArray[1] = this.hSlider;
            t.stack(elementArray).row();
            Element[] elementArray2 = new Element[2];
            elementArray2[0] = new Element(){

                @Override
                public void draw() {
                    float first = Tmp.c1.set(ColorPicker.this.current).saturation(0.0f).a(this.parentAlpha).toFloatBits();
                    float second = Tmp.c1.set(ColorPicker.this.current).saturation(1.0f).a(this.parentAlpha).toFloatBits();
                    Fill.quad(this.x, this.y, first, this.x + this.width, this.y, second, this.x + this.width, this.y + this.height, second, this.x, this.y + this.height, first);
                }
            };
            this.sSlider = new Slider(0.0f, 1.0f, 0.001f, false){
                {
                    this.setValue(ColorPicker.this.s);
                    this.moved(value -> {
                        ColorPicker.this.s = value;
                        ColorPicker.this.updateColor();
                    });
                }
            };
            elementArray2[1] = this.sSlider;
            t.stack(elementArray2).row();
            Element[] elementArray3 = new Element[2];
            elementArray3[0] = new Element(){

                @Override
                public void draw() {
                    float first = Tmp.c1.set(ColorPicker.this.current).value(0.0f).a(this.parentAlpha).toFloatBits();
                    float second = Tmp.c1.fromHsv(ColorPicker.this.h, ColorPicker.this.s, 1.0f).a(this.parentAlpha).toFloatBits();
                    Fill.quad(this.x, this.y, first, this.x + this.width, this.y, second, this.x + this.width, this.y + this.height, second, this.x, this.y + this.height, first);
                }
            };
            this.vSlider = new Slider(0.0f, 1.0f, 0.001f, false){
                {
                    this.setValue(ColorPicker.this.v);
                    this.moved(value -> {
                        ColorPicker.this.v = value;
                        ColorPicker.this.updateColor();
                    });
                }
            };
            elementArray3[1] = this.vSlider;
            t.stack(elementArray3).row();
            if (alpha) {
                Element[] elementArray4 = new Element[3];
                elementArray4[0] = new Image(Tex.alphaBgLine);
                elementArray4[1] = new Element(){

                    @Override
                    public void draw() {
                        float first = Tmp.c1.set(ColorPicker.this.current).a(0.0f).toFloatBits();
                        float second = Tmp.c1.set(ColorPicker.this.current).a(this.parentAlpha).toFloatBits();
                        Fill.quad(this.x, this.y, first, this.x + this.width, this.y, second, this.x + this.width, this.y + this.height, second, this.x, this.y + this.height, first);
                    }
                };
                this.aSlider = new Slider(0.0f, 1.0f, 0.001f, false){
                    {
                        this.setValue(ColorPicker.this.a);
                        this.moved(value -> {
                            ColorPicker.this.a = value;
                            ColorPicker.this.updateColor();
                        });
                    }
                };
                elementArray4[2] = this.aSlider;
                t.stack(elementArray4).row();
            }
            this.hexField = t.field(this.current.toString(), value -> {
                try {
                    Color.valueOf(this.current, value);
                    this.current.toHsv(values);
                    this.h = values[0];
                    this.s = values[1];
                    this.v = values[2];
                    this.a = this.current.a;
                    this.hSlider.setValue(this.h);
                    this.sSlider.setValue(this.s);
                    this.vSlider.setValue(this.v);
                    if (this.aSlider != null) {
                        this.aSlider.setValue(this.a);
                    }
                    this.updateColor(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).size(130.0f, 40.0f).valid(text -> {
                try {
                    Color.valueOf(text);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }).get();
        }).grow();
        this.buttons.clear();
        this.addCloseButton();
        this.buttons.button("@ok", Icon.ok, () -> {
            this.cons.get(this.current);
            this.hide();
        });
    }

    void updateColor() {
        this.updateColor(true);
    }

    void updateColor(boolean updateField) {
        this.current.fromHsv(this.h, this.s, this.v);
        this.current.a = this.a;
        if (this.hexField != null && updateField) {
            String val = this.current.toString();
            if (this.current.a >= 0.9999f) {
                val = val.substring(0, 6);
            }
            this.hexField.setText(val);
        }
    }
}

