/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Core;
import arc.Files;
import arc.files.Fi;
import arc.struct.ObjectMap;
import arc.util.OS;
import arc.util.Strings;
import arc.util.io.PropertiesUtils;

public class Version {
    public static String type = "unknown";
    public static String modifier = "unknown";
    public static String commitHash = "unknown";
    public static String buildDate = "unknown";
    public static int number;
    public static int build;
    public static int revision;
    public static boolean enabled;

    public static void init() {
        if (!enabled) {
            return;
        }
        Fi file = OS.isAndroid || OS.isIos ? Core.files.internal("version.properties") : new Fi("version.properties", Files.FileType.internal);
        ObjectMap<String, String> map = new ObjectMap<String, String>();
        PropertiesUtils.load(map, file.reader());
        type = map.get("type");
        number = Integer.parseInt(map.get("number", "4"));
        modifier = map.get("modifier");
        commitHash = map.get("commitHash", "unknown");
        buildDate = map.get("buildDate", "unknown");
        if (map.get("build").contains(".")) {
            String[] split = map.get("build").split("\\.");
            try {
                build = Integer.parseInt(split[0]);
                revision = Integer.parseInt(split[1]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                build = -1;
            }
        } else {
            build = Strings.canParseInt(map.get("build")) ? Integer.parseInt(map.get("build")) : -1;
        }
    }

    public static boolean isAtLeast(String str) {
        return Version.isAtLeast(build, revision, str);
    }

    public static boolean isAtLeast(int build, int revision, String str) {
        if (build <= 0 || str == null || str.isEmpty()) {
            return true;
        }
        int dot = str.indexOf(46);
        if (dot != -1) {
            int major = Strings.parseInt(str.substring(0, dot), 0);
            int minor = Strings.parseInt(str.substring(dot + 1), 0);
            return build > major || build == major && revision >= minor;
        }
        return build >= Strings.parseInt(str, 0);
    }

    public static String buildString() {
        return build < 0 ? "custom" : build + (revision == 0 ? "" : "." + revision);
    }

    public static String combined() {
        if (build == -1) {
            return "custom build";
        }
        return (type.equals("official") ? modifier : type) + " build " + build + (revision == 0 ? "" : "." + revision) + (commitHash.equals("unknown") ? "" : " (" + commitHash + ")");
    }

    static {
        build = 0;
        revision = 0;
        enabled = true;
    }
}

