/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawSoftParticles
extends DrawBlock {
    public TextureRegion region;
    public Color color = Color.valueOf("e3ae6f");
    public Color color2 = Color.valueOf("d04d46");
    public float x = 0.0f;
    public float y = 0.0f;
    public float alpha = 0.5f;
    public int particles = 30;
    public float particleLife = 70.0f;
    public float particleRad = 7.0f;
    public float particleSize = 3.0f;
    public float fadeMargin = 0.4f;
    public float rotateScl = 1.5f;
    public Interp particleInterp = new Interp.PowIn(1.5f);

    @Override
    public void draw(Building build) {
        if (build.warmup() > 0.0f && this.color.a > 0.001f) {
            float a = this.alpha * build.warmup();
            Draw.color(this.color, a);
            Draw.blend(Blending.additive);
            float base = Time.time / this.particleLife;
            rand.setSeed(build.id);
            for (int i = 0; i < this.particles; ++i) {
                float fin = (rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                fin = 1.0f - fin;
                fout = 1.0f - fout;
                float angle = rand.random(360.0f) + Time.time / this.rotateScl % 360.0f;
                float col = rand.random(1.0f);
                Draw.tint(this.color, this.color2, col);
                float len = this.particleRad * this.particleInterp.apply(fout);
                Draw.alpha(a * (1.0f - Mathf.curve(fin, 1.0f - this.fadeMargin)));
                float r = this.particleSize * fin * build.warmup() * 2.0f;
                Draw.rect(this.region, build.x + this.x + Angles.trnsx(angle, len), build.y + this.y + Angles.trnsy(angle, len), r, r);
            }
            Draw.blend();
            Draw.reset();
        }
    }

    @Override
    public void load(Block block) {
        super.load(block);
        this.region = Core.atlas.find("circle-shadow");
    }
}

