/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawGlowRegion
extends DrawBlock {
    public Blending blending = Blending.additive;
    public String suffix = "-glow";
    public float alpha = 0.9f;
    public float glowScale = 10.0f;
    public float glowIntensity = 0.5f;
    public float rotateSpeed = 0.0f;
    public float layer = 31.0f;
    public boolean rotate = false;
    public Color color = Color.red.cpy();
    public TextureRegion region;

    public DrawGlowRegion() {
    }

    public DrawGlowRegion(float layer) {
        this.layer = layer;
    }

    public DrawGlowRegion(boolean rotate) {
        this.rotate = rotate;
    }

    public DrawGlowRegion(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void draw(Building build) {
        if (build.warmup() <= 0.001f) {
            return;
        }
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        Draw.blend(this.blending);
        Draw.color(this.color);
        Draw.alpha((Mathf.absin(build.totalProgress(), this.glowScale, this.alpha) * this.glowIntensity + 1.0f - this.glowIntensity) * build.warmup() * this.alpha);
        Draw.rect(this.region, build.x, build.y, build.totalProgress() * this.rotateSpeed + (this.rotate ? build.rotdeg() : 0.0f));
        Draw.reset();
        Draw.blend();
        Draw.z(z);
    }

    @Override
    public void load(Block block) {
        this.region = Core.atlas.find(block.name + this.suffix);
    }
}

