/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawCells
extends DrawBlock {
    public TextureRegion middle;
    public Color color = Color.white.cpy();
    public Color particleColorFrom = Color.black.cpy();
    public Color particleColorTo = Color.black.cpy();
    public int particles = 12;
    public float range = 4.0f;
    public float recurrence = 2.0f;
    public float radius = 1.8f;
    public float lifetime = 180.0f;

    @Override
    public void draw(Building build) {
        Drawf.liquid(this.middle, build.x, build.y, build.warmup(), this.color);
        if (build.warmup() > 0.001f) {
            rand.setSeed(build.id);
            for (int i = 0; i < this.particles; ++i) {
                float offset = rand.nextFloat() * 999999.0f;
                float x = rand.range(this.range);
                float y = rand.range(this.range);
                float fin = 1.0f - (Time.time + offset) / this.lifetime % this.recurrence;
                float ca = rand.random(0.1f, 1.0f);
                float fslope = Mathf.slope(fin);
                if (!(fin > 0.0f)) continue;
                Draw.color(this.particleColorFrom, this.particleColorTo, ca);
                Draw.alpha(build.warmup());
                Fill.circle(build.x + x, build.y + y, fslope * this.radius);
            }
        }
        Draw.color();
    }

    @Override
    public void load(Block block) {
        this.middle = Core.atlas.find(block.name + "-middle");
    }
}

