/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawBlurSpin
extends DrawBlock {
    public TextureRegion region;
    public TextureRegion blurRegion;
    public String suffix = "";
    public float rotateSpeed = 1.0f;
    public float x;
    public float y;
    public float blurThresh = 0.7f;

    public DrawBlurSpin(String suffix, float speed) {
        this.suffix = suffix;
        this.rotateSpeed = speed;
    }

    public DrawBlurSpin() {
    }

    @Override
    public void draw(Building build) {
        Drawf.spinSprite(build.warmup() > this.blurThresh ? this.blurRegion : this.region, build.x + this.x, build.y + this.y, build.totalProgress() * this.rotateSpeed);
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.region};
    }

    @Override
    public void load(Block block) {
        this.region = Core.atlas.find(block.name + this.suffix);
        this.blurRegion = Core.atlas.find(block.name + this.suffix + "-blur");
    }
}

