/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Separator
extends Block {
    @Nullable
    protected ConsumeItems consItems;
    public ItemStack[] results;
    public float craftTime;
    public DrawBlock drawer = new DrawDefault();

    public Separator(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.hasLiquids = true;
        this.sync = true;
    }

    @Override
    public void setStats() {
        this.stats.timePeriod = this.craftTime;
        super.setStats();
        int[] sum = new int[]{0};
        for (ItemStack r : this.results) {
            sum[0] = sum[0] + r.amount;
        }
        this.stats.add(Stat.output, table -> {
            for (ItemStack stack : this.results) {
                table.add(StatValues.displayItemPercent(stack.item, (int)((float)stack.amount / (float)sum[0] * 100.0f), true)).padRight(5.0f);
            }
        });
        this.stats.add(Stat.productionTime, this.craftTime / 60.0f, StatUnit.seconds);
    }

    @Override
    public void init() {
        super.init();
        this.consItems = (ConsumeItems)this.findConsumer(c -> c instanceof ConsumeItems);
    }

    @Override
    public void load() {
        super.load();
        this.drawer.load(this);
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan(this, plan, list);
    }

    @Override
    public TextureRegion[] icons() {
        return this.drawer.finalIcons(this);
    }

    public class SeparatorBuild
    extends Building {
        public float progress;
        public float totalProgress;
        public float warmup;
        public int seed;

        @Override
        public void created() {
            this.seed = Mathf.randomSeed((long)this.tile.pos(), 0, 0x7FFFFFFE);
        }

        @Override
        public boolean shouldAmbientSound() {
            return this.efficiency > 0.0f;
        }

        @Override
        public boolean shouldConsume() {
            int total = this.items.total();
            if (Separator.this.consItems != null) {
                for (ItemStack stack : Separator.this.consItems.items) {
                    total -= this.items.get(stack.item);
                }
            }
            return total < Separator.this.itemCapacity && this.enabled;
        }

        @Override
        public void draw() {
            Separator.this.drawer.draw(this);
        }

        @Override
        public void drawLight() {
            super.drawLight();
            Separator.this.drawer.drawLight(this);
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public float progress() {
            return this.progress;
        }

        @Override
        public float totalProgress() {
            return this.totalProgress;
        }

        @Override
        public void updateTile() {
            this.totalProgress += this.warmup * this.delta();
            if (this.efficiency > 0.0f) {
                this.progress += this.getProgressIncrease(Separator.this.craftTime);
                this.warmup = Mathf.lerpDelta(this.warmup, 1.0f, 0.02f);
            } else {
                this.warmup = Mathf.lerpDelta(this.warmup, 0.0f, 0.02f);
            }
            if (this.progress >= 1.0f) {
                this.progress %= 1.0f;
                int sum = 0;
                for (ItemStack stack : Separator.this.results) {
                    sum += stack.amount;
                }
                int i = Mathf.randomSeed((long)this.seed++, 0, sum - 1);
                int count = 0;
                Item item = null;
                for (ItemStack stack : Separator.this.results) {
                    if (i >= count && i < count + stack.amount) {
                        item = stack.item;
                        break;
                    }
                    count += stack.amount;
                }
                this.consume();
                if (item != null && this.items.get(item) < Separator.this.itemCapacity) {
                    this.offload(item);
                }
            }
            if (this.timer(Separator.this.timerDump, (float)Separator.this.dumpTime / this.timeScale)) {
                this.dump();
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress;
            }
            return super.sense(sensor);
        }

        @Override
        public boolean canDump(Building to, Item item) {
            return !Separator.this.consumesItem(item);
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.warmup);
            write.i(this.seed);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.warmup = read.f();
            if (revision == 1) {
                this.seed = read.i();
            }
        }
    }
}

