/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import mindustry.game.Team;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;

public class AttributeCrafter
extends GenericCrafter {
    public Attribute attribute = Attribute.heat;
    public float baseEfficiency = 1.0f;
    public float boostScale = 1.0f;
    public float maxBoost = 1.0f;
    public float minEfficiency = -1.0f;
    public float displayEfficiencyScale = 1.0f;
    public boolean displayEfficiency = true;
    public boolean scaleLiquidConsumption = false;

    public AttributeCrafter(String name) {
        super(name);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (!this.displayEfficiency) {
            return;
        }
        this.drawPlaceText(Core.bundle.format("bar.efficiency", (int)((this.baseEfficiency + Math.min(this.maxBoost, this.boostScale * this.sumAttribute(this.attribute, x, y))) * 100.0f)), x, y, valid);
    }

    @Override
    public void setBars() {
        super.setBars();
        if (!this.displayEfficiency) {
            return;
        }
        this.addBar("efficiency", entity -> new Bar(() -> Core.bundle.format("bar.efficiency", (int)(entity.efficiencyMultiplier() * 100.0f * this.displayEfficiencyScale)), () -> Pal.lightOrange, entity::efficiencyMultiplier));
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return this.baseEfficiency + tile.getLinkedTilesAs((Block)this, tempTiles).sumf(other -> other.floor().attributes.get(this.attribute)) >= this.minEfficiency;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(this.baseEfficiency <= 1.0E-4f ? Stat.tiles : Stat.affinities, this.attribute, this.floating, this.boostScale * (float)this.size * (float)this.size, !this.displayEfficiency);
    }

    public class AttributeCrafterBuild
    extends GenericCrafter.GenericCrafterBuild {
        public float attrsum;

        public AttributeCrafterBuild() {
            super(AttributeCrafter.this);
        }

        @Override
        public float getProgressIncrease(float base) {
            return super.getProgressIncrease(base) * this.efficiencyMultiplier();
        }

        public float efficiencyMultiplier() {
            return AttributeCrafter.this.baseEfficiency + Math.min(AttributeCrafter.this.maxBoost, AttributeCrafter.this.boostScale * this.attrsum) + AttributeCrafter.this.attribute.env();
        }

        @Override
        public float efficiencyScale() {
            return AttributeCrafter.this.scaleLiquidConsumption ? this.efficiencyMultiplier() : super.efficiencyScale();
        }

        @Override
        public void pickedUp() {
            this.attrsum = 0.0f;
            this.warmup = 0.0f;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.attrsum = AttributeCrafter.this.sumAttribute(AttributeCrafter.this.attribute, this.tile.x, this.tile.y);
        }
    }
}

