/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.CharOverlayData;
import mindustry.gen.Unit;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.OverlayFloor;

public class CharacterOverlay
extends OverlayFloor {
    public static final String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890\"!?.,;:()[]{}<>|/@\\^-%+=#_&~";
    public TextureRegion[] letterRegions;
    public Color color = Color.white;

    public CharacterOverlay(String name) {
        super(name);
        this.saveData = true;
        this.variants = 0;
        this.rotate = true;
        this.drawArrow = false;
        this.saveConfig = true;
        this.editorConfigurable = true;
    }

    @Override
    public void drawBase(Tile tile) {
        Draw.color(this.color);
        byte letterChar = CharOverlayData.character(tile.overlayData);
        Draw.rect(this.letterRegions[letterChar], tile.worldx(), tile.worldy(), (float)CharOverlayData.rotation(tile.overlayData) * 90.0f);
        Draw.color();
    }

    @Override
    public Object getConfig(Tile tile) {
        return (int)tile.overlayData;
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        byte data = 0;
        Object object = plan.config;
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            data = i.byteValue();
        }
        byte letterChar = CharOverlayData.character(data);
        TextureRegion reg = this.letterRegions[letterChar];
        Draw.tint(this.color);
        Draw.rect(reg, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.tint(Color.white);
    }

    @Override
    public void onPicked(Tile tile) {
        Vars.control.input.rotation = CharOverlayData.rotation(tile.overlayData);
    }

    @Override
    public void buildEditorConfig(Table table) {
        int n;
        Object object = this.lastConfig;
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            n = CharOverlayData.character(i.byteValue());
        } else {
            n = 0;
        }
        char value = chars.charAt(n);
        table.field(value + "", val -> {
            if (val.length() == 1) {
                this.lastConfig = (int)CharacterOverlay.charToData(val.charAt(0));
            }
        }).valid(t -> t.length() == 1 && chars.indexOf(Character.toUpperCase(t.charAt(0))) != -1).maxTextLength(1);
    }

    @Override
    public void placeEnded(Tile tile, @Nullable Unit builder, int rotation, @Nullable Object config) {
        byte data = 0;
        if (config instanceof Integer) {
            Integer i = (Integer)config;
            data = i.byteValue();
        }
        tile.overlayData = CharOverlayData.get(data, (byte)rotation);
    }

    @Override
    public void editorPicked(Tile tile) {
        this.lastConfig = (int)CharOverlayData.character(tile.overlayData);
    }

    public static byte charToData(char c) {
        int index = chars.indexOf(Character.toUpperCase(c));
        return index == -1 ? (byte)0 : (byte)index;
    }

    class CharOverlayDataStruct {
        byte character;
        byte rotation;

        CharOverlayDataStruct() {
        }
    }
}

