/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.blocks.distribution.DirectionBridge;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.meta.BlockGroup;

public class DirectionLiquidBridge
extends DirectionBridge {
    public final int timerFlow;
    public float speed;
    public float liquidPadding;
    public TextureRegion bottomRegion;

    public DirectionLiquidBridge(String name) {
        super(name);
        this.timerFlow = this.timers++;
        this.speed = 5.0f;
        this.liquidPadding = 1.0f;
        this.outputsLiquid = true;
        this.group = BlockGroup.liquids;
        this.canOverdrive = false;
        this.liquidCapacity = 20.0f;
        this.hasLiquids = true;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.region, this.dirRegion};
    }

    public class DuctBridgeBuild
    extends DirectionBridge.DirectionBridgeBuild {
        @Override
        public void draw() {
            Draw.rect(DirectionLiquidBridge.this.bottomRegion, this.x, this.y);
            if (this.liquids.currentAmount() > 0.001f) {
                LiquidBlock.drawTiledFrames(DirectionLiquidBridge.this.size, this.x, this.y, DirectionLiquidBridge.this.liquidPadding, this.liquids.current(), this.liquids.currentAmount() / DirectionLiquidBridge.this.liquidCapacity);
            }
            Draw.rect(this.block.region, this.x, this.y);
            Draw.rect(DirectionLiquidBridge.this.dirRegion, this.x, this.y, this.rotdeg());
            DirectionBridge.DirectionBridgeBuild link = this.findLink();
            if (link != null) {
                Draw.z(69.0f);
                DirectionLiquidBridge.this.drawBridge(this.rotation, this.x, this.y, link.x, link.y, Tmp.c1.set(this.liquids.current().color).a(this.liquids.currentAmount() / DirectionLiquidBridge.this.liquidCapacity * this.liquids.current().color.a));
            }
        }

        @Override
        public void updateTile() {
            this.lastLink = this.findLink();
            DirectionBridge.DirectionBridgeBuild link = this.lastLink;
            if (link != null) {
                this.moveLiquid(link, this.liquids.current());
                link.occupied[this.rotation % 4] = this;
            }
            if (link == null && this.liquids.currentAmount() > 1.0E-4f && this.timer(DirectionLiquidBridge.this.timerFlow, 1.0f)) {
                this.moveLiquidForward(false, this.liquids.current());
            }
            for (int i = 0; i < 4; ++i) {
                if (this.occupied[i] != null && this.occupied[i].rotation == i && this.occupied[i].isValid() && this.occupied[i].lastLink == this) continue;
                this.occupied[i] = null;
            }
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            DirectionBridge.DirectionBridgeBuild b;
            DirectionBridge.DirectionBridgeBuild link = this.findLink();
            if (!(link != null || source instanceof DirectionBridge.DirectionBridgeBuild && (b = (DirectionBridge.DirectionBridgeBuild)source).findLink() == this)) {
                return false;
            }
            byte rel = this.relativeToEdge(source.tile);
            return !(!DirectionLiquidBridge.this.hasLiquids || this.team != source.team || this.liquids.current() != liquid && !(this.liquids.get(this.liquids.current()) < 0.2f) || rel == this.rotation || this.occupied[(rel + 2) % 4] != null && this.occupied[(rel + 2) % 4] != source);
        }
    }
}

