/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.input.Placement;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.distribution.Duct;
import mindustry.world.blocks.distribution.DuctBridge;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Conveyor
extends Block
implements Autotiler {
    private static final float itemSpace = 0.4f;
    private static final int capacity = 3;
    public TextureRegion[][] regions;
    public float speed = 0.0f;
    public float displayedSpeed = 0.0f;
    public boolean pushUnits = true;
    @Nullable
    public Block junctionReplacement;
    @Nullable
    public Block bridgeReplacement;

    public Conveyor(String name) {
        super(name);
        this.rotate = true;
        this.update = true;
        this.group = BlockGroup.transportation;
        this.hasItems = true;
        this.itemCapacity = 3;
        this.priority = -1.0f;
        this.conveyorPlacement = true;
        this.underBullets = true;
        this.ambientSound = Sounds.conveyor;
        this.ambientSoundVolume = 0.0022f;
        this.unloadable = false;
        this.noUpdateDisabled = false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, this.displayedSpeed, StatUnit.itemsSecond);
    }

    @Override
    public void init() {
        super.init();
        if (this.junctionReplacement == null) {
            this.junctionReplacement = Blocks.junction;
        }
        if (this.bridgeReplacement == null || !(this.bridgeReplacement instanceof ItemBridge) && !(this.bridgeReplacement instanceof DuctBridge)) {
            this.bridgeReplacement = Blocks.itemBridge;
        }
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(plan, list);
        if (bits == null) {
            return;
        }
        TextureRegion region = this.regions[bits[0]][0];
        Draw.rect(region, plan.drawx(), plan.drawy(), (float)(region.width * bits[1]) * region.scl(), (float)(region.height * bits[2]) * region.scl(), (float)(plan.rotation * 90));
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return (otherblock.outputsItems() || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasItems) && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock);
    }

    @Override
    public boolean canReplace(Block other) {
        return super.canReplace(other) && !(other instanceof StackConveyor);
    }

    @Override
    public void handlePlacementLine(Seq<BuildPlan> plans) {
        Block bridge;
        if (this.bridgeReplacement == null) {
            return;
        }
        boolean hasJuntionReplacement = this.junctionReplacement != null;
        Block block = this.bridgeReplacement;
        if (block instanceof DuctBridge) {
            bridge = (DuctBridge)block;
            Placement.calculateBridges(plans, bridge, hasJuntionReplacement, b -> b instanceof Duct || b instanceof Conveyor);
        }
        if ((block = this.bridgeReplacement) instanceof ItemBridge) {
            bridge = (ItemBridge)block;
            Placement.calculateBridges(plans, (ItemBridge)bridge, hasJuntionReplacement, b -> b instanceof Conveyor);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.regions[0][0]};
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public Block getReplacement(BuildPlan req, Seq<BuildPlan> plans) {
        if (this.junctionReplacement == null) {
            return this;
        }
        Boolf<Point2> cont = p -> plans.contains(o -> o.x == req.x + p.x && o.y == req.y + p.y && (req.block instanceof Conveyor || req.block instanceof Junction));
        return cont.get(Geometry.d4(req.rotation)) && cont.get(Geometry.d4(req.rotation - 2)) && req.tile() != null && req.tile().block() instanceof Conveyor && Mathf.mod(req.tile().build.rotation - req.rotation, 2) == 1 ? this.junctionReplacement : this;
    }

    public class ConveyorBuild
    extends Building
    implements ChainedBuilding {
        public Item[] ids = new Item[3];
        public float[] xs = new float[3];
        public float[] ys = new float[3];
        public int len = 0;
        @Nullable
        public Building next;
        @Nullable
        public ConveyorBuild nextc;
        public boolean aligned;
        public int lastInserted;
        public int mid;
        public float minitem = 1.0f;
        public int blendbits;
        public int blending;
        public int blendsclx = 1;
        public int blendscly = 1;
        public float clogHeat = 0.0f;

        @Override
        public void draw() {
            int frame = this.enabled && this.clogHeat <= 0.5f ? (int)(Time.time * Conveyor.this.speed * 8.0f * this.timeScale * this.efficiency % 4.0f) : 0;
            Draw.z(29.5f);
            for (int i = 0; i < 4; ++i) {
                if ((this.blending & 1 << i) == 0) continue;
                int dir = this.rotation - i;
                float rot = i == 0 ? (float)(this.rotation * 90) : (float)(dir * 90);
                Draw.rect(Conveyor.this.sliced(Conveyor.this.regions[0][frame], i != 0 ? Autotiler.SliceMode.bottom : Autotiler.SliceMode.top), this.x + (float)(Geometry.d4x(dir) * 8) * 0.75f, this.y + (float)(Geometry.d4y(dir) * 8) * 0.75f, rot);
            }
            Draw.z(29.8f);
            Draw.rect(Conveyor.this.regions[this.blendbits][frame], this.x, this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
            Draw.z(29.9f);
            float layer = 29.9f;
            float wwidth = Vars.world.unitWidth();
            float wheight = Vars.world.unitHeight();
            float scaling = 0.01f;
            for (int i = 0; i < this.len; ++i) {
                Item item = this.ids[i];
                Tmp.v1.trns(this.rotation * 90, 8.0f, 0.0f);
                Tmp.v2.trns(this.rotation * 90, -4.0f, this.xs[i] * 8.0f / 2.0f);
                float ix = this.x + Tmp.v1.x * this.ys[i] + Tmp.v2.x;
                float iy = this.y + Tmp.v1.y * this.ys[i] + Tmp.v2.y;
                Draw.z(layer + (ix / wwidth + iy / wheight) * scaling);
                Draw.rect(item.fullIcon, ix, iy, 5.0f, 5.0f);
            }
        }

        @Override
        public void payloadDraw() {
            Draw.rect(this.block.fullIcon, this.x, this.y);
        }

        @Override
        public void drawCracks() {
            Draw.z(29.85f);
            super.drawCracks();
        }

        @Override
        public void overwrote(Seq<Building> builds) {
            Building building = builds.first();
            if (building instanceof ConveyorBuild) {
                ConveyorBuild build = (ConveyorBuild)building;
                this.ids = (Item[])build.ids.clone();
                this.xs = (float[])build.xs.clone();
                this.ys = (float[])build.ys.clone();
                this.len = build.len;
                this.clogHeat = build.clogHeat;
                this.lastInserted = build.lastInserted;
                this.mid = build.mid;
                this.minitem = build.minitem;
                this.items.add(build.items);
            }
        }

        @Override
        public boolean shouldAmbientSound() {
            return this.clogHeat <= 0.5f;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            int[] bits = Conveyor.this.buildBlending(this.tile, this.rotation, null, true);
            this.blendbits = bits[0];
            this.blendsclx = bits[1];
            this.blendscly = bits[2];
            this.blending = bits[4];
            this.next = this.front();
            this.nextc = this.next instanceof ConveyorBuild && this.next.team == this.team ? (ConveyorBuild)this.next : null;
            this.aligned = this.nextc != null && this.rotation == this.next.rotation;
        }

        @Override
        public void unitOn(Unit unit) {
            if (!Conveyor.this.pushUnits || this.clogHeat > 0.5f || !this.enabled) {
                return;
            }
            this.noSleep();
            float mspeed = Conveyor.this.speed * 8.0f * 55.0f;
            float centerSpeed = 0.1f;
            float centerDstScl = 3.0f;
            float tx = Geometry.d4x(this.rotation);
            float ty = Geometry.d4y(this.rotation);
            float centerx = 0.0f;
            float centery = 0.0f;
            if (Math.abs(tx) > Math.abs(ty)) {
                centery = Mathf.clamp((this.y - unit.y()) / centerDstScl, -centerSpeed, centerSpeed);
                if (Math.abs(this.y - unit.y()) < 1.0f) {
                    centery = 0.0f;
                }
            } else {
                centerx = Mathf.clamp((this.x - unit.x()) / centerDstScl, -centerSpeed, centerSpeed);
                if (Math.abs(this.x - unit.x()) < 1.0f) {
                    centerx = 0.0f;
                }
            }
            if ((float)this.len * 0.4f < 0.9f) {
                unit.impulse((tx * mspeed + centerx) * this.delta(), (ty * mspeed + centery) * this.delta());
            }
        }

        @Override
        public void updateTile() {
            this.minitem = 1.0f;
            this.mid = 0;
            if (this.len == 0 && Mathf.equal(this.timeScale, 1.0f)) {
                this.clogHeat = 0.0f;
                this.sleep();
                return;
            }
            float nextMax = this.aligned ? 1.0f - Math.max(0.4f - this.nextc.minitem, 0.0f) : 1.0f;
            float moved = Conveyor.this.speed * this.edelta();
            for (int i = this.len - 1; i >= 0; --i) {
                float nextpos = (i == this.len - 1 ? 100.0f : this.ys[i + 1]) - 0.4f;
                float maxmove = Mathf.clamp(nextpos - this.ys[i], 0.0f, moved);
                int n = i;
                this.ys[n] = this.ys[n] + maxmove;
                if (this.ys[i] > nextMax) {
                    this.ys[i] = nextMax;
                }
                if ((double)this.ys[i] > 0.5 && i > 0) {
                    this.mid = i - 1;
                }
                this.xs[i] = Mathf.approach(this.xs[i], 0.0f, moved * 2.0f);
                if (this.ys[i] >= 1.0f && this.pass(this.ids[i])) {
                    if (this.aligned) {
                        this.nextc.xs[this.nextc.lastInserted] = this.xs[i];
                    }
                    this.items.remove(this.ids[i], this.len - i);
                    this.len = Math.min(i, this.len);
                    continue;
                }
                if (!(this.ys[i] < this.minitem)) continue;
                this.minitem = this.ys[i];
            }
            this.clogHeat = this.minitem < 0.4f + (this.blendbits == 1 ? 0.3f : 0.0f) ? Mathf.approachDelta(this.clogHeat, 1.0f, 0.016666668f) : 0.0f;
            this.noSleep();
        }

        public boolean pass(Item item) {
            if (item != null && this.next != null && this.next.team == this.team && this.next.acceptItem(this, item)) {
                this.next.handleItem(this, item);
                return true;
            }
            return false;
        }

        @Override
        public int removeStack(Item item, int amount) {
            this.noSleep();
            int removed = 0;
            block0: for (int j = 0; j < amount; ++j) {
                for (int i = 0; i < this.len; ++i) {
                    if (this.ids[i] != item) continue;
                    this.remove(i);
                    ++removed;
                    continue block0;
                }
            }
            this.items.remove(item, removed);
            return removed;
        }

        @Override
        public void getStackOffset(Item item, Vec2 trns) {
            trns.trns(this.rotdeg() + 180.0f, 4.0f);
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            return Math.min((int)(this.minitem / 0.4f), amount);
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            amount = Math.min(amount, 3 - this.len);
            for (int i = amount - 1; i >= 0; --i) {
                this.add(0);
                this.xs[0] = 0.0f;
                this.ys[0] = (float)i * 0.4f;
                this.ids[0] = item;
                this.items.add(item, 1);
            }
            this.noSleep();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            if (this.len >= 3) {
                return false;
            }
            Tile facing = Edges.getFacingEdge(source.tile, this.tile);
            if (facing == null) {
                return false;
            }
            int direction = Math.abs(facing.relativeTo(this.tile.x, this.tile.y) - this.rotation);
            return (direction == 0 && this.minitem >= 0.4f || direction % 2 == 1 && this.minitem > 0.7f) && (!source.block.rotate || this.next != source);
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (this.len >= 3) {
                return;
            }
            int r = this.rotation;
            Tile facing = Edges.getFacingEdge(source.tile, this.tile);
            int ang = facing.relativeTo(this.tile.x, this.tile.y) - r;
            float x = ang == -1 || ang == 3 ? 1.0f : (ang == 1 || ang == -3 ? -1.0f : 0.0f);
            this.noSleep();
            this.items.add(item, 1);
            if (Math.abs(facing.relativeTo(this.tile.x, this.tile.y) - r) == 0) {
                this.add(0);
                this.xs[0] = x;
                this.ys[0] = 0.0f;
                this.ids[0] = item;
            } else {
                this.add(this.mid);
                this.xs[this.mid] = x;
                this.ys[this.mid] = 0.5f;
                this.ids[this.mid] = item;
            }
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.len);
            for (int i = 0; i < this.len; ++i) {
                write.s(this.ids[i].id);
                write.b((byte)(this.xs[i] * 127.0f));
                write.b((byte)(this.ys[i] * 255.0f - 128.0f));
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            int amount = read.i();
            this.len = Math.min(amount, 3);
            for (int i = 0; i < amount; ++i) {
                float y;
                float x;
                short id;
                if (revision == 0) {
                    int val = read.i();
                    id = (short)((byte)(val >> 24) & 0xFF);
                    x = (float)((byte)(val >> 16)) / 127.0f;
                    y = ((float)((byte)(val >> 8)) + 128.0f) / 255.0f;
                } else {
                    id = read.s();
                    x = (float)read.b() / 127.0f;
                    y = ((float)read.b() + 128.0f) / 255.0f;
                }
                if (i >= 3) continue;
                this.ids[i] = Vars.content.item(id);
                this.xs[i] = x;
                this.ys[i] = y;
            }
            this.updateTile();
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                if (this.len == 0) {
                    return 0.0;
                }
                return this.ys[this.len - 1];
            }
            return super.sense(sensor);
        }

        @Override
        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.firstItem && this.len > 0) {
                return this.ids[this.len - 1];
            }
            return super.senseObject(sensor);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setProp(UnlockableContent content, double value) {
            if (content instanceof Item) {
                Item item = (Item)content;
                if (this.items != null) {
                    int amount = Math.min((int)value, 3);
                    if (this.items.get(item) == amount) return;
                    if (this.items.get(item) < amount) {
                        this.handleStack(item, amount - this.items.get(item), null);
                        return;
                    }
                    if (amount < 0) return;
                    this.removeStack(item, this.items.get(item) - amount);
                    return;
                }
            }
            super.setProp(content, value);
        }

        public final void add(int o) {
            for (int i = Math.max(o + 1, this.len); i > o; --i) {
                this.ids[i] = this.ids[i - 1];
                this.xs[i] = this.xs[i - 1];
                this.ys[i] = this.ys[i - 1];
            }
            ++this.len;
        }

        public final void remove(int o) {
            for (int i = o; i < this.len - 1; ++i) {
                this.ids[i] = this.ids[i + 1];
                this.xs[i] = this.xs[i + 1];
                this.ys[i] = this.ys[i + 1];
            }
            --this.len;
        }

        @Override
        @Nullable
        public Building next() {
            return this.nextc;
        }
    }
}

