/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Position;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Ranged;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.ExplosionShield;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeCoolant;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class ForceProjector
extends Block {
    public final int timerUse;
    public float phaseUseTime;
    public float phaseRadiusBoost;
    public float phaseShieldBoost;
    public float radius;
    public int sides;
    public float shieldRotation;
    public float shieldHealth;
    public float cooldownNormal;
    public float cooldownLiquid;
    public float cooldownBrokenBase;
    public float coolantConsumption;
    public boolean consumeCoolant;
    public float crashDamageMultiplier;
    public Effect absorbEffect;
    public Effect shieldBreakEffect;
    public TextureRegion topRegion;
    @Nullable
    public Consume itemConsumer;
    @Nullable
    public Consume coolantConsumer;
    protected static ForceBuild paramEntity;
    protected static Effect paramEffect;
    protected static final Cons<Bullet> shieldConsumer;

    public ForceProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.phaseUseTime = 350.0f;
        this.phaseRadiusBoost = 80.0f;
        this.phaseShieldBoost = 400.0f;
        this.radius = 101.7f;
        this.sides = 6;
        this.shieldRotation = 0.0f;
        this.shieldHealth = 700.0f;
        this.cooldownNormal = 1.75f;
        this.cooldownLiquid = 1.5f;
        this.cooldownBrokenBase = 0.35f;
        this.coolantConsumption = 0.1f;
        this.consumeCoolant = true;
        this.crashDamageMultiplier = 2.0f;
        this.absorbEffect = Fx.absorb;
        this.shieldBreakEffect = Fx.shieldBreak;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasLiquids = true;
        this.hasItems = true;
        this.envEnabled |= 2;
        this.ambientSound = Sounds.shield;
        this.ambientSoundVolume = 0.08f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.shield});
        if (this.consumeCoolant) {
            this.coolantConsumer = new ConsumeCoolant(this.coolantConsumption);
            this.consume(this.coolantConsumer).boost().update(false);
        }
    }

    @Override
    public void init() {
        this.updateClipRadius(this.radius + this.phaseRadiusBoost + 3.0f);
        super.init();
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("shield", entity -> new Bar("stat.shieldhealth", Pal.accent, () -> entity.broken ? 0.0f : 1.0f - entity.buildup / (this.shieldHealth + this.phaseShieldBoost * entity.phaseHeat)).blink(Color.white));
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        Consume consume;
        boolean consItems;
        boolean bl = consItems = this.itemConsumer != null;
        if (consItems) {
            this.stats.timePeriod = this.phaseUseTime;
        }
        super.setStats();
        this.stats.add(Stat.shieldHealth, this.shieldHealth, StatUnit.none);
        this.stats.add(Stat.regenerationRate, this.cooldownNormal * 60.0f, StatUnit.perSecond);
        this.stats.add(Stat.cooldownTime, (int)(this.shieldHealth / this.cooldownBrokenBase / 60.0f), StatUnit.seconds);
        if (consItems && (consume = this.itemConsumer) instanceof ConsumeItems) {
            ConsumeItems coni = (ConsumeItems)consume;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.itemBoosters("+{0} " + StatUnit.shieldHealth.localized(), this.stats.timePeriod, this.phaseShieldBoost, this.phaseRadiusBoost, coni.items));
            this.stats.add(Stat.booster, table -> {
                table.row();
                table.table(c -> {
                    for (Liquid liquid : Vars.content.liquids()) {
                        if (!this.consumesLiquid(liquid)) continue;
                        c.table(Styles.grayPanel, b -> {
                            b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, liquid, false));
                            b.table(info -> {
                                info.add(liquid.localizedName).left().row();
                                info.add(Strings.autoFixed(this.coolantConsumption * 60.0f, 2) + StatUnit.perSecond.localized()).left().color(Color.lightGray);
                            });
                            float liquidHeat = 1.0f + (liquid.heatCapacity - 0.4f) * 0.9f;
                            float regenBoost = (this.cooldownNormal * (this.cooldownLiquid * liquidHeat) - this.cooldownNormal) * 60.0f;
                            float cooldownBoost = (this.shieldHealth / (this.cooldownBrokenBase * (this.cooldownLiquid * liquidHeat)) - this.shieldHealth / this.cooldownBrokenBase) / 60.0f;
                            b.table(bt -> {
                                bt.right().defaults().padRight(3.0f).left();
                                bt.add("[lightgray]+" + Core.bundle.format("bar.regenerationrate", Strings.autoFixed(regenBoost, 2))).pad(5.0f).row();
                                bt.add(Core.bundle.format("ability.stat.cooldown", Strings.autoFixed(cooldownBoost, 2))).pad(5.0f);
                            }).right().grow().pad(10.0f).padRight(15.0f);
                        }).growX().pad(5.0f).row();
                    }
                }).growX().colspan(table.getColumns());
                table.row();
            });
        }
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Draw.color(Pal.gray);
        Lines.stroke(3.0f);
        Lines.poly((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.sides, this.radius, this.shieldRotation);
        Draw.color(Vars.player.team().color);
        Lines.stroke(1.0f);
        Lines.poly((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.sides, this.radius, this.shieldRotation);
        Draw.color();
    }

    static {
        shieldConsumer = bullet -> {
            if (bullet.team != ForceProjector.paramEntity.team && bullet.type.absorbable && !bullet.absorbed && Intersector.isInRegularPolygon(((ForceProjector)ForceProjector.paramEntity.block).sides, ForceProjector.paramEntity.x, ForceProjector.paramEntity.y, paramEntity.realRadius(), ((ForceProjector)ForceProjector.paramEntity.block).shieldRotation, bullet.x, bullet.y)) {
                bullet.absorb();
                paramEffect.at((Position)bullet);
                ForceProjector.paramEntity.hit = 1.0f;
                ForceProjector.paramEntity.buildup += bullet.type.shieldDamage((Bullet)bullet);
            }
        };
    }

    public class ForceBuild
    extends Building
    implements Ranged,
    ExplosionShield {
        public boolean broken = true;
        public float buildup;
        public float radscl;
        public float hit;
        public float warmup;
        public float phaseHeat;

        @Override
        public float range() {
            return this.realRadius();
        }

        @Override
        public boolean shouldAmbientSound() {
            return !this.broken && this.realRadius() > 1.0f;
        }

        @Override
        public void onRemoved() {
            float radius = this.realRadius();
            if (!this.broken && radius > 1.0f) {
                Fx.forceShrink.at(this.x, this.y, radius, this.team.color);
            }
            super.onRemoved();
        }

        @Override
        public void pickedUp() {
            super.pickedUp();
            this.warmup = 0.0f;
            this.radscl = 0.0f;
        }

        @Override
        public boolean inFogTo(Team viewer) {
            return false;
        }

        @Override
        public void updateTile() {
            boolean phaseValid = ForceProjector.this.itemConsumer != null && ForceProjector.this.itemConsumer.efficiency(this) > 0.0f;
            this.phaseHeat = Mathf.lerpDelta(this.phaseHeat, Mathf.num(phaseValid), 0.1f);
            if (phaseValid && !this.broken && this.timer(ForceProjector.this.timerUse, ForceProjector.this.phaseUseTime) && this.efficiency > 0.0f) {
                this.consume();
            }
            this.radscl = Mathf.lerpDelta(this.radscl, this.broken ? 0.0f : this.warmup, 0.05f);
            if (Mathf.chanceDelta(this.buildup / ForceProjector.this.shieldHealth * 0.1f)) {
                Fx.reactorsmoke.at(this.x + Mathf.range(4.0f), this.y + Mathf.range(4.0f));
            }
            this.warmup = Mathf.lerpDelta(this.warmup, this.efficiency, 0.1f);
            if (this.buildup > 0.0f) {
                float scale;
                float f = scale = !this.broken ? ForceProjector.this.cooldownNormal : ForceProjector.this.cooldownBrokenBase;
                if (ForceProjector.this.coolantConsumer != null && ForceProjector.this.coolantConsumer.efficiency(this) > 0.0f) {
                    ForceProjector.this.coolantConsumer.update(this);
                    scale *= ForceProjector.this.cooldownLiquid * (1.0f + (this.liquids.current().heatCapacity - 0.4f) * 0.9f);
                }
                this.buildup -= this.delta() * scale;
            }
            if (this.broken && this.buildup <= 0.0f) {
                this.broken = false;
            }
            if (this.buildup >= ForceProjector.this.shieldHealth + ForceProjector.this.phaseShieldBoost * this.phaseHeat && !this.broken) {
                this.broken = true;
                this.buildup = ForceProjector.this.shieldHealth;
                ForceProjector.this.shieldBreakEffect.at(this.x, this.y, this.realRadius(), this.team.color);
                if (this.team != Vars.state.rules.defaultTeam) {
                    Events.fire(EventType.Trigger.forceProjectorBreak);
                }
            }
            if (this.hit > 0.0f) {
                this.hit -= 0.2f * Time.delta;
            }
            this.deflectBullets();
        }

        public void deflectBullets() {
            float realRadius = this.realRadius();
            if (realRadius > 0.0f && !this.broken) {
                paramEntity = this;
                paramEffect = ForceProjector.this.absorbEffect;
                Groups.bullet.intersect(this.x - realRadius, this.y - realRadius, realRadius * 2.0f, realRadius * 2.0f, shieldConsumer);
            }
        }

        @Override
        public boolean absorbExplosion(float ex, float ey, float damage) {
            boolean absorb;
            boolean bl = absorb = !this.broken && Intersector.isInRegularPolygon(ForceProjector.this.sides, this.x, this.y, this.realRadius(), ForceProjector.this.shieldRotation, ex, ey);
            if (absorb) {
                ForceProjector.this.absorbEffect.at(ex, ey);
                this.hit = 1.0f;
                this.buildup += damage * ForceProjector.this.crashDamageMultiplier;
            }
            return absorb;
        }

        public float realRadius() {
            return (ForceProjector.this.radius + this.phaseHeat * ForceProjector.this.phaseRadiusBoost) * this.radscl;
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.heat) {
                return this.buildup;
            }
            if (sensor == LAccess.shield) {
                return this.broken ? 0.0 : (double)Math.max(ForceProjector.this.shieldHealth + ForceProjector.this.phaseShieldBoost * this.phaseHeat - this.buildup, 0.0f);
            }
            return super.sense(sensor);
        }

        @Override
        public void draw() {
            super.draw();
            if (this.buildup > 0.0f) {
                Draw.alpha(this.buildup / ForceProjector.this.shieldHealth * 0.75f);
                Draw.z(31.0f);
                Draw.blend(Blending.additive);
                Draw.rect(ForceProjector.this.topRegion, this.x, this.y);
                Draw.blend();
                Draw.z(30.0f);
                Draw.reset();
            }
            this.drawShield();
        }

        public void drawShield() {
            float radius;
            if (!this.broken && (radius = this.realRadius()) > 0.001f) {
                Draw.color(this.team.color, Color.white, Mathf.clamp(this.hit));
                if (Vars.renderer.animateShields) {
                    Draw.z(125.0f + 0.001f * this.hit);
                    Fill.poly(this.x, this.y, ForceProjector.this.sides, radius, ForceProjector.this.shieldRotation);
                } else {
                    Draw.z(125.0f);
                    Lines.stroke(1.5f);
                    Draw.alpha(0.09f + Mathf.clamp(0.08f * this.hit));
                    Fill.poly(this.x, this.y, ForceProjector.this.sides, radius, ForceProjector.this.shieldRotation);
                    Draw.alpha(1.0f);
                    Lines.poly(this.x, this.y, ForceProjector.this.sides, radius, ForceProjector.this.shieldRotation);
                    Draw.reset();
                }
            }
            Draw.reset();
        }

        @Override
        public void overwrote(Seq<Building> previous) {
            Building building;
            if (previous.size > 0 && previous.first().block == this.block && (building = previous.first()) instanceof ForceBuild) {
                ForceBuild b = (ForceBuild)building;
                this.broken = b.broken;
                this.buildup = b.buildup;
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.bool(this.broken);
            write.f(this.buildup);
            write.f(this.radscl);
            write.f(this.warmup);
            write.f(this.phaseHeat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.broken = read.bool();
            this.buildup = read.f();
            this.radscl = read.f();
            this.warmup = read.f();
            this.phaseHeat = read.f();
        }
    }
}

