/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.g2d.GlyphLayout;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.pooling.Pools;
import java.util.Arrays;
import mindustry.gen.Icon;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class FileChooser
extends BaseDialog {
    private static final Fi homeDirectory = Core.files.absolute(Core.files.getExternalStoragePath());
    static Fi lastDirectory = Core.files.absolute(Core.settings.getString("lastDirectory", homeDirectory.absolutePath()));
    Fi directory;
    private Table files;
    private ScrollPane pane;
    private TextField navigation;
    private TextField filefield;
    private TextButton ok;
    private FileHistory stack = new FileHistory();
    private Boolf<Fi> filter;
    private Cons<Fi> selectListener;
    private boolean open;

    public FileChooser(String title, Boolf<Fi> filter, boolean open, Cons<Fi> result) {
        super(title);
        this.setFillParent(true);
        this.open = open;
        this.filter = filter;
        this.selectListener = result;
        this.directory = FileChooser.getLastDirectory();
        this.onResize(() -> {
            this.cont.clear();
            this.setupWidgets();
        });
        this.shown(() -> {
            this.cont.clear();
            this.setupWidgets();
        });
        this.keyDown(KeyCode.enter, () -> this.ok.fireClick());
        this.addCloseListener();
    }

    private void setupWidgets() {
        this.cont.margin(-10.0f);
        Table content = new Table();
        this.filefield = new TextField();
        this.filefield.setOnlyFontChars(false);
        if (!this.open) {
            this.filefield.addInputDialog();
        }
        this.filefield.setDisabled(this.open);
        this.ok = new TextButton(this.open ? "@load" : "@save");
        this.ok.clicked(() -> {
            if (this.ok.isDisabled()) {
                return;
            }
            if (this.selectListener != null) {
                this.selectListener.get(this.directory.child(this.filefield.getText()));
            }
            this.hide();
        });
        this.filefield.changed(() -> this.ok.setDisabled(this.filefield.getText().replace(" ", "").isEmpty()));
        this.filefield.change();
        TextButton cancel = new TextButton("@cancel");
        cancel.clicked(this::hide);
        this.navigation = new TextField("");
        this.navigation.touchable = Touchable.disabled;
        this.files = new Table();
        this.files.marginRight(10.0f);
        this.files.marginLeft(3.0f);
        this.pane = new ScrollPane((Element)this.files);
        this.pane.setOverscroll(false, false);
        this.pane.setFadeScrollBars(false);
        this.updateFiles(true);
        Table icontable = new Table();
        ImageButton up = new ImageButton(Icon.upOpen);
        up.clicked(() -> {
            this.directory = this.directory.parent();
            this.updateFiles(true);
        });
        ImageButton back = new ImageButton(Icon.left);
        ImageButton forward = new ImageButton(Icon.right);
        forward.clicked(() -> this.stack.forward());
        back.clicked(() -> this.stack.back());
        forward.setDisabled(() -> !this.stack.canForward());
        back.setDisabled(() -> !this.stack.canBack());
        ImageButton home = new ImageButton(Icon.home);
        home.clicked(() -> {
            this.directory = homeDirectory;
            FileChooser.setLastDirectory(this.directory);
            this.updateFiles(true);
        });
        icontable.defaults().height(60.0f).growX().padTop(5.0f).uniform();
        icontable.add(home);
        icontable.add(back);
        icontable.add(forward);
        icontable.add(up);
        Table fieldcontent = new Table();
        fieldcontent.bottom().left().add(new Label("@filename"));
        fieldcontent.add(this.filefield).height(40.0f).fillX().expandX().padLeft(10.0f);
        Table buttons = new Table();
        buttons.defaults().growX().height(60.0f);
        buttons.add(cancel);
        buttons.add(this.ok);
        content.top().left();
        content.add(icontable).expandX().fillX();
        content.row();
        content.center().add(this.pane).colspan(3).grow();
        content.row();
        if (!this.open) {
            content.bottom().left().add(fieldcontent).colspan(3).grow().padTop(-2.0f).padBottom(2.0f);
            content.row();
        }
        content.add(buttons).growX();
        this.cont.add(content).grow();
    }

    private void updateFileFieldStatus() {
        if (!this.open) {
            this.ok.setDisabled(this.filefield.getText().replace(" ", "").isEmpty());
        } else {
            this.ok.setDisabled(!this.directory.child(this.filefield.getText()).exists() || this.directory.child(this.filefield.getText()).isDirectory());
        }
    }

    private Fi[] getFileNames() {
        Fi[] handles = this.directory.list(file -> !file.getName().startsWith("."));
        Arrays.sort(handles, (a, b) -> {
            if (a.isDirectory() && !b.isDirectory()) {
                return -1;
            }
            if (!a.isDirectory() && b.isDirectory()) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(a.name(), b.name());
        });
        return handles;
    }

    void updateFiles(boolean push) {
        if (push) {
            this.stack.push(this.directory);
        }
        this.navigation.setText(this.directory.toString());
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        layout.setText(Fonts.def, this.navigation.getText());
        if (layout.width < this.navigation.getWidth()) {
            this.navigation.setCursorPosition(0);
        } else {
            this.navigation.setCursorPosition(this.navigation.getText().length());
        }
        Pools.free(layout);
        this.files.clearChildren();
        this.files.top().left();
        Fi[] names = this.getFileNames();
        Image upimage = new Image(Icon.upOpen);
        TextButton upbutton = new TextButton(".." + this.directory.toString(), Styles.flatTogglet);
        upbutton.clicked(() -> {
            this.directory = this.directory.parent();
            FileChooser.setLastDirectory(this.directory);
            this.updateFiles(true);
        });
        upbutton.left().add(upimage).padRight(4.0f).padLeft(4.0f);
        upbutton.getLabel().setAlignment(8);
        upbutton.getCells().reverse();
        this.files.add(upbutton).align(10).fillX().expandX().height(50.0f).pad(2.0f).colspan(2);
        this.files.row();
        ButtonGroup<TextButton> group = new ButtonGroup<TextButton>();
        group.setMinCheckCount(0);
        for (Fi file : names) {
            if (!file.isDirectory() && !this.filter.get(file)) continue;
            String filename = file.name();
            TextButton button = new TextButton(filename.replace("[", "[["), Styles.flatTogglet);
            button.getLabel().setWrap(false);
            button.getLabel().setEllipsis(true);
            group.add(button);
            button.clicked(() -> {
                if (!file.isDirectory()) {
                    this.filefield.setText(filename);
                    this.updateFileFieldStatus();
                } else {
                    this.directory = this.directory.child(filename);
                    FileChooser.setLastDirectory(this.directory);
                    this.updateFiles(true);
                }
            });
            this.filefield.changed(() -> button.setChecked(filename.equals(this.filefield.getText())));
            Image image = new Image(file.isDirectory() ? Icon.folder : Icon.fileText);
            button.add(image).padRight(4.0f).padLeft(4.0f);
            button.getCells().reverse();
            this.files.top().left().add(button).align(10).fillX().expandX().height(50.0f).pad(2.0f).padTop(0.0f).padBottom(0.0f).colspan(2);
            button.getLabel().setAlignment(8);
            this.files.row();
        }
        this.pane.setScrollY(0.0f);
        this.updateFileFieldStatus();
        if (this.open) {
            this.filefield.clearText();
        }
    }

    public static synchronized void setLastDirectory(Fi directory) {
        lastDirectory = directory;
        Core.settings.put("lastDirectory", directory.absolutePath());
    }

    public static synchronized Fi getLastDirectory() {
        if (!lastDirectory.exists()) {
            lastDirectory = homeDirectory;
        }
        return lastDirectory;
    }

    public class FileHistory {
        private Seq<Fi> history = new Seq();
        private int index;

        public void push(Fi file) {
            if (this.index != this.history.size) {
                this.history.truncate(this.index);
            }
            this.history.add(file);
            ++this.index;
        }

        public void back() {
            if (!this.canBack()) {
                return;
            }
            --this.index;
            FileChooser.this.directory = this.history.get(this.index - 1);
            FileChooser.setLastDirectory(FileChooser.this.directory);
            FileChooser.this.updateFiles(false);
        }

        public void forward() {
            if (!this.canForward()) {
                return;
            }
            FileChooser.this.directory = this.history.get(this.index);
            FileChooser.setLastDirectory(FileChooser.this.directory);
            ++this.index;
            FileChooser.this.updateFiles(false);
        }

        public boolean canForward() {
            return this.index < this.history.size;
        }

        public boolean canBack() {
            return this.index != 1 && this.index > 0;
        }
    }
}

