/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.actions.Actions;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.gen.Icon;
import mindustry.type.Planet;
import mindustry.ui.dialogs.BaseDialog;

public class CampaignCompleteDialog
extends BaseDialog {
    public CampaignCompleteDialog() {
        super("");
        this.addCloseListener();
        this.shouldPause = true;
        this.buttons.defaults().size(210.0f, 64.0f);
        this.buttons.button("@menu", Icon.left, () -> {
            this.hide();
            Vars.ui.paused.runExitSave();
        });
        this.buttons.button("@continue", Icon.ok, this::hide);
    }

    public void show(Planet planet) {
        this.cont.clear();
        this.cont.add(Core.bundle.format("campaign.complete", "[#" + planet.iconColor + "]" + planet.localizedName + "[]")).row();
        float playtime = planet.sectors.sumf(s -> s.hasSave() ? (float)s.save.meta.timePlayed : 0.0f) / 1000.0f;
        this.cont.add(Core.bundle.format("campaign.playtime", UI.formatTime(playtime))).left().row();
        this.setTranslation(0.0f, -Core.graphics.getHeight());
        this.color.a = 0.0f;
        this.show(Core.scene, Actions.sequence((Action)Actions.parallel((Action)Actions.fadeIn(1.1f, Interp.fade), (Action)Actions.translateBy(0.0f, Core.graphics.getHeight(), 6.0f, Interp.pow5Out))));
    }
}

