/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.func.Func;

public class IntFormat {
    private final StringBuilder builder = new StringBuilder();
    private final String text;
    private int lastValue = Integer.MIN_VALUE;
    private int lastValue2 = Integer.MIN_VALUE;
    private Func<Integer, String> converter = String::valueOf;

    public IntFormat(String text) {
        this.text = text;
    }

    public IntFormat(String text, Func<Integer, String> converter) {
        this.text = text;
        this.converter = converter;
    }

    public CharSequence get(int value) {
        if (this.lastValue != value) {
            this.builder.setLength(0);
            this.builder.append(Core.bundle.format(this.text, this.converter.get(value)));
        }
        this.lastValue = value;
        return this.builder;
    }

    public CharSequence get(int value1, int value2) {
        if (this.lastValue != value1 || this.lastValue2 != value2) {
            this.builder.setLength(0);
            this.builder.append(Core.bundle.format(this.text, value1, value2));
        }
        this.lastValue = value1;
        this.lastValue2 = value2;
        return this.builder;
    }
}

