/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.Core;
import arc.audio.Music;
import arc.audio.RandomSound;
import arc.audio.Sound;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Func;
import arc.func.Prov;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.geom.Mat3D;
import arc.math.geom.Rect;
import arc.math.geom.Vec3;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Scl;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.I18NBundle;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import arc.util.serialization.Jval;
import arc.util.serialization.SerializationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitStance;
import mindustry.ai.types.FlyingAI;
import mindustry.content.Blocks;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Loadouts;
import mindustry.content.TechTree;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.MassDriverBolt;
import mindustry.entities.bullet.MultiBulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.ParticleEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.units.UnitController;
import mindustry.game.Objectives;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.gen.BuildingTetherPayloadUnit;
import mindustry.gen.CrawlUnit;
import mindustry.gen.ElevationMoveUnit;
import mindustry.gen.Icon;
import mindustry.gen.LegsUnit;
import mindustry.gen.MechUnit;
import mindustry.gen.Musics;
import mindustry.gen.PayloadUnit;
import mindustry.gen.Sounds;
import mindustry.gen.TankUnit;
import mindustry.gen.TimedKillUnit;
import mindustry.gen.Unit;
import mindustry.gen.UnitEntity;
import mindustry.gen.UnitWaterMove;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.HexSkyMesh;
import mindustry.graphics.g3d.MatMesh;
import mindustry.graphics.g3d.MultiMesh;
import mindustry.graphics.g3d.NoiseMesh;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.ShaderSphereMesh;
import mindustry.graphics.g3d.SunMesh;
import mindustry.io.JsonIO;
import mindustry.io.SaveVersion;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.maps.planet.AsteroidGenerator;
import mindustry.mod.ClassMap;
import mindustry.mod.Mods;
import mindustry.type.AmmoType;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.type.StatusEffect;
import mindustry.type.TeamEntry;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.Weather;
import mindustry.type.ammo.ItemAmmoType;
import mindustry.type.ammo.PowerAmmoType;
import mindustry.type.weather.ParticleWeather;
import mindustry.world.Block;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeCoolant;
import mindustry.world.consumers.ConsumeItemCharged;
import mindustry.world.consumers.ConsumeItemExplode;
import mindustry.world.consumers.ConsumeItemExplosive;
import mindustry.world.consumers.ConsumeItemFlammable;
import mindustry.world.consumers.ConsumeItemList;
import mindustry.world.consumers.ConsumeItemRadioactive;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumeLiquidFlammable;
import mindustry.world.consumers.ConsumeLiquids;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BuildVisibility;
import mindustry.world.meta.Env;

public class ContentParser {
    private static final boolean ignoreUnknownFields = true;
    private static final ContentType[] typesToSearch = new ContentType[]{ContentType.block, ContentType.item, ContentType.unit, ContentType.liquid, ContentType.planet};
    static final ObjectSet<Class<?>> implicitNullable = ObjectSet.with(TextureRegion.class, TextureRegion[].class, TextureRegion[][].class, TextureRegion[][][].class);
    ObjectMap<Class<?>, ContentType> contentTypes = new ObjectMap();
    Seq<ParseListener> listeners = new Seq();
    boolean allowClassResolution = true;
    ObjectMap<Class<?>, FieldParser> classParsers = new ObjectMap<Class<?>, FieldParser>(){
        {
            this.put(Effect.class, (type, data) -> {
                if (data.isString()) {
                    return ContentParser.this.field(Fx.class, data);
                }
                if (data.isArray()) {
                    return new MultiEffect(ContentParser.this.parser.readValue(Effect[].class, data));
                }
                Class<ParticleEffect> bc = ContentParser.this.resolve(data.getString("type", ""), ParticleEffect.class);
                data.remove("type");
                Effect result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(Units.Sortf.class, (type, data) -> ContentParser.this.field(UnitSorts.class, data));
            this.put(Interp.class, (type, data) -> ContentParser.this.field(Interp.class, data));
            this.put(Blending.class, (type, data) -> ContentParser.this.field(Blending.class, data));
            this.put(CacheLayer.class, (type, data) -> ContentParser.this.field(CacheLayer.class, data));
            this.put(Attribute.class, (type, data) -> {
                String attr = data.asString();
                if (Attribute.exists(attr)) {
                    return Attribute.get(attr);
                }
                return Attribute.add(attr);
            });
            this.put(BuildVisibility.class, (type, data) -> ContentParser.this.field(BuildVisibility.class, data));
            this.put(Schematic.class, (type, data) -> {
                Object result = ContentParser.this.fieldOpt(Loadouts.class, data);
                if (result != null) {
                    return result;
                }
                String str = data.asString();
                if (str.startsWith("bXNjaA")) {
                    return Schematics.readBase64(str);
                }
                return Schematics.read(Vars.tree.get("schematics/" + str + "." + "msch"));
            });
            this.put(TextureRegion.class, (type, data) -> {
                TextureRegionDrawable icon;
                if (Core.atlas == null) {
                    return null;
                }
                String str = data.asString();
                if (str.startsWith("icon-") && (icon = Icon.icons.get(str.substring("icon-".length()))) != null) {
                    icon.getRegion().scale = 1.0f / Scl.scl(1.0f);
                    return icon.getRegion();
                }
                TextureAtlas.AtlasRegion result = Core.atlas.find(str);
                if (!result.found()) {
                    ContentParser.this.warn("Sprite not found: '" + str + "'", new Object[0]);
                }
                return result;
            });
            this.put(Color.class, (type, data) -> Color.valueOf(data.asString()));
            this.put(StatusEffect.class, (type, data) -> {
                if (data.isString()) {
                    StatusEffect result = (StatusEffect)ContentParser.this.locate(ContentType.status, data.asString());
                    if (result != null) {
                        return result;
                    }
                    throw new IllegalArgumentException("Unknown status effect: '" + data.asString() + "'");
                }
                StatusEffect effect = new StatusEffect((ContentParser.this.currentMod == null ? null : ContentParser.this.currentMod.name + "-") + data.getString("name"));
                effect.minfo.mod = ContentParser.this.currentMod;
                ContentParser.this.readFields(effect, data);
                return effect;
            });
            this.put(UnitCommand.class, (type, data) -> {
                if (data.isString()) {
                    UnitCommand cmd = Vars.content.unitCommand(data.asString());
                    if (cmd != null) {
                        return cmd;
                    }
                    throw new IllegalArgumentException("Unknown unit command name: " + data.asString());
                }
                throw new IllegalArgumentException("Unit commands must be strings.");
            });
            this.put(UnitStance.class, (type, data) -> {
                if (data.isString()) {
                    UnitStance cmd = Vars.content.unitStance(data.asString());
                    if (cmd != null) {
                        return cmd;
                    }
                    throw new IllegalArgumentException("Unknown unit stance name: " + data.asString());
                }
                throw new IllegalArgumentException("Unit stances must be strings.");
            });
            this.put(BulletType.class, (type, data) -> {
                if (data.isString()) {
                    return ContentParser.this.field(Bullets.class, data);
                }
                if (data.isArray()) {
                    return new MultiBulletType(ContentParser.this.parser.readValue(BulletType[].class, data));
                }
                Class<Object> alternate = ContentParser.this.resolve(Strings.capitalize(data.getString("type", "basic")) + "BulletType", Object.class, false);
                Class<Object> bc = alternate == Object.class ? ContentParser.this.resolve(data.getString("type", ""), BasicBulletType.class) : alternate;
                data.remove("type");
                BulletType result = (BulletType)ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(MassDriverBolt.class, (type, data) -> {
                MassDriverBolt result = ContentParser.this.make(MassDriverBolt.class);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(AmmoType.class, (type, data) -> {
                if (data.isString()) {
                    return new ItemAmmoType((Item)ContentParser.this.find(ContentType.item, data.asString()));
                }
                if (data.isNumber()) {
                    return new PowerAmmoType(data.asFloat());
                }
                Class<ItemAmmoType> bc = ContentParser.this.resolve(data.getString("type", ""), ItemAmmoType.class);
                data.remove("type");
                AmmoType result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(DrawBlock.class, (type, data) -> {
                if (data.isString()) {
                    return ContentParser.this.make(ContentParser.this.resolve(data.asString()));
                }
                if (data.isArray()) {
                    return new DrawMulti(ContentParser.this.parser.readValue(DrawBlock[].class, data));
                }
                Class<DrawDefault> bc = ContentParser.this.resolve(data.getString("type", ""), DrawDefault.class);
                data.remove("type");
                DrawBlock result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(ShootPattern.class, (type, data) -> {
                Class<ShootPattern> bc = ContentParser.this.resolve(data.getString("type", ""), ShootPattern.class);
                data.remove("type");
                ShootPattern result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(DrawPart.class, (type, data) -> {
                Class<RegionPart> bc = ContentParser.this.resolve(data.getString("type", ""), RegionPart.class);
                data.remove("type");
                RegionPart result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(DrawPart.PartProgress.class, (type, data) -> {
                JsonValue opval;
                if (data.isString()) {
                    return ContentParser.this.field(DrawPart.PartProgress.class, data.asString());
                }
                if (data.isNumber()) {
                    return DrawPart.PartProgress.constant(data.asFloat());
                }
                if (!data.has("type")) {
                    throw new RuntimeException("PartProgress object need a 'type' string field. Check the PartProgress class for a list of constants.");
                }
                DrawPart.PartProgress base = (DrawPart.PartProgress)ContentParser.this.field(DrawPart.PartProgress.class, data.getString("type"));
                JsonValue jsonValue = data.has("operation") ? data.get("operation") : (opval = data.has("op") ? data.get("op") : null);
                if (opval == null) {
                    JsonValue opsVal;
                    JsonValue jsonValue2 = data.has("operations") ? data.get("operations") : (opsVal = data.has("ops") ? data.get("ops") : null);
                    if (opsVal != null) {
                        JsonValue val;
                        if (!opsVal.isArray()) {
                            throw new RuntimeException("Chained PartProgress operations must be an array.");
                        }
                        int i = 0;
                        while ((val = opsVal.get(i)) != null) {
                            JsonValue op = val.has("operation") ? val.get("operation") : (val.has("op") ? val.get("op") : null);
                            base = ContentParser.this.parseProgressOp(base, op.asString(), val);
                            ++i;
                        }
                    }
                    return base;
                }
                String op = opval.asString();
                return ContentParser.this.parseProgressOp(base, op, data);
            });
            this.put(PlanetGenerator.class, (type, data) -> {
                AsteroidGenerator result = new AsteroidGenerator();
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(Mat3D.class, (type, data) -> {
                if (data == null) {
                    return new Mat3D();
                }
                if (data.has("x") && data.has("y") && data.has("z")) {
                    return new Mat3D().translate(data.getFloat("x", 0.0f), data.getFloat("y", 0.0f), data.getFloat("z", 0.0f));
                }
                if (data.isArray() && data.size == 3) {
                    return new Mat3D().setToTranslation(new Vec3(data.asFloatArray()));
                }
                Mat3D mat = new Mat3D();
                block20: for (JsonValue val : data) {
                    switch (val.name) {
                        case "translate": 
                        case "trans": {
                            mat.translate(ContentParser.this.parser.readValue(Vec3.class, data));
                            continue block20;
                        }
                        case "scale": 
                        case "scl": {
                            mat.scale(ContentParser.this.parser.readValue(Vec3.class, data));
                            continue block20;
                        }
                        case "rotate": 
                        case "rot": {
                            mat.rotate(ContentParser.this.parser.readValue(Vec3.class, data), data.getFloat("degrees", 0.0f));
                            continue block20;
                        }
                        case "multiply": 
                        case "mul": {
                            mat.mul(ContentParser.this.parser.readValue(Mat3D.class, data));
                            continue block20;
                        }
                        case "x": 
                        case "y": 
                        case "z": {
                            continue block20;
                        }
                    }
                    throw new RuntimeException("Unknown matrix transformation: '" + val.name + "'");
                }
                return mat;
            });
            this.put(Vec3.class, (type, data) -> {
                if (data.isArray()) {
                    return new Vec3(data.asFloatArray());
                }
                return new Vec3(data.getFloat("x", 0.0f), data.getFloat("y", 0.0f), data.getFloat("z", 0.0f));
            });
            this.put(Sound.class, (type, data) -> {
                if (data.isArray()) {
                    return new RandomSound(ContentParser.this.parser.readValue(Sound[].class, data));
                }
                Object field = ContentParser.this.fieldOpt(Sounds.class, data);
                return field != null ? field : Vars.tree.loadSound(data.asString());
            });
            this.put(Music.class, (type, data) -> {
                Object field = ContentParser.this.fieldOpt(Musics.class, data);
                return field != null ? field : Vars.tree.loadMusic(data.asString());
            });
            this.put(Objectives.Objective.class, (type, data) -> {
                if (data.isString()) {
                    MappableContent cont = ContentParser.this.locateAny(data.asString());
                    if (cont == null) {
                        throw new IllegalArgumentException("Unknown objective content: " + data.asString());
                    }
                    return new Objectives.Research((UnlockableContent)cont);
                }
                Class<Objectives.SectorComplete> oc = ContentParser.this.resolve(data.getString("type", ""), Objectives.SectorComplete.class);
                data.remove("type");
                Objectives.Objective obj = ContentParser.this.make(oc);
                ContentParser.this.readFields(obj, data);
                return obj;
            });
            this.put(Ability.class, (type, data) -> {
                Class oc = ContentParser.this.resolve(data.getString("type", ""));
                data.remove("type");
                Ability obj = (Ability)ContentParser.this.make(oc);
                ContentParser.this.readFields(obj, data);
                return obj;
            });
            this.put(Weapon.class, (type, data) -> {
                Class<Weapon> oc = ContentParser.this.resolve(data.getString("type", ""), Weapon.class);
                data.remove("type");
                Weapon weapon = ContentParser.this.make(oc);
                ContentParser.this.readFields(weapon, data);
                if (ContentParser.this.currentMod != null) {
                    weapon.name = ContentParser.this.currentMod.name + "-" + weapon.name;
                }
                return weapon;
            });
            this.put(Consume.class, (type, data) -> {
                Class<Consume> oc = ContentParser.this.resolve(data.getString("type", ""), Consume.class);
                data.remove("type");
                Consume consume = ContentParser.this.make(oc);
                ContentParser.this.readFields(consume, data);
                return consume;
            });
            this.put(ConsumeLiquidBase.class, (type, data) -> {
                Class<ConsumeLiquidBase> oc = ContentParser.this.resolve(data.getString("type", ""), ConsumeLiquidBase.class);
                data.remove("type");
                ConsumeLiquidBase consume = ContentParser.this.make(oc);
                ContentParser.this.readFields(consume, data);
                return consume;
            });
            this.put(Team.class, (type, data) -> {
                if (data.isString()) {
                    Team out = Structs.find(Team.baseTeams, t -> t.name.equals(data.asString()));
                    if (out == null) {
                        throw new IllegalArgumentException("Unknown team: " + data.asString());
                    }
                    return out;
                }
                if (data.isNumber()) {
                    if (data.asInt() >= Team.all.length || data.asInt() < 0) {
                        throw new IllegalArgumentException("Unknown team: " + data.asString());
                    }
                    return Team.get(data.asInt());
                }
                throw new IllegalArgumentException("Unknown team: " + data.asString() + ". Team must either be a string or a number.");
            });
        }
    };
    private Seq<Runnable> reads = new Seq();
    private Seq<Runnable> postreads = new Seq();
    private ObjectSet<Object> toBeParsed = new ObjectSet();
    Mods.LoadedMod currentMod;
    Content currentContent;
    private Json parser = new Json(){

        @Override
        protected <T> Class<T> resolveClass(String className) {
            if (ContentParser.this.allowClassResolution) {
                return super.resolveClass(className);
            }
            throw new SerializationException("Resolving arbitrary classes (" + className + ") is not allowed. Use short names for classes only (without the package prefix).");
        }

        @Override
        public <T> T readValue(Class<T> type, Class elementType, JsonValue jsonData, Class keyType) {
            Object t = this.internalRead(type, elementType, jsonData, keyType);
            if (!(t == null || Reflect.isWrapper(t.getClass()) || type != null && type.isPrimitive())) {
                ContentParser.this.checkNullFields(t);
                ContentParser.this.listeners.each(hook -> hook.parsed(type, jsonData, t));
            }
            return t;
        }

        private <T> T internalRead(Class<T> type, Class elementType, JsonValue jsonData, Class keyType) {
            if (type != null) {
                if (ContentParser.this.classParsers.containsKey(type)) {
                    try {
                        return (T)ContentParser.this.classParsers.get(type).parse(type, jsonData);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                if ((type == Integer.TYPE || type == Integer.class) && jsonData.isArray()) {
                    int n;
                    boolean bl = false;
                    for (JsonValue str : jsonData) {
                        if (!str.isString()) {
                            throw new SerializationException("Integer bitfield values must all be strings. Found: " + str);
                        }
                        String field = str.asString();
                        n |= ((Integer)Reflect.get(Env.class, field)).intValue();
                    }
                    return (T)Integer.valueOf(n);
                }
                if (type == ItemStack.class && jsonData.isString() && jsonData.asString().contains("/")) {
                    String[] stringArray = jsonData.asString().split("/");
                    return (T)this.fromJson(ItemStack.class, "{item: " + stringArray[0] + ", amount: " + stringArray[1] + "}");
                }
                if (type == PayloadStack.class && jsonData.isString() && jsonData.asString().contains("/")) {
                    String[] stringArray = jsonData.asString().split("/");
                    int number = Strings.parseInt(stringArray[1], 1);
                    UnlockableContent cont = Vars.content.unit(stringArray[0]) == null ? Vars.content.block(stringArray[0]) : Vars.content.unit(stringArray[0]);
                    return (T)new PayloadStack(cont == null ? Blocks.router : cont, number);
                }
                if (jsonData.isString() && jsonData.asString().contains("/")) {
                    String[] stringArray = jsonData.asString().split("/");
                    if (type == LiquidStack.class) {
                        return (T)this.fromJson(LiquidStack.class, "{liquid: " + stringArray[0] + ", amount: " + stringArray[1] + "}");
                    }
                    if (type == ConsumeLiquid.class) {
                        return (T)this.fromJson(ConsumeLiquid.class, "{liquid: " + stringArray[0] + ", amount: " + stringArray[1] + "}");
                    }
                }
                if (type == Rect.class && jsonData.isArray() && jsonData.size == 4) {
                    return (T)new Rect(jsonData.get(0).asFloat(), jsonData.get(1).asFloat(), jsonData.get(2).asFloat(), jsonData.get(3).asFloat());
                }
                if (type == UnlockableContent.class) {
                    for (ContentType c : typesToSearch) {
                        MappableContent found = ContentParser.this.locate(c, jsonData.asString());
                        if (found == null) continue;
                        return (T)found;
                    }
                    throw new IllegalArgumentException("\"" + jsonData.name + "\": No content found with name '" + jsonData.asString() + "'.");
                }
                if (Content.class.isAssignableFrom(type)) {
                    String prefix;
                    ContentType contentType = ContentParser.this.contentTypes.getThrow(type, () -> new IllegalArgumentException("No content type for class: " + type.getSimpleName()));
                    Object one = Vars.content.getByName(contentType, (prefix = ContentParser.this.currentMod != null ? ContentParser.this.currentMod.name + "-" : "") + jsonData.asString());
                    if (one != null) {
                        return one;
                    }
                    Object two = Vars.content.getByName(contentType, jsonData.asString());
                    if (two != null) {
                        return two;
                    }
                    throw new IllegalArgumentException((jsonData.name == null ? "" : "\"" + jsonData.name + "\": ") + "No " + (Object)((Object)contentType) + " found with name '" + jsonData.asString() + "'.\nMake sure '" + jsonData.asString() + "' is spelled correctly, and that it really exists!\nThis may also occur because its file failed to parse.");
                }
            }
            return super.readValue(type, elementType, jsonData, keyType);
        }
    };
    private ObjectMap<ContentType, TypeParser<?>> parsers = ObjectMap.of(new Object[]{ContentType.block, (mod, name, value) -> {
        Block block;
        this.readBundle(ContentType.block, name, value);
        if (this.locate(ContentType.block, name) != null) {
            if (value.has("type")) {
                this.warn("Warning: '" + this.currentMod.name + "-" + name + "' re-declares a type. This will be interpreted as a new block. If you wish to override a vanilla block, omit the 'type' section, as vanilla block `type`s cannot be changed.", new Object[0]);
                block = this.make(this.resolve(value.getString("type", ""), Block.class), mod + "-" + name);
            } else {
                block = (Block)this.locate(ContentType.block, name);
            }
        } else {
            block = this.make(this.resolve(value.getString("type", ""), Block.class), mod + "-" + name);
        }
        this.currentContent = block;
        this.read(() -> {
            if (value.has("consumes") && value.get("consumes").isObject()) {
                this.readBlockConsumers(block, value.get("consumes"));
                value.remove("consumes");
            }
            this.readFields(block, value, true);
            if (block.size > 16) {
                throw new IllegalArgumentException("Blocks cannot be larger than 16");
            }
            if (value.has("requirements") && block.buildVisibility == BuildVisibility.hidden) {
                block.buildVisibility = BuildVisibility.shown;
            }
        });
        return block;
    }, ContentType.unit, (mod, name, value) -> {
        UnitType unit;
        this.readBundle(ContentType.unit, name, value);
        if (this.locate(ContentType.unit, name) == null) {
            unit = this.make(this.resolve(value.getString("template", ""), UnitType.class), mod + "-" + name);
            if (value.has("template")) {
                value.remove("template");
            }
            JsonValue typeVal = value.get("type");
            if (unit.constructor == null || typeVal != null) {
                if (typeVal != null && !typeVal.isString()) {
                    throw new RuntimeException("Unit '" + name + "' has an incorrect type. Types must be strings.");
                }
                unit.constructor = this.unitType(typeVal);
            }
        } else {
            unit = (UnitType)this.locate(ContentType.unit, name);
        }
        this.currentContent = unit;
        this.read(() -> {
            if (value.has("requirements")) {
                JsonValue rec = value.remove("requirements");
                UnitReq req = this.parser.readValue(UnitReq.class, rec);
                Block patt27182$temp = req.block;
                if (patt27182$temp instanceof Reconstructor) {
                    Reconstructor r = (Reconstructor)patt27182$temp;
                    if (req.previous != null) {
                        r.upgrades.add(new UnitType[]{req.previous, unit});
                    }
                } else {
                    Block patt27406$temp = req.block;
                    if (patt27406$temp instanceof UnitFactory) {
                        UnitFactory f = (UnitFactory)patt27406$temp;
                        f.plans.add(new UnitFactory.UnitPlan(unit, req.time, req.requirements));
                    } else {
                        throw new IllegalArgumentException("Missing a valid 'block' in 'requirements'");
                    }
                }
            }
            if (value.has("controller") || value.has("aiController")) {
                unit.aiController = this.supply(this.resolve(value.getString("controller", value.getString("aiController", "")), FlyingAI.class));
                value.remove("controller");
            }
            if (value.has("defaultController")) {
                Prov<FlyingAI> sup = this.supply(this.resolve(value.getString("defaultController"), FlyingAI.class));
                unit.controller = u -> (UnitController)sup.get();
                value.remove("defaultController");
            }
            if (value.has("waves")) {
                SpawnGroup[] groups;
                JsonValue waves = value.remove("waves");
                for (SpawnGroup group : groups = this.parser.readValue(SpawnGroup[].class, waves)) {
                    group.type = unit;
                }
                Vars.waves.get().addAll((SpawnGroup[])groups);
            }
            this.readFields(unit, value, true);
        });
        return unit;
    }, ContentType.weather, (mod, name, value) -> {
        Weather item;
        if (this.locate(ContentType.weather, name) != null) {
            item = (Weather)this.locate(ContentType.weather, name);
            this.readBundle(ContentType.weather, name, value);
        } else {
            this.readBundle(ContentType.weather, name, value);
            item = this.make(this.resolve(this.getType(value), ParticleWeather.class), mod + "-" + name);
            value.remove("type");
        }
        this.currentContent = item;
        this.read(() -> this.readFields(item, value));
        return item;
    }, ContentType.item, this.parser(ContentType.item, Item::new), ContentType.liquid, (mod, name, value) -> {
        Liquid liquid;
        if (this.locate(ContentType.liquid, name) != null) {
            liquid = (Liquid)this.locate(ContentType.liquid, name);
            this.readBundle(ContentType.liquid, name, value);
        } else {
            this.readBundle(ContentType.liquid, name, value);
            liquid = this.make(this.resolve(value.getString("type", null), Liquid.class), mod + "-" + name);
            value.remove("type");
        }
        this.currentContent = liquid;
        this.read(() -> this.readFields(liquid, value));
        return liquid;
    }, ContentType.status, this.parser(ContentType.status, StatusEffect::new), ContentType.sector, (mod, name, value) -> {
        if (value.isString()) {
            return (SectorPreset)this.locate(ContentType.sector, name);
        }
        if (!value.has("sector") || !value.get("sector").isNumber()) {
            throw new RuntimeException("SectorPresets must have a sector number.");
        }
        SectorPreset out = new SectorPreset(mod + "-" + name, this.currentMod);
        this.currentContent = out;
        this.read(() -> {
            Planet planet = (Planet)this.locate(ContentType.planet, value.getString("planet", "serpulo"));
            if (planet == null) {
                throw new RuntimeException("Planet '" + value.getString("planet") + "' not found.");
            }
            out.initialize(planet, value.getInt("sector", 0));
            value.remove("sector");
            value.remove("planet");
            if (value.has("rules")) {
                JsonValue r = value.remove("rules");
                if (!r.isObject()) {
                    throw new RuntimeException("Rules must be an object!");
                }
                out.rules = rules -> {
                    try {
                        JsonIO.json.readFields(rules, r);
                    }
                    catch (Throwable e) {
                        Log.err(e);
                    }
                };
            }
            this.readFields(out, value);
        });
        return out;
    }, ContentType.planet, (mod, name, value) -> {
        JsonValue mesh;
        if (value.isString()) {
            return (Planet)this.locate(ContentType.planet, name);
        }
        Planet parent = (Planet)this.locate(ContentType.planet, value.getString("parent", ""));
        Planet planet = new Planet(mod + "-" + name, parent, value.getFloat("radius", 1.0f), value.getInt("sectorSize", 0));
        value.remove("sectorSize");
        if (value.has("mesh")) {
            mesh = value.get("mesh");
            if (!mesh.isObject() && !mesh.isArray()) {
                throw new RuntimeException("Meshes must be objects.");
            }
            value.remove("mesh");
            planet.meshLoader = () -> {
                try {
                    return this.parseMesh(planet, mesh);
                }
                catch (Exception e) {
                    Log.err(e);
                    return new ShaderSphereMesh(planet, Shaders.unlit, 2);
                }
            };
        }
        if (value.has("cloudMesh")) {
            mesh = value.get("cloudMesh");
            if (!mesh.isObject() && !mesh.isArray()) {
                throw new RuntimeException("Meshes must be objects.");
            }
            value.remove("cloudMesh");
            planet.cloudMeshLoader = () -> {
                try {
                    return this.parseMesh(planet, mesh);
                }
                catch (Exception e) {
                    Log.err(e);
                    return null;
                }
            };
        }
        planet.sectors.add(new Sector(planet, PlanetGrid.Ptile.empty));
        this.currentContent = planet;
        this.read(() -> this.readFields(planet, value));
        return planet;
    }, ContentType.team, (mod, name, value) -> {
        TeamEntry entry;
        if (!value.has("team")) {
            throw new RuntimeException("Team field missing.");
        }
        Team team = (Team)this.classParsers.get(Team.class).parse(Team.class, value.get("team"));
        value.remove("team");
        if (this.locate(ContentType.team, name) != null) {
            entry = (TeamEntry)this.locate(ContentType.team, name);
            this.readBundle(ContentType.team, name, value);
        } else {
            this.readBundle(ContentType.team, name, value);
            entry = new TeamEntry(mod + "-" + name, team);
        }
        this.currentContent = entry;
        this.read(() -> this.readFields(entry, value));
        return entry;
    }});

    public void readBlockConsumers(Block block, JsonValue value) {
        block34: for (JsonValue child : value) {
            switch (child.name) {
                case "remove": {
                    String[] values;
                    String[] stringArray;
                    if (child.isString()) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = child.asString();
                    } else {
                        stringArray = child.asStringArray();
                    }
                    for (String type : values = stringArray) {
                        if (type.equals("all")) {
                            block.removeConsumers(b -> true);
                            continue;
                        }
                        Class<Consume> consumeType = this.resolve("Consume" + Strings.capitalize(type), Consume.class);
                        if (consumeType != Consume.class) {
                            block.removeConsumers(b -> consumeType.isAssignableFrom(b.getClass()));
                            continue;
                        }
                        this.warn("Unknown consumer type '@' (Class: @) in consume: remove.", type, "Consume" + Strings.capitalize(type));
                    }
                    continue block34;
                }
                case "item": {
                    block.consumeItem((Item)this.find(ContentType.item, child.asString()));
                    break;
                }
                case "itemCharged": {
                    block.consume((Consume)this.parser.readValue(ConsumeItemCharged.class, child));
                    break;
                }
                case "itemFlammable": {
                    block.consume((Consume)this.parser.readValue(ConsumeItemFlammable.class, child));
                    break;
                }
                case "itemRadioactive": {
                    block.consume((Consume)this.parser.readValue(ConsumeItemRadioactive.class, child));
                    break;
                }
                case "itemExplosive": {
                    block.consume((Consume)this.parser.readValue(ConsumeItemExplosive.class, child));
                    break;
                }
                case "itemList": {
                    block.consume((Consume)this.parser.readValue(ConsumeItemList.class, child));
                    break;
                }
                case "itemExplode": {
                    block.consume((Consume)this.parser.readValue(ConsumeItemExplode.class, child));
                    break;
                }
                case "items": {
                    block.consume(child.isArray() ? new ConsumeItems(this.parser.readValue(ItemStack[].class, child)) : (child.isString() ? new ConsumeItems(new ItemStack[]{this.parser.readValue(ItemStack.class, child)}) : this.parser.readValue(ConsumeItems.class, child)));
                    break;
                }
                case "liquidFlammable": {
                    block.consume((Consume)this.parser.readValue(ConsumeLiquidFlammable.class, child));
                    break;
                }
                case "liquid": {
                    block.consume((Consume)this.parser.readValue(ConsumeLiquid.class, child));
                    break;
                }
                case "liquids": {
                    block.consume(child.isArray() ? new ConsumeLiquids(this.parser.readValue(LiquidStack[].class, child)) : this.parser.readValue(ConsumeLiquids.class, child));
                    break;
                }
                case "coolant": {
                    block.consume((Consume)this.parser.readValue(ConsumeCoolant.class, child));
                    break;
                }
                case "power": {
                    if (child.isNumber()) {
                        block.consumePower(child.asFloat());
                        break;
                    }
                    block.consume((Consume)this.parser.readValue(ConsumePower.class, child));
                    break;
                }
                case "powerBuffered": {
                    block.consumePowerBuffered(child.asFloat());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown consumption type: '" + child.name + "' for block '" + block.name + "'.");
                }
            }
        }
        value.remove("consumes");
    }

    Prov<Unit> unitType(JsonValue value) {
        Prov<Unit> prov;
        if (value == null) {
            return UnitEntity::create;
        }
        switch (value.asString()) {
            case "flying": {
                prov = UnitEntity::create;
                break;
            }
            case "mech": {
                prov = MechUnit::create;
                break;
            }
            case "legs": {
                prov = LegsUnit::create;
                break;
            }
            case "naval": {
                prov = UnitWaterMove::create;
                break;
            }
            case "payload": {
                prov = PayloadUnit::create;
                break;
            }
            case "missile": {
                prov = TimedKillUnit::create;
                break;
            }
            case "tank": {
                prov = TankUnit::create;
                break;
            }
            case "hover": {
                prov = ElevationMoveUnit::create;
                break;
            }
            case "tether": {
                prov = BuildingTetherPayloadUnit::create;
                break;
            }
            case "crawl": {
                prov = CrawlUnit::create;
                break;
            }
            default: {
                throw new RuntimeException("Invalid unit type: '" + value + "'. Must be 'flying/mech/legs/naval/payload/missile/tether/crawl'.");
            }
        }
        return prov;
    }

    private String getString(JsonValue value, String key) {
        if (value.has(key)) {
            return value.getString(key);
        }
        throw new IllegalArgumentException("You are missing a \"" + key + "\". It must be added before the file can be parsed.");
    }

    private String getType(JsonValue value) {
        return this.getString(value, "type");
    }

    private <T extends Content> T find(ContentType type, String name) {
        Object c = Vars.content.getByName(type, name);
        if (c == null && this.currentMod != null) {
            c = Vars.content.getByName(type, this.currentMod.name + "-" + name);
        }
        if (c == null) {
            throw new IllegalArgumentException("No " + (Object)((Object)type) + " found with name '" + name + "'");
        }
        return c;
    }

    private <T extends Content> TypeParser<T> parser(ContentType type, Func<String, T> constructor) {
        return (mod, name, value) -> {
            Object item;
            if (this.locate(type, name) != null) {
                item = this.locate(type, name);
                this.readBundle(type, name, value);
            } else {
                this.readBundle(type, name, value);
                item = (Content)constructor.get(mod + "-" + name);
            }
            this.currentContent = item;
            this.read(() -> this.readFields(item, value));
            return item;
        };
    }

    private void readBundle(ContentType type, String name, JsonValue value) {
        UnlockableContent cont = this.locate(type, name) instanceof UnlockableContent ? (UnlockableContent)this.locate(type, name) : null;
        String entryName = cont == null ? (Object)((Object)type) + "." + this.currentMod.name + "-" + name + "." : (Object)((Object)type) + "." + cont.name + ".";
        I18NBundle bundle = Core.bundle;
        while (bundle.getParent() != null) {
            bundle = bundle.getParent();
        }
        if (value.has("name")) {
            if (!Core.bundle.has(entryName + "name")) {
                bundle.getProperties().put(entryName + "name", value.getString("name"));
                if (cont != null) {
                    cont.localizedName = value.getString("name");
                }
            }
            value.remove("name");
        }
        if (value.has("description")) {
            if (!Core.bundle.has(entryName + "description")) {
                bundle.getProperties().put(entryName + "description", value.getString("description"));
                if (cont != null) {
                    cont.description = value.getString("description");
                }
            }
            value.remove("description");
        }
    }

    private void read(Runnable run) {
        Content cont = this.currentContent;
        Mods.LoadedMod mod = this.currentMod;
        this.reads.add(() -> {
            this.currentMod = mod;
            this.currentContent = cont;
            run.run();
            if (cont != null) {
                this.toBeParsed.remove(cont);
                this.checkNullFields(cont);
            }
        });
    }

    private void init() {
        for (ContentType type : ContentType.all) {
            Seq arr = Vars.content.getBy(type);
            if (arr.isEmpty()) continue;
            Class<?> c = ((Content)arr.first()).getClass();
            while (c.getSuperclass() != Content.class && c.getSuperclass() != UnlockableContent.class && !Modifier.isAbstract(c.getSuperclass().getModifiers())) {
                c = c.getSuperclass();
            }
            this.contentTypes.put(c, type);
        }
    }

    private void attempt(Runnable run) {
        try {
            run.run();
        }
        catch (Throwable t) {
            Log.err(t);
            this.markError(this.currentContent, t);
        }
    }

    public void finishParsing() {
        this.reads.each(this::attempt);
        this.postreads.each(this::attempt);
        this.reads.clear();
        this.postreads.clear();
        this.toBeParsed.clear();
        this.currentMod = null;
    }

    public Content parse(Mods.LoadedMod mod, String name, String json, Fi file, ContentType type) throws Exception {
        this.checkInit();
        if (file.extension().equals("json")) {
            json = json.replace("#", "\\#");
        }
        this.currentMod = mod;
        JsonValue value = (JsonValue)this.parser.fromJson(null, Jval.read(json).toString(Jval.Jformat.plain));
        if (!this.parsers.containsKey(type)) {
            throw new SerializationException("No parsers for content type '" + (Object)((Object)type) + "'");
        }
        boolean located = this.locate(type, name) != null;
        Object c = this.parsers.get(type).parse(mod.name, name, value);
        ((Content)c).minfo.sourceFile = file;
        this.toBeParsed.add(c);
        if (!located) {
            ((Content)c).minfo.mod = mod;
        }
        this.currentMod = null;
        return c;
    }

    public void checkInit() {
        if (this.contentTypes.isEmpty()) {
            this.init();
        }
    }

    public void markError(Content content, Mods.LoadedMod mod, Fi file, Throwable error) {
        Log.err("Error for @ / @:\n@\n", content, file, Strings.getStackTrace(error));
        content.minfo.mod = mod;
        content.minfo.sourceFile = file;
        content.minfo.error = this.makeError(error, file);
        content.minfo.baseError = error;
        if (mod != null) {
            mod.erroredContent.add(content);
        }
    }

    public void markError(Content content, Throwable error) {
        if (content.minfo != null && !content.hasErrored()) {
            this.markError(content, content.minfo.mod, content.minfo.sourceFile, error);
        }
    }

    private String makeError(Throwable t, Fi file) {
        StringBuilder builder = new StringBuilder();
        builder.append("[lightgray]").append("File: ").append(file.name()).append("[]\n\n");
        if (t.getMessage() != null && t instanceof Jval.JsonParseException) {
            builder.append("[accent][[JsonParse][] ").append(":\n").append(t.getMessage());
        } else if (t instanceof NullPointerException) {
            builder.append(Strings.neatError(t));
        } else {
            Seq<Throwable> causes = Strings.getCauses(t);
            for (Throwable e : causes) {
                builder.append("[accent][[").append(e.getClass().getSimpleName().replace("Exception", "")).append("][] ").append(e.getMessage() != null ? e.getMessage().replace("mindustry.", "").replace("arc.", "") : "").append("\n");
            }
        }
        return builder.toString();
    }

    private <T extends MappableContent> T locate(ContentType type, String name) {
        Object first = Vars.content.getByName(type, name);
        return first != null ? first : Vars.content.getByName(type, this.currentMod == null ? name : this.currentMod.name + "-" + name);
    }

    private <T extends MappableContent> T locateAny(String name) {
        for (ContentType t : ContentType.all) {
            T out = this.locate(t, name);
            if (out == null) continue;
            return out;
        }
        return null;
    }

    private GenericMesh[] parseMeshes(Planet planet, JsonValue array) {
        GenericMesh[] res = new GenericMesh[array.size];
        for (int i = 0; i < array.size; ++i) {
            res[i] = this.parseMesh(planet, array.get(i));
        }
        return res;
    }

    private GenericMesh parseMesh(Planet planet, JsonValue data) {
        GenericMesh genericMesh;
        String tname;
        if (data.isArray()) {
            return new MultiMesh(this.parseMeshes(planet, data));
        }
        switch (tname = Strings.capitalize(data.getString("type", "NoiseMesh"))) {
            case "NoiseMesh": {
                genericMesh = new NoiseMesh(planet, data.getInt("seed", 0), data.getInt("divisions", 1), data.getFloat("radius", 1.0f), data.getInt("octaves", 1), data.getFloat("persistence", 0.5f), data.getFloat("scale", 1.0f), data.getFloat("mag", 0.5f), Color.valueOf(data.getString("color1", data.getString("color", "ffffff"))), Color.valueOf(data.getString("color2", data.getString("color", "ffffff"))), data.getInt("colorOct", 1), data.getFloat("colorPersistence", 0.5f), data.getFloat("colorScale", 1.0f), data.getFloat("colorThreshold", 0.5f));
                break;
            }
            case "SunMesh": {
                String[] cvals = data.get("colors").asStringArray();
                Color[] colors = new Color[cvals.length];
                for (int i = 0; i < cvals.length; ++i) {
                    colors[i] = Color.valueOf(cvals[i]);
                }
                genericMesh = new SunMesh(planet, data.getInt("divisions", 1), data.getInt("octaves", 1), data.getFloat("persistence", 0.5f), data.getFloat("scl", 1.0f), data.getFloat("pow", 1.0f), data.getFloat("mag", 0.5f), data.getFloat("colorScale", 1.0f), colors);
                break;
            }
            case "HexSkyMesh": {
                genericMesh = new HexSkyMesh(planet, data.getInt("seed", 0), data.getFloat("speed", 0.0f), data.getFloat("radius", 1.0f), data.getInt("divisions", 3), Color.valueOf(data.getString("color", "ffffff")), data.getInt("octaves", 1), data.getFloat("persistence", 0.5f), data.getFloat("scale", 1.0f), data.getFloat("thresh", 0.5f));
                break;
            }
            case "MultiMesh": {
                genericMesh = new MultiMesh(this.parseMeshes(planet, data.get("meshes")));
                break;
            }
            case "MatMesh": {
                genericMesh = new MatMesh(this.parseMesh(planet, data.get("mesh")), this.parser.readValue(Mat3D.class, data.get("mat")));
                break;
            }
            default: {
                throw new RuntimeException("Unknown mesh type: " + tname);
            }
        }
        return genericMesh;
    }

    private DrawPart.PartProgress parseProgressOp(DrawPart.PartProgress base, String op, JsonValue data) {
        DrawPart.PartProgress partProgress;
        switch (op) {
            case "inv": {
                partProgress = base.inv();
                break;
            }
            case "slope": {
                partProgress = base.slope();
                break;
            }
            case "clamp": {
                partProgress = base.clamp();
                break;
            }
            case "delay": {
                partProgress = base.delay(data.getFloat("amount"));
                break;
            }
            case "sustain": {
                partProgress = base.sustain(data.getFloat("offset", 0.0f), data.getFloat("grow", 0.0f), data.getFloat("sustain"));
                break;
            }
            case "shorten": {
                partProgress = base.shorten(data.getFloat("amount"));
                break;
            }
            case "compress": {
                partProgress = base.compress(data.getFloat("start"), data.getFloat("end"));
                break;
            }
            case "add": {
                if (data.has("amount")) {
                    partProgress = base.add(data.getFloat("amount"));
                    break;
                }
                partProgress = base.add(this.parser.readValue(DrawPart.PartProgress.class, data.get("other")));
                break;
            }
            case "blend": {
                partProgress = base.blend(this.parser.readValue(DrawPart.PartProgress.class, data.get("other")), data.getFloat("amount"));
                break;
            }
            case "mul": {
                if (data.has("amount")) {
                    partProgress = base.mul(data.getFloat("amount"));
                    break;
                }
                partProgress = base.mul(this.parser.readValue(DrawPart.PartProgress.class, data.get("other")));
                break;
            }
            case "min": {
                partProgress = base.min(this.parser.readValue(DrawPart.PartProgress.class, data.get("other")));
                break;
            }
            case "sin": {
                partProgress = base.sin(data.has("offset") ? data.getFloat("offset") : 0.0f, data.getFloat("scl"), data.getFloat("mag"));
                break;
            }
            case "absin": {
                partProgress = base.absin(data.getFloat("scl"), data.getFloat("mag"));
                break;
            }
            case "mod": {
                partProgress = base.mod(data.getFloat("amount"));
                break;
            }
            case "loop": {
                partProgress = base.loop(data.getFloat("time"));
                break;
            }
            case "curve": {
                if (data.has("interp")) {
                    partProgress = base.curve(this.parser.readValue(Interp.class, data.get("interp")));
                    break;
                }
                partProgress = base.curve(data.getFloat("offset"), data.getFloat("duration"));
                break;
            }
            default: {
                throw new RuntimeException("Unknown operation '" + op + "', check PartProgress class for a list of methods.");
            }
        }
        return partProgress;
    }

    <T> T make(Class<T> type) {
        try {
            Constructor<T> cons = type.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T make(Class<T> type, String name) {
        try {
            Constructor<T> cons = type.getDeclaredConstructor(String.class);
            cons.setAccessible(true);
            return cons.newInstance(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Prov<T> supply(Class<T> type) {
        try {
            Constructor cons = type.getDeclaredConstructor(new Class[0]);
            return () -> {
                try {
                    return cons.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Object field(Class<?> type, JsonValue value) {
        return this.field(type, value.asString());
    }

    private Object field(Class<?> type, String name) {
        try {
            Object b = type.getField(name).get(null);
            if (b == null) {
                throw new IllegalArgumentException(type.getSimpleName() + ": not found: '" + name + "'");
            }
            return b;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Object fieldOpt(Class<?> type, JsonValue value) {
        try {
            return type.getField(value.asString()).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    void checkNullFields(Object object) {
        if (object == null || object instanceof Number || object instanceof String || this.toBeParsed.contains(object) || object.getClass().getName().startsWith("arc.")) {
            return;
        }
        this.parser.getFields(object.getClass()).values().toSeq().each(field -> {
            try {
                if (field.field.getType().isPrimitive()) {
                    return;
                }
                if (!field.field.isAnnotationPresent(Nullable.class) && field.field.get(object) == null && !implicitNullable.contains(field.field.getType())) {
                    throw new RuntimeException("'" + field.field.getName() + "' in " + (object.getClass().isAnonymousClass() ? object.getClass().getSuperclass() : object.getClass()).getSimpleName() + " is missing! Object = " + object + ", field = (" + field.field.getName() + " = " + field.field.get(object) + ")");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void readFields(Object object, JsonValue jsonMap, boolean stripType) {
        if (stripType) {
            jsonMap.remove("type");
        }
        this.readFields(object, jsonMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void readFields(Object object, JsonValue jsonMap) {
        ItemStack[] customRequirements;
        String researchName;
        JsonValue research = jsonMap.remove("research");
        this.toBeParsed.remove(object);
        Class<?> type = object.getClass();
        OrderedMap<String, Json.FieldMetadata> fields = this.parser.getFields(type);
        JsonValue child = jsonMap.child;
        while (child != null) {
            Json.FieldMetadata metadata = (Json.FieldMetadata)fields.get(child.name().replace(" ", "_"));
            if (metadata == null) {
                this.warn("@Unknown field '@' for class '@'", this.currentContent == null ? "" : "[" + this.currentContent.minfo.sourceFile.name() + "]: ", child.name, type.getSimpleName());
            } else {
                Field field = metadata.field;
                try {
                    if (child.isObject() && child.has("add") && (Seq.class.isAssignableFrom(field.getType()) || ObjectSet.class.isAssignableFrom(field.getType()))) {
                        Object readField = this.parser.readValue(field.getType(), metadata.elementType, child.get("add"), metadata.keyType);
                        Object fieldObj = field.get(object);
                        if (fieldObj instanceof ObjectSet) {
                            ObjectSet set = (ObjectSet)fieldObj;
                            set.addAll((ObjectSet)readField);
                        } else {
                            if (!(fieldObj instanceof Seq)) throw new SerializationException("This should be impossible");
                            Seq seq = (Seq)fieldObj;
                            seq.addAll((Seq)readField);
                        }
                    } else {
                        boolean mergeMap;
                        boolean isMap = ObjectMap.class.isAssignableFrom(field.getType()) || ObjectIntMap.class.isAssignableFrom(field.getType()) || ObjectFloatMap.class.isAssignableFrom(field.getType());
                        boolean bl = mergeMap = isMap && child.has("add") && child.get("add").isBoolean() && child.getBoolean("add", false);
                        if (mergeMap) {
                            child.remove("add");
                        }
                        Object readField = this.parser.readValue(field.getType(), metadata.elementType, child, metadata.keyType);
                        Object fieldObj = field.get(object);
                        if (mergeMap && (fieldObj instanceof ObjectMap || fieldObj instanceof ObjectIntMap || fieldObj instanceof ObjectFloatMap)) {
                            Object object2 = field.get(object);
                            if (object2 instanceof ObjectMap) {
                                ObjectMap baseMap = (ObjectMap)object2;
                                baseMap.putAll((ObjectMap)readField);
                            } else {
                                object2 = field.get(object);
                                if (object2 instanceof ObjectIntMap) {
                                    ObjectIntMap baseMap = (ObjectIntMap)object2;
                                    baseMap.putAll((ObjectIntMap)readField);
                                } else {
                                    object2 = field.get(object);
                                    if (object2 instanceof ObjectFloatMap) {
                                        ObjectFloatMap baseMap = (ObjectFloatMap)object2;
                                        baseMap.putAll((ObjectFloatMap)readField);
                                    }
                                }
                            }
                        } else {
                            field.set(object, readField);
                        }
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
                }
                catch (SerializationException ex) {
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
                catch (RuntimeException runtimeEx) {
                    SerializationException ex = new SerializationException(runtimeEx);
                    ex.addTrace(child.trace());
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
            }
            child = child.next;
        }
        if (!(object instanceof UnlockableContent)) return;
        UnlockableContent unlock = (UnlockableContent)object;
        if (research == null) return;
        if (research.isString()) {
            researchName = research.asString();
            customRequirements = null;
        } else {
            researchName = research.getString("parent", null);
            customRequirements = research.has("requirements") ? this.parser.readValue(ItemStack[].class, research.get("requirements")) : null;
        }
        TechTree.TechNode lastNode = TechTree.all.find(t -> t.content == unlock);
        if (lastNode != null) {
            lastNode.remove();
        }
        TechTree.TechNode node = new TechTree.TechNode(null, unlock, customRequirements == null ? ItemStack.empty : customRequirements);
        Mods.LoadedMod cur = this.currentMod;
        this.postreads.add(() -> {
            this.currentContent = unlock;
            this.currentMod = cur;
            if (research.has("objectives")) {
                node.objectives.addAll((Objectives.Objective[])this.parser.readValue(Objectives.Objective[].class, research.get("objectives")));
            }
            if ((unlock instanceof Item || unlock instanceof Liquid) && !node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)o -> {
                if (!(o instanceof Objectives.Produce)) return false;
                Objectives.Produce p = (Objectives.Produce)o;
                if (p.content != unlock) return false;
                return true;
            })))) {
                node.objectives.add(new Objectives.Produce(unlock));
            }
            if (node.parent != null) {
                node.parent.children.remove(node);
            }
            if (customRequirements == null) {
                node.setupRequirements(unlock.researchRequirements());
            }
            if (research.has("planet")) {
                node.planet = (Planet)this.find(ContentType.planet, research.getString("planet"));
            }
            if (research.getBoolean("root", false)) {
                node.name = research.getString("name", unlock.name);
                node.requiresUnlock = research.getBoolean("requiresUnlock", false);
                TechTree.roots.add(node);
            } else if (researchName != null) {
                TechTree.TechNode parent = TechTree.all.find(t -> t.content.name.equals(researchName) || t.content.name.equals(this.currentMod.name + "-" + researchName) || t.content.name.equals(SaveVersion.mapFallback(researchName)));
                if (parent == null) {
                    this.warn("Content '" + researchName + "' isn't in the tech tree, but '" + unlock.name + "' requires it to be researched.", new Object[0]);
                } else {
                    if (!parent.children.contains(node)) {
                        parent.children.add(node);
                    }
                    node.parent = parent;
                    node.planet = parent.planet;
                }
            } else {
                this.warn(unlock.name + " is not a root node, and does not have a `parent: ` property. Ignoring.", new Object[0]);
            }
        });
    }

    <T> Class<T> resolve(String base) {
        return this.resolve(base, null);
    }

    <T> Class<T> resolve(String base, Class<T> def) {
        return this.resolve(base, def, true);
    }

    <T> Class<T> resolve(String base, Class<T> def, boolean warn) {
        if ((base == null || base.isEmpty()) && def != null) {
            return def;
        }
        Class<?> out = ClassMap.classes.get(!base.isEmpty() && Character.isLowerCase(base.charAt(0)) ? Strings.capitalize(base) : base);
        if (out != null) {
            return out;
        }
        if (base.indexOf(46) != -1 && this.allowClassResolution) {
            try {
                return Class.forName(base);
            }
            catch (Exception ignored) {
                try {
                    return Class.forName(base, true, Vars.mods.mainLoader());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (def != null) {
            if (warn) {
                this.warn("[@] No type '" + base + "' found, defaulting to type '" + def.getSimpleName() + "'", this.currentContent == null && this.currentMod != null ? this.currentMod.name : "");
            }
            return def;
        }
        throw new IllegalArgumentException("Type not found: " + base);
    }

    void warn(String string, Object ... format) {
        Log.warn(string, format);
    }

    public Json getJson() {
        this.checkInit();
        return this.parser;
    }

    private static interface TypeParser<T extends Content> {
        public T parse(String var1, String var2, JsonValue var3) throws Exception;
    }

    private static interface FieldParser {
        public Object parse(Class<?> var1, JsonValue var2) throws Exception;
    }

    static class UnitReq {
        public Block block;
        public ItemStack[] requirements = new ItemStack[0];
        @Nullable
        public UnitType previous;
        public float time = 600.0f;

        UnitReq() {
        }
    }

    public static interface ParseListener {
        public void parsed(Class<?> var1, JsonValue var2, Object var3);
    }
}

