/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.math.Mathf;
import arc.struct.IntSeq;
import mindustry.Vars;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class MedianFilter
extends GenerateFilter {
    private static final IntSeq blocks = new IntSeq();
    private static final IntSeq floors = new IntSeq();
    public float radius = 2.0f;
    public float percentile = 0.5f;

    @Override
    public FilterOption[] options() {
        return new FilterOption.SliderOption[]{new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = f;
        }, 1.0f, 10.0f), new FilterOption.SliderOption("percentile", () -> this.percentile, f -> {
            this.percentile = f;
        }, 0.0f, 1.0f)};
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public char icon() {
        return '\uf8df';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        int rad = (int)this.radius;
        blocks.clear();
        floors.clear();
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                if (Mathf.dst2(x, y) > (float)(rad * rad)) continue;
                Tile tile = in.tile(in.x + x, in.y + y);
                blocks.add(tile.block().id);
                floors.add(tile.floor().id);
            }
        }
        floors.sort();
        blocks.sort();
        int floor = floors.get(Math.min((int)((float)MedianFilter.floors.size * this.percentile), MedianFilter.floors.size - 1));
        int block = blocks.get(Math.min((int)((float)MedianFilter.blocks.size * this.percentile), MedianFilter.blocks.size - 1));
        in.floor = Vars.content.block(floor);
        if (!Vars.content.block(block).synthetic() && !in.block.synthetic()) {
            in.block = Vars.content.block(block);
        }
    }
}

