/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.Core;
import arc.math.Mathf;
import arc.scene.ui.Image;
import arc.util.Pack;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.gen.PackTile;
import mindustry.maps.filters.FilterOption;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;

public abstract class GenerateFilter
implements Cloneable {
    public int seed = 0;

    public void apply(Tiles tiles, GenerateInput in) {
        if (this.isBuffered()) {
            int i;
            long[] buffer = new long[tiles.width * tiles.height];
            for (i = 0; i < tiles.width * tiles.height; ++i) {
                in.set(tiles.geti(i));
                this.apply(in);
                buffer[i] = PackTile.get(in.block.id, in.floor.id, in.overlay.id);
            }
            for (i = 0; i < tiles.width * tiles.height; ++i) {
                Tile tile = tiles.geti(i);
                long b = buffer[i];
                Block block = Vars.content.block(PackTile.block(b));
                Block floorb = Vars.content.block(PackTile.floor(b));
                Block overlay = Vars.content.block(PackTile.overlay(b));
                if (floorb instanceof Floor) {
                    Floor floor = (Floor)floorb;
                    tile.setFloor(floor);
                    tile.setOverlay(!floor.hasSurface() && overlay.asFloor().needsSurface && overlay instanceof OreBlock ? Blocks.air : overlay);
                }
                if (tile.block().synthetic() || block.synthetic()) continue;
                tile.setBlock(block);
            }
        } else {
            for (Tile tile : tiles) {
                in.set(tile);
                this.apply(in);
                Block block = in.floor;
                if (block instanceof Floor) {
                    Floor floor = (Floor)block;
                    tile.setFloor(floor);
                    tile.setOverlay(!floor.hasSurface() && in.overlay.asFloor().needsSurface && in.overlay instanceof OreBlock ? Blocks.air : in.overlay);
                }
                if (!tile.block().synthetic() && !in.block.synthetic()) {
                    tile.setBlock(in.block);
                }
                tile.setPackedData(in.packedData);
            }
        }
    }

    public abstract FilterOption[] options();

    public void apply(GenerateInput in) {
    }

    public void draw(Image image) {
    }

    public String simpleName() {
        Class<?> c = this.getClass();
        if (c.isAnonymousClass()) {
            c = c.getSuperclass();
        }
        return c.getSimpleName().toLowerCase().replace("filter", "");
    }

    public String name() {
        return Core.bundle.get("filter." + this.simpleName());
    }

    public char icon() {
        return '\u0000';
    }

    public void randomize() {
        this.seed = Mathf.random(999999999);
    }

    public boolean isBuffered() {
        return false;
    }

    public boolean isPost() {
        return false;
    }

    protected float noise(int seedOffset, GenerateInput in, float scl, float mag) {
        return Simplex.noise2d(seedOffset + this.seed, 1.0, 0.0, 1.0f / scl, in.x + 10, in.y + 10) * mag;
    }

    protected float noise(GenerateInput in, float scl, float mag) {
        return Simplex.noise2d(this.seed, 1.0, 0.0, 1.0f / scl, in.x + 10, in.y + 10) * mag;
    }

    protected float noise(GenerateInput in, float scl, float mag, float octaves, float persistence) {
        return Simplex.noise2d(this.seed, octaves, persistence, 1.0f / scl, in.x + 10, in.y + 10) * mag;
    }

    protected float noise(float x, float y, float scl, float mag, float octaves, float persistence) {
        return Simplex.noise2d(this.seed, octaves, persistence, 1.0f / scl, x + 10.0f, y + 10.0f) * mag;
    }

    protected float rnoise(float x, float y, float scl, float mag) {
        return Ridged.noise2d(this.seed + 1, (int)x, (int)y, 1.0f / scl) * mag;
    }

    protected float rnoise(float x, float y, int octaves, float scl, float falloff, float mag) {
        return Ridged.noise2d(this.seed + 1, (int)x, (int)y, octaves, falloff, 1.0f / scl) * mag;
    }

    protected float chance(int x, int y) {
        return Mathf.randomSeed(Pack.longInt(x, y + this.seed));
    }

    public GenerateFilter copy() {
        try {
            return (GenerateFilter)this.clone();
        }
        catch (CloneNotSupportedException disgrace) {
            throw new RuntimeException("java is the best language", disgrace);
        }
    }

    public static class GenerateInput {
        public int x;
        public int y;
        public int width;
        public int height;
        public Block floor;
        public Block block;
        public Block overlay;
        public long packedData;
        TileProvider buffer;

        public void set(int x, int y, Block block, Block floor, Block overlay, long packedData) {
            this.floor = floor;
            this.block = block;
            this.overlay = overlay;
            this.x = x;
            this.y = y;
            this.packedData = packedData;
        }

        public void set(Tile tile) {
            this.set(tile.x, tile.y, tile.block(), tile.floor(), tile.overlay(), tile.getPackedData());
        }

        public void begin(int width, int height, TileProvider buffer) {
            this.buffer = buffer;
            this.width = width;
            this.height = height;
        }

        Tile tile(float x, float y) {
            return this.buffer.get(Mathf.clamp((int)x, 0, this.width - 1), Mathf.clamp((int)y, 0, this.height - 1));
        }

        public static interface TileProvider {
            public Tile get(int var1, int var2);
        }
    }

    class PackTileStruct {
        short block;
        short floor;
        short overlay;

        PackTileStruct() {
        }
    }
}

