/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.assets.loaders.TextureLoader;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.Rand;
import arc.util.Time;
import mindustry.Vars;
import mindustry.graphics.Shaders;
import mindustry.type.Weather;

public class EnvRenderers {
    public static void init() {
        Color waterColor = Color.valueOf("353982");
        Rand rand = new Rand();
        Core.assets.load((String)"sprites/rays.png", Texture.class).loaded = t -> t.setFilter(Texture.TextureFilter.linear);
        Color particleColor = Color.valueOf("a7c1fa");
        float windSpeed = 0.03f;
        float windAngle = 45.0f;
        float windx = Mathf.cosDeg(windAngle) * windSpeed;
        float windy = Mathf.sinDeg(windAngle) * windSpeed;
        Vars.renderer.addEnvRenderer(4, () -> {
            Draw.draw(141.0f, () -> {
                Draw.color(waterColor, 0.4f);
                Fill.rect(Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
                Draw.reset();
                Blending.additive.apply();
                Draw.blit(Shaders.caustics);
                Blending.normal.apply();
            });
            Draw.z(142.0f);
            int rays = 50;
            float timeScale = 2000.0f;
            rand.setSeed(0L);
            Draw.blend(Blending.additive);
            float t = Time.time / timeScale;
            Texture tex = Core.assets.get("sprites/rays.png", Texture.class);
            for (int i = 0; i < rays; ++i) {
                float offset = rand.random(0.0f, 1.0f);
                float time = t + offset;
                int pos = (int)time;
                float life = time % 1.0f;
                float opacity = rand.random(0.2f, 0.7f) * Mathf.slope(life) * 0.7f;
                float x = (rand.random(0.0f, (float)Vars.world.unitWidth()) + (float)(pos % 100 * 753)) % (float)Vars.world.unitWidth();
                float y = (rand.random(0.0f, (float)Vars.world.unitHeight()) + (float)(pos % 120 * 453)) % (float)Vars.world.unitHeight();
                float rot = rand.range(7.0f);
                float sizeScale = 1.0f + rand.range(0.3f);
                float topDst = Core.camera.position.y + Core.camera.height / 2.0f - (y + (float)tex.height / 2.0f + (float)tex.height * 1.9f * sizeScale / 2.0f);
                float invDst = topDst / 1000.0f;
                if (!((double)(opacity = Math.min(opacity, -invDst)) > 0.01)) continue;
                Draw.alpha(opacity);
                Draw.rect(Draw.wrap(tex), x, y + (float)tex.height / 2.0f, (float)(tex.width * 2) * sizeScale, (float)(tex.height * 2) * sizeScale, rot);
                Draw.color();
            }
            Draw.draw(130.0f, () -> Weather.drawParticles(Core.atlas.find("particle"), particleColor, 1.4f, 4.0f, 10000.0f, 1.0f, 1.0f, windx, windy, 0.5f, 1.0f, 30.0f, 80.0f, 1.0f, 7.0f, false));
            Draw.blend();
        });
        Core.assets.load("sprites/distortAlpha.png", Texture.class, new TextureLoader.TextureParameter(){
            {
                this.magFilter = Texture.TextureFilter.linear;
                this.minFilter = Texture.TextureFilter.mipMapLinearLinear;
                this.wrapU = this.wrapV = Texture.TextureWrap.repeat;
                this.genMipMaps = true;
            }
        });
        Vars.renderer.addEnvRenderer(16, () -> {
            Texture tex = Core.assets.get("sprites/distortAlpha.png", Texture.class);
            Draw.z(Vars.state.rules.fog ? 156.0f : 129.0f);
            Weather.drawNoiseLayers(tex, Color.scarlet, 1000.0f, 0.24f, 0.4f, 1.0f, 1.0f, 0.0f, 4, -1.3f, 0.7f, 0.8f, 0.9f);
            Draw.reset();
        });
    }
}

