/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Player;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.ui.Menus;

public class TextInputResultCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public int textInputId;
    public String text;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        WRITE.i(this.textInputId);
        TypeIO.writeString(WRITE, this.text);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.textInputId = READ.i();
        this.text = TypeIO.readString(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        Menus.textInputResult(player, this.textInputId, this.text);
    }

    @Override
    public void handleClient() {
        Menus.textInputResult(this.player, this.textInputId, this.text);
    }
}

