/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class SetUnitCommandCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public int[] unitIds;
    public UnitCommand command;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeInts(WRITE, this.unitIds);
        TypeIO.writeCommand(WRITE, this.command);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.unitIds = TypeIO.readInts(READ);
        this.command = TypeIO.readCommand(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.setUnitCommand(player, this.unitIds, this.command);
        Call.setUnitCommand__forward(con, player, this.unitIds, this.command);
    }

    @Override
    public void handleClient() {
        InputHandler.setUnitCommand(this.player, this.unitIds, this.command);
    }
}

