/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.pattern;

import arc.util.Nullable;
import mindustry.entities.Mover;

public class ShootPattern
implements Cloneable {
    public int shots = 1;
    public float firstShotDelay = 0.0f;
    public float shotDelay = 0.0f;

    public void shoot(int totalShots, BulletHandler handler, @Nullable Runnable barrelIncrementer) {
        this.shoot(totalShots, handler);
    }

    public void shoot(int totalShots, BulletHandler handler) {
        for (int i = 0; i < this.shots; ++i) {
            handler.shoot(0.0f, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i);
        }
    }

    public void flip() {
    }

    public ShootPattern copy() {
        try {
            return (ShootPattern)this.clone();
        }
        catch (CloneNotSupportedException absurd) {
            throw new RuntimeException("impending doom", absurd);
        }
    }

    public static interface BulletHandler {
        default public void shoot(float x, float y, float rotation, float delay) {
            this.shoot(x, y, rotation, delay, null);
        }

        public void shoot(float var1, float var2, float var3, float var4, Mover var5);
    }
}

