/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.part;

import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;

public abstract class DrawPart {
    public static final PartParams params = new PartParams();
    public boolean turretShading;
    public boolean under = false;
    public int weaponIndex = 0;
    public int recoilIndex = -1;

    public abstract void draw(PartParams var1);

    public void load(String name) {
    }

    public void getOutlines(Seq<TextureRegion> out) {
    }

    public static class PartParams {
        public float warmup;
        public float reload;
        public float smoothReload;
        public float heat;
        public float recoil;
        public float life;
        public float charge;
        public float x;
        public float y;
        public float rotation;
        public int sideOverride = -1;
        public int sideMultiplier = 1;

        public PartParams set(float warmup, float reload, float smoothReload, float heat, float recoil, float charge, float x, float y, float rotation) {
            this.warmup = warmup;
            this.reload = reload;
            this.heat = heat;
            this.recoil = recoil;
            this.smoothReload = smoothReload;
            this.charge = charge;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.sideOverride = -1;
            this.life = 0.0f;
            this.sideMultiplier = 1;
            return this;
        }

        public PartParams setRecoil(float recoils) {
            this.recoil = recoils;
            return this;
        }
    }

    public static interface PartFunc {
        public float get(float var1, float var2);
    }

    public static interface PartProgress {
        public static final PartProgress reload = p -> p.reload;
        public static final PartProgress smoothReload = p -> p.smoothReload;
        public static final PartProgress warmup = p -> p.warmup;
        public static final PartProgress charge = p -> p.charge;
        public static final PartProgress recoil = p -> p.recoil;
        public static final PartProgress heat = p -> p.heat;
        public static final PartProgress life = p -> p.life;
        public static final PartProgress time = p -> Time.time;

        public float get(PartParams var1);

        public static PartProgress constant(float value) {
            return p -> value;
        }

        default public float getClamp(PartParams p) {
            return this.getClamp(p, true);
        }

        default public float getClamp(PartParams p, boolean clamp) {
            return clamp ? Mathf.clamp(this.get(p)) : this.get(p);
        }

        default public PartProgress inv() {
            return p -> 1.0f - this.get(p);
        }

        default public PartProgress slope() {
            return p -> Mathf.slope(this.get(p));
        }

        default public PartProgress clamp() {
            return p -> Mathf.clamp(this.get(p));
        }

        default public PartProgress add(float amount) {
            return p -> this.get(p) + amount;
        }

        default public PartProgress add(PartProgress other) {
            return p -> this.get(p) + other.get(p);
        }

        default public PartProgress delay(float amount) {
            return p -> (this.get(p) - amount) / (1.0f - amount);
        }

        default public PartProgress curve(float offset, float duration) {
            return p -> (this.get(p) - offset) / duration;
        }

        default public PartProgress sustain(float offset, float grow, float sustain) {
            return p -> {
                float val = this.get(p) - offset;
                return Math.min(Math.max(val, 0.0f) / grow, (grow + sustain + grow - val) / grow);
            };
        }

        default public PartProgress shorten(float amount) {
            return p -> this.get(p) / (1.0f - amount);
        }

        default public PartProgress compress(float start, float end) {
            return p -> Mathf.curve(this.get(p), start, end);
        }

        default public PartProgress blend(PartProgress other, float amount) {
            return p -> Mathf.lerp(this.get(p), other.get(p), amount);
        }

        default public PartProgress mul(PartProgress other) {
            return p -> this.get(p) * other.get(p);
        }

        default public PartProgress mul(float amount) {
            return p -> this.get(p) * amount;
        }

        default public PartProgress min(PartProgress other) {
            return p -> Math.min(this.get(p), other.get(p));
        }

        default public PartProgress sin(float offset, float scl, float mag) {
            return p -> this.get(p) + Mathf.sin(Time.time + offset, scl, mag);
        }

        default public PartProgress sin(float scl, float mag) {
            return p -> this.get(p) + Mathf.sin(scl, mag);
        }

        default public PartProgress absin(float scl, float mag) {
            return p -> this.get(p) + Mathf.absin(scl, mag);
        }

        default public PartProgress mod(float amount) {
            return p -> Mathf.mod(this.get(p), amount);
        }

        default public PartProgress loop(float time) {
            return p -> Mathf.mod(this.get(p) / time, 1.0f);
        }

        default public PartProgress apply(PartProgress other, PartFunc func) {
            return p -> func.get(this.get(p), other.get(p));
        }

        default public PartProgress curve(Interp interp) {
            return p -> interp.apply(this.get(p));
        }
    }

    public static class PartMove {
        public PartProgress progress = PartProgress.warmup;
        public float x;
        public float y;
        public float gx;
        public float gy;
        public float rot;

        public PartMove(PartProgress progress, float x, float y, float gx, float gy, float rot) {
            this.progress = progress;
            this.x = x;
            this.y = y;
            this.gx = gx;
            this.gy = gy;
            this.rot = rot;
        }

        public PartMove(PartProgress progress, float x, float y, float rot) {
            this(progress, x, y, 0.0f, 0.0f, rot);
        }

        public PartMove() {
        }
    }
}

