/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import mindustry.entities.Effect;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class ExplosionEffect
extends Effect {
    public Color waveColor = Pal.missileYellow;
    public Color smokeColor = Color.gray;
    public Color sparkColor = Pal.missileYellowBack;
    public float waveLife = 6.0f;
    public float waveStroke = 3.0f;
    public float waveRad = 15.0f;
    public float waveRadBase = 2.0f;
    public float sparkStroke = 1.0f;
    public float sparkRad = 23.0f;
    public float sparkLen = 3.0f;
    public float smokeSize = 4.0f;
    public float smokeSizeBase = 0.5f;
    public float smokeRad = 23.0f;
    public int smokes = 5;
    public int sparks = 4;

    public ExplosionEffect() {
        this.clip = 100.0f;
        this.lifetime = 22.0f;
        this.renderer = e -> {
            Draw.color(this.waveColor);
            e.scaled(this.waveLife, i -> {
                Lines.stroke(this.waveStroke * i.fout());
                Lines.circle(e.x, e.y, this.waveRadBase + i.fin() * this.waveRad);
            });
            Draw.color(this.smokeColor);
            if (this.smokeSize > 0.0f) {
                Angles.randLenVectors(e.id, this.smokes, 2.0f + this.smokeRad * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * this.smokeSize + this.smokeSizeBase));
            }
            Draw.color(this.sparkColor);
            Lines.stroke(e.fout() * this.sparkStroke);
            Angles.randLenVectors(e.id + 1, this.sparks, 1.0f + this.sparkRad * e.finpow(), (x, y) -> {
                Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * this.sparkLen);
                Drawf.light(e.x + x, e.y + y, e.fout() * this.sparkLen * 4.0f, this.sparkColor, 0.7f);
            });
        };
    }
}

