/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;
import mindustry.type.Item;
import mindustry.world.blocks.distribution.MassDriver;

public class MassDriverBolt
extends BasicBulletType {
    public MassDriverBolt() {
        super(1.0f, 75.0f);
        this.collidesTiles = false;
        this.lifetime = 1.0f;
        this.width = 11.0f;
        this.height = 13.0f;
        this.shrinkY = 0.0f;
        this.sprite = "shell";
        this.despawnEffect = Fx.smeltsmoke;
        this.hitEffect = Fx.hitBulletBig;
    }

    @Override
    public void update(Bullet b) {
        float baseAngle;
        float angleTo;
        super.update(b);
        Object object = b.data();
        if (!(object instanceof MassDriver.DriverBulletData)) {
            this.hit(b);
            return;
        }
        MassDriver.DriverBulletData data = (MassDriver.DriverBulletData)object;
        float hitDst = 7.0f;
        if (data.to.dead()) {
            return;
        }
        float baseDst = data.from.dst(data.to);
        float dst1 = b.dst(data.from);
        float dst2 = b.dst(data.to);
        boolean intersect = false;
        if (dst1 > baseDst && Angles.near(angleTo = b.angleTo(data.to), baseAngle = data.to.angleTo(data.from), 2.0f)) {
            intersect = true;
            b.set(data.to.x + Angles.trnsx(baseAngle, hitDst), data.to.y + Angles.trnsy(baseAngle, hitDst));
        }
        if (Math.abs(dst1 + dst2 - baseDst) < 4.0f && dst2 <= hitDst) {
            intersect = true;
        }
        if (intersect) {
            data.to.handlePayload(b, data);
        }
    }

    @Override
    public void despawned(Bullet b) {
        super.despawned(b);
        Object object = b.data();
        if (!(object instanceof MassDriver.DriverBulletData)) {
            return;
        }
        MassDriver.DriverBulletData data = (MassDriver.DriverBulletData)object;
        for (int i = 0; i < data.items.length; ++i) {
            int amountDropped = Mathf.random(0, data.items[i]);
            if (amountDropped <= 0) continue;
            float angle = b.rotation() + Mathf.range(100.0f);
            Fx.dropItem.at(b.x, b.y, angle, Color.white, Vars.content.item(i));
        }
    }

    @Override
    public void hit(Bullet b, float hitx, float hity) {
        super.hit(b, hitx, hity);
        this.despawned(b);
        Object object = b.data();
        if (object instanceof MassDriver.DriverBulletData) {
            MassDriver.DriverBulletData data = (MassDriver.DriverBulletData)object;
            float explosiveness = 0.0f;
            float flammability = 0.0f;
            float power = 0.0f;
            for (int i = 0; i < data.items.length; ++i) {
                Item item = Vars.content.item(i);
                explosiveness += item.explosiveness * (float)data.items[i];
                flammability += item.flammability * (float)data.items[i];
                power += item.charge * Mathf.pow((float)data.items[i], 1.1f) * 25.0f;
            }
            Damage.dynamicExplosion(b.x, b.y, flammability / 10.0f, explosiveness / 10.0f, power, 1.0f, Vars.state.rules.damageExplosions);
        }
    }
}

