/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;

public class FlakBulletType
extends BasicBulletType {
    public float explodeRange = 30.0f;
    public float explodeDelay = 5.0f;
    public float flakDelay = 0.0f;
    public float flakInterval = 6.0f;

    public FlakBulletType(float speed, float damage) {
        super(speed, damage, "shell");
        this.splashDamage = 15.0f;
        this.splashDamageRadius = 34.0f;
        this.hitEffect = Fx.flakExplosionBig;
        this.width = 8.0f;
        this.height = 10.0f;
        this.collidesGround = false;
    }

    public FlakBulletType() {
        this(1.0f, 1.0f);
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (b.time >= this.flakDelay && b.fdata >= 0.0f && b.timer(2, this.flakInterval)) {
            Units.nearbyEnemies(b.team, Tmp.r1.setSize(this.explodeRange * 2.0f).setCenter(b.x, b.y), unit -> {
                if (b.fdata < 0.0f || !unit.checkTarget(this.collidesAir, this.collidesGround) || !unit.targetable(b.team)) {
                    return;
                }
                if (unit.within(b, this.explodeRange + unit.hitSize / 2.0f)) {
                    b.fdata = -1.0f;
                    Time.run(this.explodeDelay, () -> {
                        if (b.fdata < 0.0f) {
                            b.time = b.lifetime;
                        }
                    });
                }
            });
        }
    }
}

