/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Cons;
import arc.scene.style.Drawable;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.serialization.JsonValue;
import arc.util.serialization.Jval;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.mod.ContentPatcher;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class MapPatchesDialog
extends BaseDialog {
    private Table list;

    public MapPatchesDialog() {
        super("@editor.patches");
        this.shown(this::setup);
        this.addCloseButton();
        this.buttons.button("@editor.patches.guide", Icon.link, () -> Core.app.openURI("https://mindustrygame.github.io/wiki/contentpatches/")).size(200.0f, 64.0f);
        this.buttons.button("@add", Icon.add, () -> this.showImport(this::addPatch)).size(200.0f, 64.0f);
        this.cont.top();
        this.getCell(this.cont).grow();
        this.cont.pane((Table t) -> {
            this.list = t;
        });
    }

    private void setup() {
        this.list.clearChildren();
        Seq<ContentPatcher.PatchSet> patches = Vars.state.patcher.patches;
        if (patches.isEmpty()) {
            this.list.add("@editor.patches.none");
        } else {
            Table t = this.list;
            t.defaults().pad(4.0f);
            float h = 50.0f;
            for (ContentPatcher.PatchSet patch : patches) {
                int fields = this.countFields(patch.json);
                if (patch.warnings.size > 0) {
                    t.button(Icon.warning, Styles.graySquarei, 32.0f, () -> {
                        BaseDialog dialog = new BaseDialog("@editor.patches.errors");
                        dialog.cont.top().pane((Table p) -> {
                            p.top();
                            for (String warning : patch.warnings) {
                                p.table(Styles.grayPanel, in -> in.add((CharSequence)warning.replaceAll("\t", "  "), Styles.monoLabel).grow().wrap()).margin(6.0f).growX().pad(3.0f).row();
                            }
                        }).grow();
                        dialog.addCloseButton();
                        dialog.show();
                    }).size(h);
                } else {
                    t.add().size(h);
                }
                t.button((patch.name.isEmpty() ? "<unnamed>\n" : "[accent]" + patch.name + "\n") + "[lightgray][[" + Core.bundle.format("editor.patch.fields", fields) + "]", Styles.grayt, () -> {
                    BaseDialog dialog = new BaseDialog(Core.bundle.format("editor.patch", patch.name.isEmpty() ? "<unnamed>" : patch.name));
                    dialog.cont.top().pane((Table p) -> {
                        p.top();
                        p.table(Styles.grayPanel, in -> in.add((CharSequence)patch.patch.replaceAll("\t", "  "), Styles.monoLabel).grow().wrap().left().labelAlign(8)).margin(6.0f).growX().pad(5.0f).row();
                    }).grow();
                    dialog.addCloseButton();
                    dialog.show();
                }).size(Vars.mobile ? 390.0f : 450.0f, h).margin(10.0f).with(b -> b.getLabel().setAlignment(8, 8));
                t.button(Icon.copy, Styles.graySquarei, 32.0f, () -> {
                    Core.app.setClipboardText(patch.patch);
                    Vars.ui.showInfoFade("@copied");
                }).size(h);
                t.button(Icon.refresh, Styles.graySquarei, 32.0f, () -> this.showImport(str -> this.addPatch((String)str, patches.indexOf(patch)))).size(h);
                t.button(Icon.trash, Styles.graySquarei, 32.0f, () -> Vars.ui.showConfirm("@editor.patches.delete.confirm", () -> {
                    patches.remove(patch);
                    this.setup();
                })).size(h);
                t.row();
            }
        }
    }

    void showImport(Cons<String> handler) {
        BaseDialog dialog = new BaseDialog("@editor.import");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.flatt;
                t.defaults().size(280.0f, 60.0f).left();
                t.row();
                t.button("@schematic.copy.import", (Drawable)Icon.copy, style, () -> {
                    dialog.hide();
                    handler.get(Core.app.getClipboardText());
                }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null);
                t.row();
                t.button("@schematic.importfile", (Drawable)Icon.download, style, () -> Vars.platform.showMultiFileChooser(file -> {
                    dialog.hide();
                    handler.get(file.readString());
                }, "json", "hjson", "json5")).marginLeft(12.0f);
                t.row();
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    void addPatch(String patch) {
        this.addPatch(patch, -1);
    }

    void addPatch(String patch, int replaceIndex) {
        Seq<ContentPatcher.PatchSet> oldPatches = Vars.state.patcher.patches.copy();
        try {
            Jval.read(patch);
            Seq<String> patches = Vars.state.patcher.patches.map(p -> p.patch);
            if (replaceIndex == -1) {
                patches.add(patch);
            } else {
                patches.set(replaceIndex, patch);
            }
            Vars.state.patcher.apply(patches);
            this.setup();
        }
        catch (Exception e) {
            Vars.state.patcher.patches.set(oldPatches);
            Vars.ui.showException("@editor.patches.importerror", e);
        }
    }

    int countFields(JsonValue value) {
        if (value.isObject() || value.isArray()) {
            int sum = 0;
            for (JsonValue child : value) {
                sum += this.countFields(child);
            }
            return Math.max(sum, 1);
        }
        return 1;
    }
}

