/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;

public class BannedContentDialog<T extends UnlockableContent>
extends BaseDialog {
    private final ContentType type;
    private Table selectedTable;
    private Table deselectedTable;
    private ObjectSet<T> contentSet;
    private final Boolf<T> pred;
    private String contentSearch;
    private Category selectedCategory;
    private Seq<T> filteredContent;

    public BannedContentDialog(String title, ContentType type, Boolf<T> pred) {
        super(title);
        this.type = type;
        this.pred = pred;
        this.contentSearch = "";
        this.selectedTable = new Table();
        this.deselectedTable = new Table();
        this.addCloseButton();
        this.shown(this::build);
        this.resized(this::build);
    }

    public void show(ObjectSet<T> contentSet) {
        this.contentSet = contentSet;
        this.show();
    }

    public void build() {
        this.cont.clear();
        Cell<Table> cell = this.cont.table((Table t) -> {
            t.table((Table s) -> {
                s.label(() -> "@search").padRight(10.0f);
                TextField field = s.field(this.contentSearch, value -> {
                    this.contentSearch = value.trim().replaceAll(" +", " ").toLowerCase();
                    this.rebuildTables();
                }).get();
                s.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                    this.contentSearch = "";
                    field.setText("");
                    this.rebuildTables();
                }).padLeft(10.0f).size(35.0f);
            });
            if (this.type == ContentType.block) {
                t.row();
                t.table((Table c) -> {
                    c.marginTop(8.0f);
                    c.defaults().marginRight(4.0f);
                    for (Category category : Category.values()) {
                        c.button((Drawable)Vars.ui.getIcon(category.name()), Styles.squareTogglei, () -> {
                            this.selectedCategory = this.selectedCategory == category ? null : category;
                            this.rebuildTables();
                        }).size(45.0f).update((T i) -> i.setChecked(this.selectedCategory == category)).padLeft(4.0f);
                    }
                    c.add("").padRight(4.0f);
                }).center();
            }
        });
        this.cont.row();
        if (!Core.graphics.isPortrait()) {
            cell.colspan(2);
        }
        this.filteredContent = Vars.content.getBy(this.type).select(this.pred);
        if (!this.contentSearch.isEmpty()) {
            this.filteredContent.removeAll(content -> !content.localizedName.toLowerCase().contains(this.contentSearch.toLowerCase()));
        }
        this.cont.table((Table table) -> {
            if (this.type == ContentType.block) {
                table.add("@bannedblocks").color(Color.valueOf("f25555")).padBottom(-1.0f).top().row();
            } else {
                table.add("@bannedunits").color(Color.valueOf("f25555")).padBottom(-1.0f).top().row();
            }
            table.image().color(Color.valueOf("f25555")).height(3.0f).padBottom(5.0f).fillX().expandX().top().row();
            table.pane((Table table2) -> {
                this.selectedTable = table2;
            }).fill().expand().row();
            table.button("@addall", Icon.add, () -> {
                this.contentSet.addAll(this.filteredContent);
                this.rebuildTables();
            }).disabled(button -> this.contentSet.toSeq().containsAll(this.filteredContent)).padTop(10.0f).bottom().fillX();
        }).fill().expandY().uniform();
        if (Core.graphics.isPortrait()) {
            this.cont.row();
        }
        Cell<Table> cell2 = this.cont.table((Table table) -> {
            if (this.type == ContentType.block) {
                table.add("@unbannedblocks").color(Pal.accent).padBottom(-1.0f).top().row();
            } else {
                table.add("@unbannedunits").color(Pal.accent).padBottom(-1.0f).top().row();
            }
            table.image().color(Pal.accent).height(3.0f).padBottom(5.0f).fillX().top().row();
            table.pane((Table table2) -> {
                this.deselectedTable = table2;
            }).fill().expand().row();
            table.button("@addall", Icon.add, () -> {
                this.contentSet.removeAll(this.filteredContent);
                this.rebuildTables();
            }).disabled(button -> {
                Seq<T> array = Vars.content.getBy(this.type);
                array = array.copy();
                array.removeAll(this.contentSet.toSeq());
                return array.containsAll(this.filteredContent);
            }).padTop(10.0f).bottom().fillX();
        }).fill().expandY().uniform();
        if (Core.graphics.isPortrait()) {
            cell2.padTop(10.0f);
        } else {
            cell2.padLeft(10.0f);
        }
        this.rebuildTables();
    }

    private void rebuildTables() {
        this.filteredContent.clear();
        this.filteredContent = Vars.content.getBy(this.type);
        this.filteredContent = this.filteredContent.select(this.pred);
        if (!this.contentSearch.isEmpty()) {
            this.filteredContent.removeAll(content -> !content.localizedName.toLowerCase().contains(this.contentSearch.toLowerCase()));
        }
        if (this.type == ContentType.block) {
            this.filteredContent.removeAll(content -> this.selectedCategory != null && ((Block)content).category != this.selectedCategory);
        }
        this.rebuildTable(this.selectedTable, true);
        this.rebuildTable(this.deselectedTable, false);
    }

    private void rebuildTable(Table table, boolean isSelected) {
        table.clear();
        int cols = Core.graphics.isPortrait() ? Math.max(4, (int)(((float)Core.graphics.getWidth() / Scl.scl() - 100.0f) / 50.0f)) : Math.max(4, (int)(((float)Core.graphics.getWidth() / Scl.scl() - 300.0f) / 50.0f / 2.0f));
        if (isSelected && this.contentSet.isEmpty() || !isSelected && this.contentSet.size == Vars.content.getBy(this.type).count(this.pred)) {
            table.add("@empty").width(50.0f * (float)cols).padBottom(5.0f).get().setAlignment(1);
        } else {
            Seq<T> array;
            if (!isSelected) {
                array = Vars.content.getBy(this.type);
                array = array.copy();
                array.removeAll(this.contentSet.toSeq());
            } else {
                array = this.contentSet.toSeq();
            }
            array.sort();
            array.removeAll(content -> !this.filteredContent.contains((UnlockableContent)content));
            if (array.isEmpty()) {
                table.add("@empty").width(50.0f * (float)cols).padBottom(5.0f).get().setAlignment(1);
                return;
            }
            int i = 0;
            boolean requiresPad = true;
            for (UnlockableContent content2 : array) {
                TextureRegion region = content2.uiIcon;
                ImageButton button = new ImageButton(Tex.whiteui, Styles.clearNonei);
                button.getStyle().imageUp = new TextureRegionDrawable(region);
                button.resizeImage(32.0f);
                if (isSelected) {
                    button.clicked(() -> {
                        this.contentSet.remove(content2);
                        this.rebuildTables();
                    });
                } else {
                    button.clicked(() -> {
                        this.contentSet.add(content2);
                        this.rebuildTables();
                    });
                }
                table.add(button).size(50.0f).tooltip(content2.localizedName);
                if (++i % cols != 0) continue;
                table.row();
                requiresPad = false;
            }
            if (requiresPad) {
                table.add("").padRight(50.0f * (float)(cols - i));
            }
        }
    }
}

