/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.Input;
import arc.assets.AssetDescriptor;
import arc.assets.Loadable;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Intc;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.PixmapPacker;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.Scene;
import arc.scene.actions.Actions;
import arc.scene.event.ClickListener;
import arc.scene.event.Touchable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.TextField;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.IntMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Control;
import mindustry.core.PerfCounter;
import mindustry.editor.MapEditorDialog;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.LogicDialog;
import mindustry.mod.Mods;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.AboutDialog;
import mindustry.ui.dialogs.AdminsDialog;
import mindustry.ui.dialogs.BansDialog;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.CampaignCompleteDialog;
import mindustry.ui.dialogs.ColorPicker;
import mindustry.ui.dialogs.ContentInfoDialog;
import mindustry.ui.dialogs.CustomGameDialog;
import mindustry.ui.dialogs.DatabaseDialog;
import mindustry.ui.dialogs.DiscordDialog;
import mindustry.ui.dialogs.EditorMapsDialog;
import mindustry.ui.dialogs.EffectsDialog;
import mindustry.ui.dialogs.FullTextDialog;
import mindustry.ui.dialogs.GameOverDialog;
import mindustry.ui.dialogs.HostDialog;
import mindustry.ui.dialogs.JoinDialog;
import mindustry.ui.dialogs.KeybindDialog;
import mindustry.ui.dialogs.LanguageDialog;
import mindustry.ui.dialogs.LoadDialog;
import mindustry.ui.dialogs.ModsDialog;
import mindustry.ui.dialogs.PausedDialog;
import mindustry.ui.dialogs.PlanetDialog;
import mindustry.ui.dialogs.ResearchDialog;
import mindustry.ui.dialogs.SchematicsDialog;
import mindustry.ui.dialogs.SettingsMenuDialog;
import mindustry.ui.dialogs.TraceDialog;
import mindustry.ui.fragments.ChatFragment;
import mindustry.ui.fragments.ConsoleFragment;
import mindustry.ui.fragments.FadeInFragment;
import mindustry.ui.fragments.HintsFragment;
import mindustry.ui.fragments.HudFragment;
import mindustry.ui.fragments.LoadingFragment;
import mindustry.ui.fragments.MenuFragment;
import mindustry.ui.fragments.MinimapFragment;
import mindustry.ui.fragments.PlayerListFragment;

public class UI
implements ApplicationListener,
Loadable {
    private static final StringBuilder buffer = new StringBuilder();
    public static String billions;
    public static String millions;
    public static String thousands;
    public static PixmapPacker packer;
    public MenuFragment menufrag;
    public HudFragment hudfrag;
    public ChatFragment chatfrag;
    public ConsoleFragment consolefrag;
    public MinimapFragment minimapfrag;
    public PlayerListFragment listfrag;
    public LoadingFragment loadfrag;
    public HintsFragment hints;
    public WidgetGroup menuGroup;
    public WidgetGroup hudGroup;
    public AboutDialog about;
    public GameOverDialog restart;
    public CustomGameDialog custom;
    public EditorMapsDialog maps;
    public LoadDialog load;
    public DiscordDialog discord;
    public JoinDialog join;
    public HostDialog host;
    public PausedDialog paused;
    public SettingsMenuDialog settings;
    public KeybindDialog controls;
    public MapEditorDialog editor;
    public LanguageDialog language;
    public BansDialog bans;
    public AdminsDialog admins;
    public TraceDialog traces;
    public DatabaseDialog database;
    public ContentInfoDialog content;
    public PlanetDialog planet;
    public ResearchDialog research;
    public SchematicsDialog schematics;
    public ModsDialog mods;
    public ColorPicker picker;
    public EffectsDialog effects;
    public LogicDialog logic;
    public FullTextDialog fullText;
    public CampaignCompleteDialog campaignComplete;
    public IntMap<Dialog> followUpMenus;
    public Graphics.Cursor drillCursor;
    public Graphics.Cursor unloadCursor;
    public Graphics.Cursor targetCursor;
    public Graphics.Cursor repairCursor;
    @Nullable
    private Element lastAnnouncement;

    public UI() {
        Fonts.loadFonts();
    }

    public static void loadColors() {
        Colors.put("accent", Pal.accent);
        Colors.put("unlaunched", Color.valueOf("8982ed"));
        Colors.put("highlight", Pal.accent.cpy().lerp(Color.white, 0.3f));
        Colors.put("stat", Pal.stat);
        Colors.put("negstat", Pal.negativeStat);
    }

    @Override
    public void loadAsync() {
    }

    @Override
    public void loadSync() {
        Fonts.outline.getData().markupEnabled = true;
        Fonts.def.getData().markupEnabled = true;
        Fonts.def.setOwnsTexture(false);
        Core.assets.getAll(Font.class, new Seq()).each(font -> font.setUseIntegerPositions(true));
        Core.scene = new Scene();
        Core.input.addProcessor(Core.scene);
        int[] insets = Core.graphics.getSafeInsets();
        Core.scene.marginLeft = insets[0];
        Core.scene.marginRight = insets[1];
        Core.scene.marginTop = insets[2];
        Core.scene.marginBottom = insets[3];
        Tex.load();
        Icon.load();
        Styles.load();
        Tex.loadStyles();
        Fonts.loadContentIcons();
        Dialog.setShowAction(() -> Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.1f)));
        Dialog.setHideAction(() -> Actions.sequence((Action)Actions.fadeOut(0.1f)));
        Tooltip.Tooltips.getInstance().animations = false;
        Tooltip.Tooltips.getInstance().textProvider = text -> new Tooltip(t -> t.background(Styles.black6).margin(4.0f).add((CharSequence)text));
        if (Vars.mobile) {
            Tooltip.Tooltips.getInstance().offsetY += Scl.scl(60.0f);
        }
        Core.settings.setErrorHandler(e -> {
            Log.err(e);
            Core.app.post(() -> this.showErrorMessage("Failed to access local storage.\nSettings will not be saved."));
        });
        ClickListener.clicked = () -> Sounds.press.play();
        this.drillCursor = Core.graphics.newCursor("drill", Fonts.cursorScale());
        this.unloadCursor = Core.graphics.newCursor("unload", Fonts.cursorScale());
        this.targetCursor = Core.graphics.newCursor("target", Fonts.cursorScale());
        this.repairCursor = Core.graphics.newCursor("repair", Fonts.cursorScale());
    }

    @Override
    public Seq<AssetDescriptor> getDependencies() {
        return Seq.with(new AssetDescriptor<Control>(Control.class), new AssetDescriptor<Font>("outline", Font.class), new AssetDescriptor<Font>("default", Font.class), new AssetDescriptor<Mods>(Mods.class));
    }

    @Override
    public void update() {
        Element e;
        if (Vars.disableUI || Core.scene == null) {
            return;
        }
        PerfCounter.ui.begin();
        Events.fire(EventType.Trigger.uiDrawBegin);
        Core.scene.act();
        Core.scene.draw();
        if (Core.input.keyTap(KeyCode.mouseLeft) && Core.scene.hasField() && !((e = Core.scene.getHoverElement()) instanceof TextField)) {
            Core.scene.setKeyboardFocus(null);
        }
        Events.fire(EventType.Trigger.uiDrawEnd);
        PerfCounter.ui.end();
    }

    @Override
    public void init() {
        billions = Core.bundle.get("unit.billions");
        millions = Core.bundle.get("unit.millions");
        thousands = Core.bundle.get("unit.thousands");
        this.menuGroup = new WidgetGroup();
        this.hudGroup = new WidgetGroup();
        this.menufrag = new MenuFragment();
        this.hudfrag = new HudFragment();
        this.hints = new HintsFragment();
        this.chatfrag = new ChatFragment();
        this.minimapfrag = new MinimapFragment();
        this.listfrag = new PlayerListFragment();
        this.loadfrag = new LoadingFragment();
        this.consolefrag = new ConsoleFragment();
        this.picker = new ColorPicker();
        this.effects = new EffectsDialog();
        this.editor = new MapEditorDialog();
        this.controls = new KeybindDialog();
        this.restart = new GameOverDialog();
        this.join = new JoinDialog();
        this.discord = new DiscordDialog();
        this.load = new LoadDialog();
        this.custom = new CustomGameDialog();
        this.language = new LanguageDialog();
        this.database = new DatabaseDialog();
        this.settings = new SettingsMenuDialog();
        this.host = new HostDialog();
        this.paused = new PausedDialog();
        this.about = new AboutDialog();
        this.bans = new BansDialog();
        this.admins = new AdminsDialog();
        this.traces = new TraceDialog();
        this.maps = new EditorMapsDialog();
        this.content = new ContentInfoDialog();
        this.planet = new PlanetDialog();
        this.research = new ResearchDialog();
        this.mods = new ModsDialog();
        this.schematics = new SchematicsDialog();
        this.logic = new LogicDialog();
        this.fullText = new FullTextDialog();
        this.campaignComplete = new CampaignCompleteDialog();
        this.followUpMenus = new IntMap();
        Group group = Core.scene.root;
        this.menuGroup.setFillParent(true);
        this.menuGroup.touchable = Touchable.childrenOnly;
        this.menuGroup.visible(() -> Vars.state.isMenu());
        this.hudGroup.setFillParent(true);
        this.hudGroup.touchable = Touchable.childrenOnly;
        this.hudGroup.visible(() -> Vars.state.isGame());
        Core.scene.add(this.menuGroup);
        Core.scene.add(this.hudGroup);
        this.hudfrag.build(this.hudGroup);
        this.menufrag.build(this.menuGroup);
        this.chatfrag.build(this.hudGroup);
        this.minimapfrag.build(this.hudGroup);
        this.listfrag.build(this.hudGroup);
        this.consolefrag.build(this.hudGroup);
        this.loadfrag.build(group);
        new FadeInFragment().build(group);
    }

    @Override
    public void resize(int width, int height) {
        if (Core.scene == null) {
            return;
        }
        int[] insets = Core.graphics.getSafeInsets();
        Core.scene.marginLeft = insets[0];
        Core.scene.marginRight = insets[1];
        Core.scene.marginTop = insets[2];
        Core.scene.marginBottom = insets[3];
        Core.scene.resize(width, height);
        Events.fire(new EventType.ResizeEvent());
    }

    public TextureRegionDrawable getIcon(String name) {
        if (Icon.icons.containsKey(name)) {
            return Icon.icons.get(name);
        }
        return (TextureRegionDrawable)Core.atlas.getDrawable("error");
    }

    public TextureRegionDrawable getIcon(String name, String def) {
        if (Icon.icons.containsKey(name)) {
            return Icon.icons.get(name);
        }
        return this.getIcon(def);
    }

    public void loadAnd(Runnable call) {
        this.loadAnd("@loading", call);
    }

    public void loadAnd(String text, Runnable call) {
        this.loadfrag.show(text);
        Time.runTask(7.0f, () -> {
            call.run();
            this.loadfrag.hide();
        });
    }

    public void showTextInput(String titleText, String text, int textLength, String def, boolean numbers, Cons<String> confirmed, Runnable closed) {
        this.showTextInput(titleText, text, textLength, def, numbers, false, confirmed, closed);
    }

    public void showTextInput(final String titleText, final String text, final int textLength, final String def, final boolean numbers, final boolean allowEmpty, final Cons<String> confirmed, final Runnable closed) {
        if (Vars.mobile) {
            final String description = text.startsWith("@") ? Core.bundle.get(text.substring(1)) : text;
            final boolean empty = allowEmpty;
            Core.input.getTextInput(new Input.TextInput(){
                {
                    this.title = titleText.startsWith("@") ? Core.bundle.get(titleText.substring(1)) : titleText;
                    this.text = def;
                    this.numeric = numbers;
                    this.maxLength = textLength;
                    this.accepted = confirmed;
                    this.canceled = closed;
                    this.allowEmpty = empty;
                    this.message = description;
                }
            });
        } else {
            new Dialog(titleText){
                {
                    super(arg0);
                    this.cont.margin(30.0f).add(text).padRight(6.0f);
                    TextField.TextFieldFilter filter = numbers ? TextField.TextFieldFilter.digitsOnly : (f, c) -> true;
                    TextField field = this.cont.field(def, t -> {}).size(330.0f, 50.0f).get();
                    field.setMaxLength(textLength);
                    field.setFilter(filter);
                    this.buttons.defaults().size(120.0f, 54.0f).pad(4.0f);
                    this.buttons.button("@cancel", () -> {
                        closed.run();
                        this.hide();
                    });
                    this.buttons.button("@ok", () -> {
                        confirmed.get(field.getText());
                        this.hide();
                    }).disabled(b -> !allowEmpty && field.getText().isEmpty());
                    this.keyDown(KeyCode.enter, () -> {
                        String text2 = field.getText();
                        if (allowEmpty || !text2.isEmpty()) {
                            confirmed.get(text2);
                            this.hide();
                        }
                    });
                    this.closeOnBack(closed);
                    this.show();
                    Core.scene.setKeyboardFocus(field);
                    field.setCursorPosition(def.length());
                }
            };
        }
    }

    public void showTextInput(String title, String text, String def, Cons<String> confirmed) {
        this.showTextInput(title, text, 32, def, confirmed);
    }

    public void showTextInput(String title, String text, int textLength, String def, Cons<String> confirmed) {
        this.showTextInput(title, text, textLength, def, false, confirmed);
    }

    public void showTextInput(String title, String text, int textLength, String def, boolean numeric, Cons<String> confirmed) {
        this.showTextInput(title, text, textLength, def, numeric, confirmed, () -> {});
    }

    public void showInfoFade(String info) {
        this.showInfoFade(info, 7.0f);
    }

    public void showInfoFade(String info, float duration) {
        Element cinfo = Core.scene.find("coreinfo");
        Table table = new Table();
        table.touchable = Touchable.disabled;
        table.setFillParent(true);
        if (cinfo.visible && !Vars.state.isMenu()) {
            table.marginTop(cinfo.getPrefHeight() / Scl.scl() / 2.0f);
        }
        table.actions(Actions.fadeOut(duration, Interp.fade), Actions.remove());
        table.top().add(info).style(Styles.outlineLabel).padTop(10.0f);
        Core.scene.add(table);
    }

    public void addDescTooltip(Element elem, String description) {
        if (description == null) {
            return;
        }
        elem.addListener(new Tooltip(t -> t.background(Styles.black8).margin(4.0f).add(description).color(Color.lightGray)){
            {
                this.allowMobile = true;
            }

            @Override
            protected void setContainerPosition(Element element, float x, float y) {
                this.targetActor = element;
                Vec2 pos = element.localToStageCoordinates(Tmp.v1.set(0.0f, 0.0f));
                this.container.pack();
                this.container.setPosition(pos.x, pos.y, 10);
                this.container.setOrigin(0.0f, element.getHeight());
            }
        });
    }

    public void showInfoToast(String info, float duration) {
        Element cinfo = Core.scene.find("coreinfo");
        Table table = new Table();
        table.touchable = Touchable.disabled;
        table.setFillParent(true);
        if (cinfo.visible && !Vars.state.isMenu()) {
            table.marginTop(cinfo.getPrefHeight() / Scl.scl() / 2.0f);
        }
        table.update(() -> {
            if (Vars.state.isMenu()) {
                table.remove();
            }
        });
        table.actions(Actions.delay(duration * 0.9f), Actions.fadeOut(duration * 0.1f, Interp.fade), Actions.remove());
        table.top().table(Styles.black3, t -> t.margin(4.0f).add(info).style(Styles.outlineLabel)).padTop(10.0f);
        Core.scene.add(table);
        this.lastAnnouncement = table;
    }

    public void showInfoPopup(String info, float duration, int align, int top, int left, int bottom, int right) {
        Table table = new Table();
        table.setFillParent(true);
        table.touchable = Touchable.disabled;
        table.update(() -> {
            if (Vars.state.isMenu()) {
                table.remove();
            }
        });
        table.actions(Actions.delay(duration), Actions.remove());
        table.align(align).table(Styles.black3, t -> t.margin(4.0f).add(info).style(Styles.outlineLabel)).pad(top, left, bottom, right);
        Core.scene.add(table);
    }

    public void showLabel(String info, float duration, float worldx, float worldy) {
        Table table = new Table(Styles.black3).margin(4.0f);
        table.touchable = Touchable.disabled;
        table.update(() -> {
            if (Vars.state.isMenu()) {
                table.remove();
            }
            Vec2 v = Core.camera.project(worldx, worldy);
            table.setPosition(v.x, v.y, 1);
        });
        table.actions(Actions.delay(duration), Actions.remove());
        table.add(info).style(Styles.outlineLabel);
        table.pack();
        table.act(0.0f);
        Core.scene.root.addChildAt(0, table);
        ((Element)table.getChildren().first()).act(0.0f);
    }

    public void showInfo(final String info) {
        new Dialog(""){
            {
                super(arg0);
                this.getCell(this.cont).growX();
                this.cont.margin(15.0f).add(info).width(400.0f).wrap().get().setAlignment(1, 1);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.keyDown(KeyCode.enter, this::hide);
                this.closeOnBack();
            }
        }.show();
    }

    public void showInfoOnHidden(final String info, final Runnable listener) {
        new Dialog(""){
            {
                super(arg0);
                this.getCell(this.cont).growX();
                this.cont.margin(15.0f).add(info).width(400.0f).wrap().get().setAlignment(1, 1);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.hidden(listener);
                this.closeOnBack();
            }
        }.show();
    }

    public void showStartupInfo(final String info) {
        new Dialog(""){
            {
                super(arg0);
                this.getCell(this.cont).growX();
                this.cont.margin(15.0f).add(info).width(400.0f).wrap().get().setAlignment(8);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showErrorMessage(final String text) {
        new Dialog(""){
            {
                super(arg0);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                this.cont.add("@error.title");
                this.cont.row();
                this.cont.image().width(300.0f).pad(2.0f).height(4.0f).color(Color.scarlet);
                this.cont.row();
                this.cont.add(text).pad(2.0f).growX().wrap().get().setAlignment(1);
                this.cont.row();
                this.cont.button("@ok", this::hide).size(120.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showException(Throwable t) {
        this.showException("", t);
    }

    public void showException(final String text, final Throwable exc) {
        if (this.loadfrag == null) {
            return;
        }
        this.loadfrag.hide();
        new Dialog(""){
            {
                super(arg0);
                String message = Strings.getFinalMessage(exc);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                this.cont.add("@error.title").colspan(2);
                this.cont.row();
                this.cont.image().width(300.0f).pad(2.0f).colspan(2).height(4.0f).color(Color.scarlet);
                this.cont.row();
                this.cont.add((text.startsWith("@") ? Core.bundle.get(text.substring(1)) : text) + (message == null ? "" : "\n[lightgray](" + message + ")")).colspan(2).wrap().growX().center().get().setAlignment(1);
                this.cont.row();
                Collapser col = new Collapser(base -> base.pane((Table t) -> t.margin(14.0f).add(Strings.neatError(exc)).color(Color.lightGray).left()), true);
                this.cont.button("@details", Styles.togglet, col::toggle).size(180.0f, 50.0f).checked(b -> !col.isCollapsed()).fillX().right();
                this.cont.button("@ok", this::hide).size(110.0f, 50.0f).fillX().left();
                this.cont.row();
                this.cont.add(col).colspan(2).pad(2.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showText(String titleText, String text) {
        this.showText(titleText, text, 1);
    }

    public void showText(String titleText, final String text, final int align) {
        new Dialog(titleText){
            {
                super(arg0);
                this.cont.row();
                this.cont.image().width(400.0f).pad(2.0f).colspan(2).height(4.0f).color(Pal.accent);
                this.cont.row();
                this.cont.add(text).width(400.0f).wrap().get().setAlignment(align, align);
                this.cont.row();
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showInfoText(String titleText, final String text) {
        new Dialog(titleText){
            {
                super(arg0);
                this.cont.margin(15.0f).add(text).width(400.0f).wrap().left().get().setAlignment(8, 8);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showSmall(String titleText, final String text) {
        new Dialog(titleText){
            {
                super(arg0);
                this.cont.margin(10.0f).add(text);
                this.titleTable.row();
                this.titleTable.image().color(Pal.accent).height(3.0f).growX().pad(2.0f);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showConfirm(String text, Runnable confirmed) {
        this.showConfirm("@confirm", text, null, confirmed);
    }

    public void showConfirm(String title, String text, Runnable confirmed) {
        this.showConfirm(title, text, null, confirmed);
    }

    public void showConfirm(String title, String text, Boolp hide, Runnable confirmed) {
        BaseDialog dialog = new BaseDialog(title);
        dialog.cont.add(text).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.button("@cancel", Icon.cancel, dialog::hide);
        dialog.buttons.button("@ok", Icon.ok, () -> {
            dialog.hide();
            confirmed.run();
        });
        if (hide != null) {
            dialog.update(() -> {
                if (hide.get()) {
                    dialog.hide();
                }
            });
        }
        dialog.keyDown(KeyCode.enter, () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.keyDown(KeyCode.escape, dialog::hide);
        dialog.keyDown(KeyCode.back, dialog::hide);
        dialog.show();
    }

    public void showCustomConfirm(String title, String text, String yes, String no, Runnable confirmed, Runnable denied) {
        BaseDialog dialog = new BaseDialog(title);
        dialog.cont.add(text).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.button(no, () -> {
            dialog.hide();
            denied.run();
        });
        dialog.buttons.button(yes, () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.keyDown(KeyCode.escape, dialog::hide);
        dialog.keyDown(KeyCode.back, dialog::hide);
        dialog.show();
    }

    public boolean hasAnnouncement() {
        return this.lastAnnouncement != null && this.lastAnnouncement.parent != null;
    }

    public void announce(String text) {
        this.announce(text, 3.0f);
    }

    public void announce(String text, float duration) {
        Table t = new Table(Styles.black3);
        t.touchable = Touchable.disabled;
        t.margin(8.0f).add(text).style(Styles.outlineLabel).labelAlign(1);
        t.update(() -> {
            t.setPosition((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f, 1);
            t.toFront();
            if (Vars.state.isMenu() || !Vars.ui.hudfrag.shown) {
                t.remove();
            }
        });
        t.actions(Actions.fadeOut(duration, Interp.pow4In), Actions.remove());
        t.pack();
        t.act(0.1f);
        Core.scene.add(t);
        this.lastAnnouncement = t;
    }

    public void showOkText(String title, String text, Runnable confirmed) {
        BaseDialog dialog = new BaseDialog(title);
        dialog.cont.add(text).width(500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.button("@ok", () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.show();
    }

    public Dialog newMenuDialog(String title, final String message, final String[][] options, final Cons2<Integer, Dialog> buttonListener) {
        return new Dialog(title){
            {
                super(arg0);
                this.setFillParent(true);
                this.removeChild(this.titleTable);
                this.cont.add(this.titleTable).width(400.0f);
                this.cont.row();
                this.cont.image().width(400.0f).pad(2.0f).colspan(2).height(4.0f).color(Pal.accent).bottom();
                this.cont.row();
                this.cont.pane((Table table) -> {
                    table.add(message).width(400.0f).wrap().get().setAlignment(1);
                    table.row();
                    int option = 0;
                    for (String[] optionsRow : options) {
                        if (optionsRow.length == 0) continue;
                        Table buttonRow = table.row().table().get().row();
                        int fullWidth = 400 - (optionsRow.length - 1) * 8;
                        int width = fullWidth / optionsRow.length;
                        int lastWidth = fullWidth - width * (optionsRow.length - 1);
                        for (int i = 0; i < optionsRow.length; ++i) {
                            if (optionsRow[i] == null) continue;
                            String optionName = optionsRow[i];
                            int finalOption = option;
                            buttonRow.button(optionName, () -> buttonListener.get(finalOption, this)).size(i == optionsRow.length - 1 ? (float)lastWidth : (float)width, 50.0f).pad(4.0f);
                            ++option;
                        }
                    }
                }).growX();
            }
        };
    }

    public void showMenu(String title, String message, String[][] options, Intc callback) {
        Dialog dialog = this.newMenuDialog(title, message, options, (option, myself) -> {
            callback.get((int)option);
            myself.hide();
        });
        dialog.closeOnBack(() -> callback.get(-1));
        dialog.show();
    }

    public void showFollowUpMenu(int menuId, String title, String message, String[][] options, Intc callback) {
        Dialog dialog = this.newMenuDialog(title, message, options, (option, myself) -> callback.get((int)option));
        dialog.closeOnBack(() -> {
            this.followUpMenus.remove(menuId);
            callback.get(-1);
        });
        Dialog oldDialog = this.followUpMenus.remove(menuId);
        if (oldDialog != null) {
            dialog.show(Core.scene, null);
            oldDialog.hide(null);
        } else {
            dialog.show();
        }
        this.followUpMenus.put(menuId, dialog);
    }

    public void hideFollowUpMenu(int menuId) {
        if (!this.followUpMenus.containsKey(menuId)) {
            return;
        }
        this.followUpMenus.remove(menuId).hide();
    }

    public static String formatIcons(String s) {
        String[] tokens;
        if (!s.contains(":")) {
            return s;
        }
        buffer.setLength(0);
        boolean changed = false;
        boolean checkIcon = false;
        for (String token : tokens = s.split(":")) {
            if (checkIcon) {
                if (Iconc.codes.containsKey(token)) {
                    buffer.append((char)Iconc.codes.get(token));
                    changed = true;
                    checkIcon = false;
                    continue;
                }
                if (Fonts.hasUnicodeStr(token)) {
                    buffer.append(Fonts.getUnicodeStr(token));
                    changed = true;
                    checkIcon = false;
                    continue;
                }
                buffer.append(":").append(token);
                continue;
            }
            buffer.append(token);
            checkIcon = true;
        }
        return changed ? buffer.toString() : s;
    }

    public static String formatTime(float ticks) {
        int seconds = (int)(ticks / 60.0f);
        if (seconds < 60) {
            return "0:" + (seconds < 10 ? "0" : "") + seconds;
        }
        int minutes = seconds / 60;
        int modSec = seconds % 60;
        if (minutes < 60) {
            return minutes + ":" + (modSec < 10 ? "0" : "") + modSec;
        }
        int hours = minutes / 60;
        int modMinute = minutes % 60;
        return hours + ":" + (modMinute < 10 ? "0" : "") + modMinute + ":" + (modSec < 10 ? "0" : "") + modSec;
    }

    public static String formatAmount(long number) {
        String sign;
        if (number == Long.MAX_VALUE) {
            return "\u221e";
        }
        if (number == Long.MIN_VALUE) {
            return "-\u221e";
        }
        long mag = Math.abs(number);
        String string = sign = number < 0L ? "-" : "";
        if (mag >= 1000000000L) {
            return sign + Strings.fixed((float)mag / 1.0E9f, 1) + "[gray]" + billions + "[]";
        }
        if (mag >= 1000000L) {
            return sign + Strings.fixed((float)mag / 1000000.0f, 1) + "[gray]" + millions + "[]";
        }
        if (mag >= 10000L) {
            return number / 1000L + "[gray]" + thousands + "[]";
        }
        if (mag >= 1000L) {
            return sign + Strings.fixed((float)mag / 1000.0f, 1) + "[gray]" + thousands + "[]";
        }
        return number + "";
    }

    public static int roundAmount(int number) {
        if (number >= 1000000000) {
            return Mathf.round(number, 100000000);
        }
        if (number >= 1000000) {
            return Mathf.round(number, 100000);
        }
        if (number >= 10000) {
            return Mathf.round(number, 1000);
        }
        if (number >= 1000) {
            return Mathf.round(number, 100);
        }
        if (number >= 100) {
            return Mathf.round(number, 100);
        }
        if (number >= 10) {
            return Mathf.round(number, 10);
        }
        return number;
    }
}

