/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Objectives;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.SectorPreset;

public class TechTree {
    private static TechNode context = null;
    public static Seq<TechNode> all = new Seq();
    public static Seq<TechNode> roots = new Seq();

    public static TechNode nodeRoot(String name, UnlockableContent content, Runnable children) {
        return TechTree.nodeRoot(name, content, false, children);
    }

    public static TechNode nodeRoot(String name, UnlockableContent content, boolean requireUnlock, Runnable children) {
        TechNode root = TechTree.node(content, content.researchRequirements(), children);
        root.name = name;
        root.requiresUnlock = requireUnlock;
        roots.add(root);
        return root;
    }

    public static TechNode node(UnlockableContent content, Runnable children) {
        return TechTree.node(content, content.researchRequirements(), children);
    }

    public static TechNode node(UnlockableContent content, ItemStack[] requirements, Runnable children) {
        return TechTree.node(content, requirements, null, children);
    }

    public static TechNode node(UnlockableContent content, ItemStack[] requirements, Seq<Objectives.Objective> objectives, Runnable children) {
        SectorPreset preset;
        UnlockableContent unlockableContent;
        TechNode node = new TechNode(context, content, requirements);
        if (objectives != null) {
            node.objectives.addAll(objectives);
        }
        if (context != null && (unlockableContent = TechTree.context.content) instanceof SectorPreset && !node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)arg_0 -> TechTree.lambda$node$0(preset = (SectorPreset)unlockableContent, arg_0))))) {
            node.objectives.insert(0, new Objectives.SectorComplete(preset));
        }
        TechNode prev = context;
        context = node;
        children.run();
        context = prev;
        return node;
    }

    public static TechNode node(UnlockableContent content, Seq<Objectives.Objective> objectives, Runnable children) {
        return TechTree.node(content, content.researchRequirements(), objectives, children);
    }

    public static TechNode node(UnlockableContent block) {
        return TechTree.node(block, () -> {});
    }

    public static TechNode nodeProduce(UnlockableContent content, Seq<Objectives.Objective> objectives, Runnable children) {
        return TechTree.node(content, content.researchRequirements(), objectives.add(new Objectives.Produce(content)), children);
    }

    public static TechNode nodeProduce(UnlockableContent content, Runnable children) {
        return TechTree.nodeProduce(content, new Seq<Objectives.Objective>(), children);
    }

    @Nullable
    public static TechNode context() {
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ boolean lambda$node$0(SectorPreset preset, Objectives.Objective o) {
        if (!(o instanceof Objectives.SectorComplete)) return false;
        Objectives.SectorComplete sc = (Objectives.SectorComplete)o;
        if (sc.preset != preset) return false;
        return true;
    }

    public static class TechNode {
        public int depth;
        @Nullable
        public Drawable icon;
        @Nullable
        public String name;
        public boolean requiresUnlock = false;
        @Nullable
        public TechNode parent;
        @Nullable
        public ObjectFloatMap<Item> researchCostMultipliers;
        public UnlockableContent content;
        public ItemStack[] requirements;
        public ItemStack[] finishedRequirements;
        public Seq<Objectives.Objective> objectives = new Seq();
        public final Seq<TechNode> children = new Seq();
        @Nullable
        public Planet planet;

        public TechNode(@Nullable TechNode parent, UnlockableContent content, ItemStack[] requirements) {
            if (parent != null) {
                parent.children.add(this);
                this.planet = parent.planet;
                this.researchCostMultipliers = parent.researchCostMultipliers;
            } else if (this.researchCostMultipliers == null) {
                this.researchCostMultipliers = new ObjectFloatMap();
            }
            this.parent = parent;
            this.content = content;
            int n = this.depth = parent == null ? 0 : parent.depth + 1;
            if (this.researchCostMultipliers.size > 0) {
                for (ItemStack requirement : requirements = ItemStack.copy(requirements)) {
                    requirement.amount = (int)((float)requirement.amount * this.researchCostMultipliers.get(requirement.item, 1.0f));
                }
            }
            this.setupRequirements(requirements);
            ObjectSet used = new ObjectSet();
            content.getDependencies(d -> {
                if (used.add(d)) {
                    this.objectives.add(new Objectives.Research((UnlockableContent)d));
                }
            });
            content.techNode = this;
            content.techNodes.add(this);
            all.add(this);
        }

        public void each(Cons<TechNode> consumer) {
            consumer.get(this);
            for (TechNode child : this.children) {
                child.each(consumer);
            }
        }

        public void addDatabaseTab(UnlockableContent tab) {
            this.each(node -> node.content.databaseTabs.add(tab));
        }

        public void addPlanet(Planet planet) {
            this.each(node -> node.content.shownPlanets.add(planet));
        }

        public Drawable icon() {
            return this.icon == null ? new TextureRegionDrawable(this.content.uiIcon) : this.icon;
        }

        public String localizedName() {
            return Core.bundle.get("techtree." + this.name, this.name);
        }

        public void setupRequirements(ItemStack[] requirements) {
            this.requirements = requirements;
            this.finishedRequirements = new ItemStack[requirements.length];
            for (int i = 0; i < requirements.length; ++i) {
                this.finishedRequirements[i] = new ItemStack(requirements[i].item, Core.settings == null ? 0 : Core.settings.getInt("req-" + this.content.name + "-" + requirements[i].item.name));
            }
        }

        public void reset() {
            for (ItemStack stack : this.finishedRequirements) {
                stack.amount = 0;
            }
            this.save();
        }

        public void remove() {
            all.remove(this);
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
        }

        public void save() {
            for (ItemStack stack : this.finishedRequirements) {
                Core.settings.put("req-" + this.content.name + "-" + stack.item.name, stack.amount);
            }
        }
    }
}

