/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.func.Cons;
import arc.graphics.Color;
import arc.math.Rand;
import arc.math.geom.Mat3D;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.graphics.Pal;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.HexMesh;
import mindustry.graphics.g3d.HexSkyMesh;
import mindustry.graphics.g3d.MatMesh;
import mindustry.graphics.g3d.MultiMesh;
import mindustry.graphics.g3d.NoiseMesh;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.SunMesh;
import mindustry.maps.planet.AsteroidGenerator;
import mindustry.maps.planet.ErekirPlanetGenerator;
import mindustry.maps.planet.SerpuloPlanetGenerator;
import mindustry.maps.planet.TantrosPlanetGenerator;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.meta.Attribute;

public class Planets {
    public static Planet sun;
    public static Planet erekir;
    public static Planet tantros;
    public static Planet serpulo;
    public static Planet gier;
    public static Planet notva;
    public static Planet verilus;

    public static void load() {
        sun = new Planet("sun", null, 4.0f){
            {
                this.bloom = true;
                this.accessible = false;
                this.meshLoader = () -> new SunMesh(this, 4, 5.0, 0.3, 1.7, 1.2, 1.0, 1.1f, Color.valueOf("ff7a38"), Color.valueOf("ff9638"), Color.valueOf("ffc64c"), Color.valueOf("ffc64c"), Color.valueOf("ffe371"), Color.valueOf("f4ee8e"));
            }
        };
        erekir = new Planet("erekir", sun, 1.0f, 2){
            {
                this.generator = new ErekirPlanetGenerator();
                this.meshLoader = () -> new HexMesh(this, 5);
                this.cloudMeshLoader = () -> new MultiMesh(new HexSkyMesh(this, 2, 0.15f, 0.14f, 5, Color.valueOf("eba768").a(0.75f), 2, 0.42f, 1.0f, 0.43f), new HexSkyMesh(this, 3, 0.6f, 0.15f, 5, Color.valueOf("eea293").a(0.75f), 2, 0.42f, 1.2f, 0.45f));
                this.alwaysUnlocked = true;
                this.landCloudColor = Color.valueOf("ed6542");
                this.atmosphereColor = Color.valueOf("f07218");
                this.defaultEnv = 17;
                this.startSector = 10;
                this.atmosphereRadIn = 0.02f;
                this.atmosphereRadOut = 0.3f;
                this.tidalLock = true;
                this.orbitSpacing = 2.0f;
                this.totalRadius += 2.6f;
                this.lightSrcTo = 0.5f;
                this.lightDstFrom = 0.2f;
                this.clearSectorOnLose = true;
                this.defaultCore = Blocks.coreBastion;
                this.iconColor = Color.valueOf("ff9266");
                this.enemyBuildSpeedMultiplier = 0.4f;
                this.allowLaunchToNumbered = false;
                this.updateLighting = false;
                this.defaultAttributes.set(Attribute.heat, 0.8f);
                this.ruleSetter = r -> {
                    r.waveTeam = Team.malis;
                    r.placeRangeCheck = false;
                    r.showSpawns = true;
                    r.fog = true;
                    r.staticFog = true;
                    r.lighting = false;
                    r.coreDestroyClear = true;
                    r.onlyDepositCore = true;
                };
                this.campaignRuleDefaults.fog = true;
                this.campaignRuleDefaults.showSpawns = true;
                this.campaignRuleDefaults.rtsAI = true;
                this.unlockedOnLand.add(Blocks.coreBastion);
            }
        };
        gier = Planets.makeAsteroid("gier", erekir, Blocks.ferricStoneWall, Blocks.carbonWall, -5, 0.4f, 7, 1.0f, gen -> {
            gen.min = 25;
            gen.max = 35;
            gen.carbonChance = 0.6f;
            gen.iceChance = 0.0f;
            gen.berylChance = 0.1f;
        });
        notva = Planets.makeAsteroid("notva", sun, Blocks.ferricStoneWall, Blocks.beryllicStoneWall, -4, 0.55f, 9, 1.3f, gen -> {
            gen.berylChance = 0.8f;
            gen.iceChance = 0.0f;
            gen.carbonChance = 0.01f;
            gen.max += 2;
        });
        tantros = new Planet("tantros", sun, 1.0f, 2){
            {
                this.generator = new TantrosPlanetGenerator();
                this.meshLoader = () -> new HexMesh(this, 4);
                this.accessible = false;
                this.visible = false;
                this.atmosphereColor = Color.valueOf("3db899");
                this.iconColor = Color.valueOf("597be3");
                this.startSector = 10;
                this.atmosphereRadIn = -0.01f;
                this.atmosphereRadOut = 0.3f;
                this.defaultEnv = 5;
                this.ruleSetter = r -> {};
            }
        };
        serpulo = new Planet("serpulo", sun, 1.0f, 3){
            {
                this.loadPlanetData = true;
                this.generator = new SerpuloPlanetGenerator();
                this.meshLoader = () -> new HexMesh(this, 6);
                this.cloudMeshLoader = () -> new MultiMesh(new HexSkyMesh(this, 11, 0.15f, 0.13f, 5, new Color().set(Pal.spore).mul(0.9f).a(0.75f), 2, 0.45f, 0.9f, 0.38f), new HexSkyMesh(this, 1, 0.6f, 0.16f, 5, Color.white.cpy().lerp(Pal.spore, 0.55f).a(0.75f), 2, 0.45f, 1.0f, 0.41f));
                this.launchCapacityMultiplier = 0.5f;
                this.sectorSeed = 2;
                this.allowWaves = true;
                this.allowLegacyLaunchPads = true;
                this.allowWaveSimulation = true;
                this.allowSectorInvasion = true;
                this.allowLaunchSchematics = true;
                this.enemyCoreSpawnReplace = true;
                this.allowLaunchLoadout = true;
                this.prebuildBase = false;
                this.ruleSetter = r -> {
                    r.waveTeam = Team.crux;
                    r.placeRangeCheck = false;
                    r.showSpawns = false;
                    r.coreDestroyClear = true;
                };
                this.showRtsAIRule = true;
                this.iconColor = Color.valueOf("7d4dff");
                this.atmosphereColor = Color.valueOf("3c1b8f");
                this.atmosphereRadIn = 0.02f;
                this.atmosphereRadOut = 0.3f;
                this.startSector = 170;
                this.alwaysUnlocked = true;
                this.allowSelfSectorLaunch = true;
                this.landCloudColor = Pal.spore.cpy().a(0.5f);
            }
        };
        verilus = Planets.makeAsteroid("verlius", sun, Blocks.stoneWall, Blocks.iceWall, -1, 0.5f, 12, 2.0f, gen -> {
            gen.berylChance = 0.0f;
            gen.iceChance = 0.6f;
            gen.carbonChance = 0.1f;
            gen.ferricChance = 0.0f;
        });
    }

    private static Planet makeAsteroid(String name, Planet parent, final Block base, final Block tint, final int seed, final float tintThresh, final int pieces, final float scale, final Cons<AsteroidGenerator> cgen) {
        return new Planet(name, parent, 0.12f){
            {
                super(name, parent, radius);
                this.hasAtmosphere = false;
                this.updateLighting = false;
                this.sectors.add(new Sector(this, PlanetGrid.Ptile.empty));
                this.camRadius = 0.68f * scale;
                this.minZoom = 0.6f;
                this.drawOrbit = false;
                this.accessible = false;
                this.clipRadius = 2.0f;
                this.defaultEnv = 2;
                this.icon = "commandRally";
                this.generator = new AsteroidGenerator();
                cgen.get((AsteroidGenerator)this.generator);
                this.meshLoader = () -> {
                    this.iconColor = tint2.mapColor;
                    Color tinted = tint2.mapColor.cpy().a(1.0f - tint2.mapColor.a);
                    Seq<GenericMesh> meshes = new Seq<GenericMesh>();
                    Color color = base2.mapColor;
                    Rand rand = new Rand(this.id + 2);
                    meshes.add(new NoiseMesh(this, seed, 2, this.radius, 2, 0.55f, 0.45f, 14.0f, color, tinted, 3, 0.6f, 0.38f, tintThresh));
                    for (int j = 0; j < pieces; ++j) {
                        meshes.add(new MatMesh(new NoiseMesh(this, seed + j + 1, 1, 0.022f + rand.random(0.039f) * scale, 2, 0.6f, 0.38f, 20.0f, color, tinted, 3, 0.6f, 0.38f, tintThresh), new Mat3D().setToTranslation(Tmp.v31.setToRandomDirection(rand).setLength(rand.random(0.44f, 1.4f) * scale))));
                    }
                    return new MultiMesh((GenericMesh[])meshes.toArray(GenericMesh.class));
                };
            }
        };
    }
}

