/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import mindustry.Vars;
import mindustry.ai.ItemUnitStance;
import mindustry.ai.UnitStance;
import mindustry.ai.types.CommandAI;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitController;
import mindustry.gen.Call;
import mindustry.type.Item;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class MinerAI
extends AIController {
    public boolean mining = true;
    public Item targetItem;
    public Tile ore;

    @Override
    public void stanceChanged() {
        CommandAI ai;
        UnitController unitController;
        if (this.targetItem != null && (unitController = this.unit.controller()) instanceof CommandAI && !(ai = (CommandAI)unitController).hasStance(UnitStance.mineAuto) && !ai.hasStance(ItemUnitStance.getByItem(this.targetItem))) {
            this.mining = false;
            this.targetItem = null;
        }
    }

    @Override
    public void updateMovement() {
        CommandAI a;
        UnitController unitController;
        CommandAI ai;
        CoreBlock.CoreBuild core = this.unit.closestCore();
        if (!this.unit.canMine() || core == null) {
            return;
        }
        if (!this.unit.validMine(this.unit.mineTile)) {
            this.unit.mineTile(null);
        }
        CommandAI commandAI = ai = (unitController = this.unit.controller()) instanceof CommandAI ? (a = (CommandAI)unitController) : null;
        if (this.mining) {
            if (this.timer.get(1, 240.0f) || this.targetItem == null) {
                this.targetItem = ai != null && !ai.hasStance(UnitStance.mineAuto) ? Vars.content.items().min(i -> (this.unit.type.mineFloor && Vars.indexer.hasOre((Item)i) || this.unit.type.mineWalls && Vars.indexer.hasWallOre((Item)i)) && this.unit.canMine((Item)i) && ai.hasStance(ItemUnitStance.getByItem(i)), i -> core.items.get((Item)i)) : this.unit.type.mineItems.min(i -> (this.unit.type.mineFloor && Vars.indexer.hasOre((Item)i) || this.unit.type.mineWalls && Vars.indexer.hasWallOre((Item)i)) && this.unit.canMine((Item)i), i -> core.items.get((Item)i));
            }
            if (this.targetItem != null && core.acceptStack(this.targetItem, 1, this.unit) == 0) {
                this.unit.clearItem();
                this.unit.mineTile = null;
                return;
            }
            if (this.unit.stack.amount >= this.unit.type.itemCapacity || this.targetItem != null && !this.unit.acceptsItem(this.targetItem)) {
                this.mining = false;
            } else {
                if (this.timer.get(2, 60.0f) && this.targetItem != null) {
                    this.ore = null;
                    if (this.unit.type.mineFloor) {
                        this.ore = Vars.indexer.findClosestOre(core.x, core.y, this.targetItem);
                    }
                    if (this.ore == null && this.unit.type.mineWalls) {
                        this.ore = Vars.indexer.findClosestWallOre(core.x, core.y, this.targetItem);
                    }
                }
                if (this.ore != null) {
                    this.moveTo(this.ore, this.unit.type.mineRange / 2.0f, 20.0f);
                    if (this.unit.within(this.ore, this.unit.type.mineRange) && this.unit.validMine(this.ore)) {
                        this.unit.mineTile = this.ore;
                    }
                }
            }
        } else {
            this.unit.mineTile = null;
            if (this.unit.stack.amount == 0) {
                this.mining = true;
                return;
            }
            if (this.unit.within(core, this.unit.type.range)) {
                if (core.acceptStack(this.unit.stack.item, this.unit.stack.amount, this.unit) > 0) {
                    Call.transferItemTo(this.unit, this.unit.stack.item, this.unit.stack.amount, this.unit.x, this.unit.y, core);
                }
                this.unit.clearItem();
                this.mining = true;
            }
            this.circle(core, this.unit.type.range / 1.8f);
        }
        if (!this.unit.type.flying) {
            this.unit.updateBoosting(this.unit.type.boostWhenMining || this.unit.floorOn().isDuct || this.unit.floorOn().damageTaken > 0.0f || this.unit.floorOn().isDeep());
        }
    }
}

