/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.struct.IntFloatMap;
import arc.struct.IntIntMap;
import arc.struct.IntMap;
import arc.struct.IntQueue;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.LongMap;
import arc.struct.LongSeq;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.TaskQueue;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.PathfindQueue;
import mindustry.ai.Pathfinder;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.FieldIndex;
import mindustry.gen.IntraEdge;
import mindustry.gen.NodeIndex;
import mindustry.gen.PathTile;
import mindustry.gen.Unit;
import mindustry.world.Tile;

public class ControlPathfinder
implements Runnable {
    private static final int wallImpassableCap = 1000000;
    private static final int solidCap = 7000;
    private static boolean initialized;
    public static boolean showDebug;
    public static final Pathfinder.PathCost costGround;
    public static final Pathfinder.PathCost costHover;
    public static final Pathfinder.PathCost costLegs;
    public static final Pathfinder.PathCost costNaval;
    public static final int costIdGround = 0;
    public static final int costIdHover = 1;
    public static final int costIdLegs = 2;
    public static final int costIdNaval = 3;
    public static final Seq<Pathfinder.PathCost> costTypes;
    private static final long maxUpdate;
    private static final int updateStepInterval = 200;
    private static final int updateFPS = 30;
    private static final int updateInterval = 33;
    private static final int invalidateCheckInterval = 1000;
    static final int clusterSize = 12;
    static final int[] offsets;
    static final int[] moveDirs;
    static final int[] nextOffsets;
    final Cluster[][][] clusters = new Cluster[256][][];
    final int cwidth = Mathf.ceil((float)Vars.world.width() / 12.0f);
    final int cheight = Mathf.ceil((float)Vars.world.height() / 12.0f);
    final IntSet usedEdges = new IntSet();
    final TaskQueue queue = new TaskQueue();
    final ObjectMap<Unit, PathRequest> unitRequests = new ObjectMap();
    final Seq<PathRequest> threadPathRequests = new Seq(false);
    final LongMap<FieldCache> fields = new LongMap();
    final Seq<FieldCache> fieldList = new Seq(false);
    final IntFloatMap innerCosts = new IntFloatMap();
    final PathfindQueue innerFrontier = new PathfindQueue();
    final IntSet clustersToUpdate = new IntSet();
    final IntSet clustersToInnerUpdate = new IntSet();
    final ObjectSet<PathRequest> invalidRequests = new ObjectSet();
    @Nullable
    Thread thread;
    volatile boolean invalidated;

    static void checkEvents() {
        if (initialized) {
            return;
        }
        initialized = true;
        Events.on(EventType.ResetEvent.class, event -> Vars.controlPath.stop());
        Events.on(EventType.WorldLoadEvent.class, event -> {
            Vars.controlPath.stop();
            Vars.controlPath = new ControlPathfinder();
            Vars.controlPath.start();
        });
        Events.on(EventType.TileChangeEvent.class, e -> Vars.controlPath.updateTile(e.tile));
        Events.run((Object)EventType.Trigger.update, () -> {
            for (PathRequest req : Vars.controlPath.unitRequests.values()) {
                if (req.lastUpdateId > Vars.state.updateId - 10L && req.unit.isAdded()) continue;
                req.invalidated = true;
                Vars.controlPath.queue.post(() -> Vars.controlPath.threadPathRequests.remove(req));
                Time.run(0.0f, () -> Vars.controlPath.unitRequests.remove(req.unit));
            }
            for (FieldCache field : Vars.controlPath.fieldList) {
                if (field.lastUpdateId > Vars.state.updateId - 30L) continue;
                Vars.controlPath.queue.post(() -> Vars.controlPath.fields.remove(field.mapKey));
                Time.run(0.0f, () -> Vars.controlPath.fieldList.remove(field));
            }
        });
        if (showDebug) {
            Events.run((Object)EventType.Trigger.draw, () -> {
                int team = Vars.player.team().id;
                int cost = 0;
                Draw.draw(120.0f, () -> {
                    Lines.stroke(1.0f);
                    if (Vars.controlPath.clusters[team] != null && Vars.controlPath.clusters[team][cost] != null) {
                        for (int cx = 0; cx < Vars.controlPath.cwidth; ++cx) {
                            for (int cy = 0; cy < Vars.controlPath.cheight; ++cy) {
                                Cluster cluster = Vars.controlPath.clusters[team][cost][cy * Vars.controlPath.cwidth + cx];
                                if (cluster == null) continue;
                                Lines.stroke(0.5f);
                                Draw.color(Color.gray);
                                Lines.stroke(1.0f);
                                Lines.rect((float)(cx * 12 * 8) - 4.0f, (float)(cy * 12 * 8) - 4.0f, 96.0f, 96.0f);
                                for (int i = 0; i < 4; ++i) {
                                    IntSeq portals = cluster.portals[i];
                                    if (portals == null) continue;
                                    for (int i2 = 0; i2 < portals.size; ++i2) {
                                        LongSeq connections;
                                        int pos = portals.items[i2];
                                        short from = Point2.x(pos);
                                        short to = Point2.y(pos);
                                        float width = 8 * (Math.abs(from - to) + 1);
                                        float height = 8.0f;
                                        Vars.controlPath.portalToVec(cluster, cx, cy, i, i2, Tmp.v1);
                                        Draw.color(Color.brown);
                                        Lines.ellipse(30, Tmp.v1.x, Tmp.v1.y, width / 2.0f, height / 2.0f, (float)i * 90.0f - 90.0f);
                                        LongSeq longSeq = connections = cluster.portalConnections[i] == null ? null : cluster.portalConnections[i][i2];
                                        if (connections == null) continue;
                                        Draw.color(Color.forest);
                                        for (int coni = 0; coni < connections.size; ++coni) {
                                            long con = connections.items[coni];
                                            Vars.controlPath.portalToVec(cluster, cx, cy, IntraEdge.dir(con), IntraEdge.portal(con), Tmp.v2);
                                            float x1 = Tmp.v1.x;
                                            float y1 = Tmp.v1.y;
                                            float x2 = Tmp.v2.x;
                                            float y2 = Tmp.v2.y;
                                            Lines.line(x1, y1, x2, y2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    for (FieldCache fields : Vars.controlPath.fieldList) {
                        try {
                            for (IntMap.Entry<int[]> entry : fields.fields) {
                                int cx = entry.key % Vars.controlPath.cwidth;
                                int cy = entry.key / Vars.controlPath.cwidth;
                                for (int y = 0; y < 12; ++y) {
                                    for (int x = 0; x < 12; ++x) {
                                        int value = ((int[])entry.value)[x + y * 12];
                                        Tmp.c1.a = 1.0f;
                                        Lines.stroke(0.8f, Tmp.c1.fromHsv((float)value * 3.0f, 1.0f, 1.0f));
                                        Draw.alpha(0.5f);
                                        Fill.square((x + cx * 12) * 8, (y + cy * 12) * 8, 4.0f);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                });
                Draw.reset();
            });
        }
    }

    public ControlPathfinder() {
        ControlPathfinder.checkEvents();
    }

    public void updateTile(Tile tile) {
        tile.getLinkedTiles(this::updateSingleTile);
    }

    public void updateSingleTile(Tile t) {
        short x = t.x;
        short y = t.y;
        int mx = x % 12;
        int my = y % 12;
        int cx = x / 12;
        int cy = y / 12;
        int cluster = cx + cy * this.cwidth;
        if (mx == 0 || my == 0 || mx == 11 || my == 11) {
            if (mx == 0) {
                this.queueClusterUpdate(cx - 1, cy);
            }
            if (my == 0) {
                this.queueClusterUpdate(cx, cy - 1);
            }
            if (mx == 11) {
                this.queueClusterUpdate(cx + 1, cy);
            }
            if (my == 11) {
                this.queueClusterUpdate(cx, cy + 1);
            }
            this.queueClusterUpdate(cx, cy);
        } else {
            this.queue.post(() -> this.clustersToInnerUpdate.add(cluster));
        }
    }

    void queueClusterUpdate(int cx, int cy) {
        if (cx >= 0 && cy >= 0 && cx < this.cwidth && cy < this.cheight) {
            this.queue.post(() -> this.clustersToUpdate.add(cx + cy * this.cwidth));
        }
    }

    void portalToVec(Cluster cluster, int cx, int cy, int direction, int portalIndex, Vec2 out) {
        int pos = cluster.portals[direction].items[portalIndex];
        short from = Point2.x(pos);
        short to = Point2.y(pos);
        int addX = moveDirs[direction * 2];
        int addY = moveDirs[direction * 2 + 1];
        float average = (float)(from + to) / 2.0f;
        float x = ((float)addX * average + (float)(cx * 12) + (float)(offsets[direction * 2] * 11) + (float)nextOffsets[direction * 2] / 2.0f) * 8.0f;
        float y = ((float)addY * average + (float)(cy * 12) + (float)(offsets[direction * 2 + 1] * 11) + (float)nextOffsets[direction * 2 + 1] / 2.0f) * 8.0f;
        out.set(x, y);
    }

    private void start() {
        if (Vars.net.client() || this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Control Pathfinder");
        this.thread.setPriority(1);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.invalidated = true;
        this.queue.clear();
    }

    @Nullable
    Cluster getCluster(int team, int pathCost, int cx, int cy) {
        return this.getCluster(team, pathCost, cx + cy * this.cwidth);
    }

    @Nullable
    Cluster getCluster(int team, int pathCost, int clusterIndex) {
        if (this.clusters == null) {
            return null;
        }
        Cluster[][] dim1 = this.clusters[team];
        if (dim1 == null) {
            return null;
        }
        Cluster[] dim2 = dim1[pathCost];
        if (dim2 == null) {
            return null;
        }
        return dim2[clusterIndex];
    }

    Cluster getCreateCluster(int team, int pathCost, int cx, int cy) {
        return this.getCreateCluster(team, pathCost, cx + cy * this.cwidth);
    }

    Cluster getCreateCluster(int team, int pathCost, int clusterIndex) {
        Cluster result = this.getCluster(team, pathCost, clusterIndex);
        if (result == null) {
            return this.updateCluster(team, pathCost, clusterIndex % this.cwidth, clusterIndex / this.cwidth);
        }
        return result;
    }

    Cluster updateCluster(int team, int pathCost, int cx, int cy) {
        Cluster cluster;
        Cluster[] dim2;
        Cluster[][] dim1 = this.clusters[team];
        if (dim1 == null) {
            this.clusters[team] = new Cluster[Team.all.length][];
            dim1 = this.clusters[team];
        }
        if ((dim2 = dim1[pathCost]) == null) {
            dim1[pathCost] = new Cluster[this.cwidth * this.cheight];
            dim2 = dim1[pathCost];
        }
        if ((cluster = dim2[cy * this.cwidth + cx]) == null) {
            Cluster cluster2 = new Cluster();
            dim2[cy * this.cwidth + cx] = cluster2;
            cluster = cluster2;
        } else {
            for (IntSeq p : cluster.portals) {
                if (p == null) continue;
                p.clear();
            }
        }
        Pathfinder.PathCost cost = this.idToCost(pathCost);
        for (int direction = 0; direction < 4; ++direction) {
            IntSeq portals;
            int otherX = cx + Geometry.d4x(direction);
            int otherY = cy + Geometry.d4y(direction);
            if (otherX < 0 || otherY < 0 || otherX >= this.cwidth || otherY >= this.cheight) continue;
            Cluster other = dim2[otherX + otherY * this.cwidth];
            if (other == null) {
                portals = cluster.portals[direction] = new IntSeq(4);
            } else {
                cluster.portals[direction] = other.portals[(direction + 2) % 4];
                portals = cluster.portals[direction];
                if (portals == null) {
                    IntSeq intSeq = new IntSeq();
                    other.portals[(direction + 2) % 4] = intSeq;
                    cluster.portals[direction] = intSeq;
                    portals = intSeq;
                }
                portals.clear();
            }
            int addX = moveDirs[direction * 2];
            int addY = moveDirs[direction * 2 + 1];
            int baseX = cx * 12 + offsets[direction * 2] * 11;
            int baseY = cy * 12 + offsets[direction * 2 + 1] * 11;
            int nextBaseX = baseX + Geometry.d4[direction].x;
            int nextBaseY = baseY + Geometry.d4[direction].y;
            int lastPortal = -1;
            boolean prevSolid = true;
            for (int i = 0; i < 12; ++i) {
                int x = baseX + addX * i;
                int y = baseY + addY * i;
                if (ControlPathfinder.solid(team, cost, x, y) || ControlPathfinder.solid(team, cost, nextBaseX + addX * i, nextBaseY + addY * i)) {
                    int previous = i - 1;
                    if (!prevSolid && previous >= lastPortal) {
                        portals.add(Point2.pack(previous, lastPortal));
                    }
                    prevSolid = true;
                    continue;
                }
                if (prevSolid) {
                    lastPortal = i;
                }
                prevSolid = false;
            }
            int previous = 11;
            if (prevSolid || previous < lastPortal) continue;
            portals.add(Point2.pack(previous, lastPortal));
        }
        this.updateInnerEdges(team, cost, cx, cy, cluster);
        return cluster;
    }

    void updateInnerEdges(int team, int cost, int cx, int cy, Cluster cluster) {
        this.updateInnerEdges(team, this.idToCost(cost), cx, cy, cluster);
    }

    void updateInnerEdges(int team, Pathfinder.PathCost cost, int cx, int cy, Cluster cluster) {
        int minX = cx * 12;
        int minY = cy * 12;
        int maxX = Math.min(minX + 12 - 1, Pathfinder.wwidth - 1);
        int maxY = Math.min(minY + 12 - 1, Pathfinder.wheight - 1);
        this.usedEdges.clear();
        cluster.portalConnections = new LongSeq[4][];
        for (int direction = 0; direction < 4; ++direction) {
            IntSeq portals = cluster.portals[direction];
            if (portals == null) continue;
            int addX = moveDirs[direction * 2];
            int addY = moveDirs[direction * 2 + 1];
            for (int i = 0; i < portals.size; ++i) {
                this.usedEdges.add(Point2.pack(direction, i));
                int portal = portals.items[i];
                short from = Point2.x(portal);
                short to = Point2.y(portal);
                int average = (from + to) / 2;
                int x = addX * average + cx * 12 + offsets[direction * 2] * 11;
                int y = addY * average + cy * 12 + offsets[direction * 2 + 1] * 11;
                for (int otherDir = 0; otherDir < 4; ++otherDir) {
                    IntSeq otherPortals = cluster.portals[otherDir];
                    if (otherPortals == null) continue;
                    for (int j = 0; j < otherPortals.size; ++j) {
                        float connectionCost;
                        if (this.usedEdges.contains(Point2.pack(otherDir, j))) continue;
                        int other = otherPortals.items[j];
                        short otherFrom = Point2.x(other);
                        short otherTo = Point2.y(other);
                        int otherAverage = (otherFrom + otherTo) / 2;
                        int ox = cx * 12 + offsets[otherDir * 2] * 11;
                        int oy = cy * 12 + offsets[otherDir * 2 + 1] * 11;
                        int otherX = moveDirs[otherDir * 2] * otherAverage + ox;
                        int otherY = moveDirs[otherDir * 2 + 1] * otherAverage + oy;
                        if (Point2.pack(x, y) == Point2.pack(otherX, otherY) || (connectionCost = this.innerAstar(team, cost, minX, minY, maxX, maxY, x + y * Pathfinder.wwidth, otherX + otherY * Pathfinder.wwidth, moveDirs[otherDir * 2] * otherFrom + ox, moveDirs[otherDir * 2 + 1] * otherFrom + oy, moveDirs[otherDir * 2] * otherTo + ox, moveDirs[otherDir * 2 + 1] * otherTo + oy)) == -1.0f) continue;
                        if (cluster.portalConnections[direction] == null) {
                            cluster.portalConnections[direction] = new LongSeq[cluster.portals[direction].size];
                        }
                        if (cluster.portalConnections[otherDir] == null) {
                            cluster.portalConnections[otherDir] = new LongSeq[cluster.portals[otherDir].size];
                        }
                        if (cluster.portalConnections[direction][i] == null) {
                            cluster.portalConnections[direction][i] = new LongSeq(8);
                        }
                        if (cluster.portalConnections[otherDir][j] == null) {
                            cluster.portalConnections[otherDir][j] = new LongSeq(8);
                        }
                        cluster.portalConnections[direction][i].add(IntraEdge.get(otherDir, j, connectionCost));
                        cluster.portalConnections[otherDir][j].add(IntraEdge.get(direction, i, connectionCost));
                    }
                }
            }
        }
    }

    private static float heuristic(int a, int b) {
        int x = a % Pathfinder.wwidth;
        int x2 = b % Pathfinder.wwidth;
        int y = a / Pathfinder.wwidth;
        int y2 = b / Pathfinder.wwidth;
        return Math.abs(x - x2) + Math.abs(y - y2);
    }

    private static int tcost(int team, Pathfinder.PathCost cost, int tilePos) {
        return cost.getCost(team, Vars.pathfinder.tiles[tilePos]);
    }

    private static float tileCost(int team, Pathfinder.PathCost type, int a, int b) {
        return ControlPathfinder.cost(team, type, b);
    }

    float innerAstar(int team, Pathfinder.PathCost cost, int minX, int minY, int maxX, int maxY, int startPos, int goalPos, int goalX1, int goalY1, int goalX2, int goalY2) {
        int tmp;
        PathfindQueue frontier = this.innerFrontier;
        IntFloatMap costs = this.innerCosts;
        frontier.clear();
        costs.clear();
        costs.put(startPos, 0.0f);
        frontier.add(startPos, 0.0f);
        if (goalX2 < goalX1) {
            tmp = goalX1;
            goalX1 = goalX2;
            goalX2 = tmp;
        }
        if (goalY2 < goalY1) {
            tmp = goalY1;
            goalY1 = goalY2;
            goalY2 = tmp;
        }
        while (frontier.size > 0) {
            int current = frontier.poll();
            int cx = current % Pathfinder.wwidth;
            int cy = current / Pathfinder.wwidth;
            if (cx >= goalX1 && cy >= goalY1 && cx <= goalX2 && cy <= goalY2 || current == goalPos) {
                return costs.get(current);
            }
            for (Point2 point : Geometry.d4) {
                float newCost;
                float add;
                int newx = cx + point.x;
                int newy = cy + point.y;
                int next = newx + Pathfinder.wwidth * newy;
                if (newx > maxX || newy > maxY || newx < minX || newy < minY || ControlPathfinder.tcost(team, cost, next) == -1 || (add = ControlPathfinder.tileCost(team, cost, current, next)) < 0.0f || !((newCost = costs.get(current) + add) < costs.get(next, Float.POSITIVE_INFINITY))) continue;
                costs.put(next, newCost);
                float priority = newCost + ControlPathfinder.heuristic(next, goalPos);
                frontier.add(next, priority);
            }
        }
        return -1.0f;
    }

    int makeNodeIndex(int cx, int cy, int dir, int portal) {
        if (dir == 2 && cx != 0) {
            dir = 0;
            --cx;
        }
        if (dir == 3 && cy != 0) {
            dir = 1;
            --cy;
        }
        return NodeIndex.get(cx + cy * this.cwidth, dir, portal);
    }

    private int findClosestNode(int team, int pathCost, int tileX, int tileY) {
        int cx = tileX / 12;
        int cy = tileY / 12;
        if (cx < 0 || cy < 0 || cx >= this.cwidth || cy >= this.cheight) {
            return Integer.MAX_VALUE;
        }
        Pathfinder.PathCost cost = this.idToCost(pathCost);
        Cluster cluster = this.getCreateCluster(team, pathCost, cx, cy);
        int minX = cx * 12;
        int minY = cy * 12;
        int maxX = Math.min(minX + 12 - 1, Pathfinder.wwidth - 1);
        int maxY = Math.min(minY + 12 - 1, Pathfinder.wheight - 1);
        int bestPortalPair = Integer.MAX_VALUE;
        float bestCost = Float.MAX_VALUE;
        for (int dir = 0; dir < 4; ++dir) {
            IntSeq portals = cluster.portals[dir];
            if (portals == null) continue;
            for (int j = 0; j < portals.size; ++j) {
                int oy;
                int otherY;
                int ox;
                short otherTo;
                int other = portals.items[j];
                short otherFrom = Point2.x(other);
                int otherAverage = (otherFrom + (otherTo = Point2.y(other))) / 2;
                int otherX = moveDirs[dir * 2] * otherAverage + (ox = cx * 12 + offsets[dir * 2] * 11);
                float connectionCost = this.innerAstar(team, cost, minX, minY, maxX, maxY, tileX + tileY * Pathfinder.wwidth, otherX + (otherY = moveDirs[dir * 2 + 1] * otherAverage + (oy = cy * 12 + offsets[dir * 2 + 1] * 11)) * Pathfinder.wwidth, moveDirs[dir * 2] * otherFrom + ox, moveDirs[dir * 2 + 1] * otherFrom + oy, moveDirs[dir * 2] * otherTo + ox, moveDirs[dir * 2 + 1] * otherTo + oy);
                if (connectionCost == -1.0f || !(connectionCost < bestCost)) continue;
                bestPortalPair = Point2.pack(dir, j);
                bestCost = connectionCost;
            }
        }
        if (bestPortalPair != Integer.MAX_VALUE) {
            return this.makeNodeIndex(cx, cy, Point2.x(bestPortalPair), Point2.y(bestPortalPair));
        }
        return Integer.MAX_VALUE;
    }

    private float clusterNodeHeuristic(int team, int pathCost, int nodeA, int nodeB) {
        int clusterA = NodeIndex.cluster(nodeA);
        int dirA = NodeIndex.dir(nodeA);
        int portalA = NodeIndex.portal(nodeA);
        int clusterB = NodeIndex.cluster(nodeB);
        int dirB = NodeIndex.dir(nodeB);
        int portalB = NodeIndex.portal(nodeB);
        int rangeA = this.getCreateCluster((int)team, (int)pathCost, (int)clusterA).portals[dirA].items[portalA];
        int rangeB = this.getCreateCluster((int)team, (int)pathCost, (int)clusterB).portals[dirB].items[portalB];
        float averageA = (float)(Point2.x(rangeA) + Point2.y(rangeA)) / 2.0f;
        float x1 = (float)moveDirs[dirA * 2] * averageA + (float)(clusterA % this.cwidth * 12) + (float)(offsets[dirA * 2] * 11) + (float)nextOffsets[dirA * 2] / 2.0f;
        float y1 = (float)moveDirs[dirA * 2 + 1] * averageA + (float)(clusterA / this.cwidth * 12) + (float)(offsets[dirA * 2 + 1] * 11) + (float)nextOffsets[dirA * 2 + 1] / 2.0f;
        float averageB = (float)(Point2.x(rangeB) + Point2.y(rangeB)) / 2.0f;
        float x2 = (float)moveDirs[dirB * 2] * averageB + (float)(clusterB % this.cwidth * 12) + (float)(offsets[dirB * 2] * 11) + (float)nextOffsets[dirB * 2] / 2.0f;
        float y2 = (float)moveDirs[dirB * 2 + 1] * averageB + (float)(clusterB / this.cwidth * 12) + (float)(offsets[dirB * 2 + 1] * 11) + (float)nextOffsets[dirB * 2 + 1] / 2.0f;
        return Math.abs(x1 - x2) + Math.abs(y1 - y2);
    }

    @Nullable
    IntSeq clusterAstar(PathRequest request, int pathCost, int startNodeIndex, int endNodeIndex) {
        IntSeq result = request.resultPath;
        if (startNodeIndex == endNodeIndex) {
            result.clear();
            result.add(startNodeIndex);
            return result;
        }
        int team = request.team;
        if (request.costs == null) {
            request.costs = new IntFloatMap();
        }
        if (request.cameFrom == null) {
            request.cameFrom = new IntIntMap();
        }
        if (request.frontier == null) {
            request.frontier = new PathfindQueue();
        }
        IntFloatMap costs = request.costs;
        IntIntMap cameFrom = request.cameFrom;
        PathfindQueue frontier = request.frontier;
        cameFrom.put(startNodeIndex, startNodeIndex);
        costs.put(startNodeIndex, 0.0f);
        frontier.add(startNodeIndex, 0.0f);
        boolean foundEnd = false;
        while (frontier.size > 0) {
            LongSeq innerCons;
            int current = frontier.poll();
            if (current == endNodeIndex) {
                foundEnd = true;
                break;
            }
            int cluster = NodeIndex.cluster(current);
            int dir = NodeIndex.dir(current);
            int portal = NodeIndex.portal(current);
            int cx = cluster % this.cwidth;
            int cy = cluster / this.cwidth;
            if (cx >= this.cwidth || cy >= this.cheight || cx < 0 || cy < 0) continue;
            Cluster clust = this.getCreateCluster(team, pathCost, cluster);
            LongSeq longSeq = innerCons = clust.portalConnections[dir] == null || portal >= clust.portalConnections[dir].length ? null : clust.portalConnections[dir][portal];
            if (innerCons != null) {
                this.checkEdges(request, team, pathCost, current, endNodeIndex, cx, cy, innerCons);
            }
            int nextCx = cx + Geometry.d4[dir].x;
            int nextCy = cy + Geometry.d4[dir].y;
            if (nextCx < 0 || nextCy < 0 || nextCx >= this.cwidth || nextCy >= this.cheight) continue;
            Cluster nextCluster = this.getCreateCluster(team, pathCost, nextCx, nextCy);
            int relativeDir = (dir + 2) % 4;
            LongSeq outerCons = nextCluster.portalConnections[relativeDir] == null || nextCluster.portalConnections[relativeDir].length <= portal ? null : nextCluster.portalConnections[relativeDir][portal];
            if (outerCons == null) continue;
            this.checkEdges(request, team, pathCost, current, endNodeIndex, nextCx, nextCy, outerCons);
        }
        request.costs = null;
        request.cameFrom = null;
        request.frontier = null;
        if (foundEnd) {
            result.clear();
            int cur = endNodeIndex;
            while (cur != startNodeIndex) {
                result.add(cur);
                cur = cameFrom.get(cur);
            }
            result.reverse();
            return result;
        }
        return null;
    }

    private void checkEdges(PathRequest request, int team, int pathCost, int current, int goal, int cx, int cy, LongSeq connections) {
        for (int i = 0; i < connections.size; ++i) {
            long con = connections.items[i];
            float cost = IntraEdge.cost(con);
            int otherDir = IntraEdge.dir(con);
            int otherPortal = IntraEdge.portal(con);
            int next = this.makeNodeIndex(cx, cy, otherDir, otherPortal);
            float newCost = request.costs.get(current) + cost;
            if (!(newCost < request.costs.get(next, Float.POSITIVE_INFINITY))) continue;
            request.costs.put(next, newCost);
            request.frontier.add(next, newCost + this.clusterNodeHeuristic(team, pathCost, next, goal));
            request.cameFrom.put(next, current);
        }
    }

    private void updateFields(FieldCache cache, long nsToRun) {
        IntQueue frontier = cache.frontier;
        IntMap<int[]> fields = cache.fields;
        int goalPos = cache.goalPos;
        Pathfinder.PathCost pcost = cache.cost;
        int team = cache.team;
        long start = Time.nanos();
        int counter = 0;
        while (frontier.size > 0) {
            int baseY;
            int tile = frontier.removeLast();
            int baseX = tile % Pathfinder.wwidth;
            int curWeightIndex = baseX / 12 + (baseY = tile / Pathfinder.wwidth) / 12 * this.cwidth;
            int[] curWeights = fields.get(curWeightIndex);
            if (curWeights == null) continue;
            int cost = curWeights[baseX % 12 + baseY % 12 * 12];
            if (cost != -1) {
                for (Point2 point : Geometry.d4) {
                    int newPos;
                    int[] weights;
                    int dx = baseX + point.x;
                    int dy = baseY + point.y;
                    int clx = dx / 12;
                    int cly = dy / 12;
                    if (clx < 0 || cly < 0 || dx >= Pathfinder.wwidth || dy >= Pathfinder.wheight) continue;
                    int nextWeightIndex = clx + cly * this.cwidth;
                    int[] nArray = weights = nextWeightIndex == curWeightIndex ? curWeights : fields.get(nextWeightIndex);
                    if (weights == null || (newPos = tile + point.x + point.y * Pathfinder.wwidth) == goalPos || dx - clx * 12 < 0 || dy - cly * 12 < 0) continue;
                    int newPosArray = dx - clx * 12 + (dy - cly * 12) * 12;
                    int otherCost = pcost.getCost(team, Vars.pathfinder.tiles[newPos]);
                    int oldCost = weights[newPosArray];
                    if (oldCost != 0 && oldCost <= cost + otherCost || otherCost == -1) continue;
                    frontier.addFirst(newPos);
                    weights[newPosArray] = cost + otherCost;
                }
            }
            if (nsToRun < 0L || counter++ < 200) continue;
            counter = 0;
            if (Time.timeSinceNanos(start) < nsToRun) continue;
            return;
        }
    }

    private void addFlowCluster(FieldCache cache, int cluster, boolean addingFrontier) {
        this.addFlowCluster(cache, cluster % this.cwidth, cluster / this.cwidth, addingFrontier);
    }

    private void addFlowCluster(FieldCache cache, int cx, int cy, boolean addingFrontier) {
        if (cx < 0 || cy < 0 || cx >= this.cwidth || cy >= this.cheight) {
            return;
        }
        IntMap<int[]> fields = cache.fields;
        int key = cx + cy * this.cwidth;
        if (!fields.containsKey(key)) {
            fields.put(key, new int[144]);
            if (addingFrontier) {
                for (int dir = 0; dir < 4; ++dir) {
                    int[] otherField;
                    int ox = cx + nextOffsets[dir * 2];
                    int oy = cy + nextOffsets[dir * 2 + 1];
                    if (ox < 0 || oy < 0 || ox >= this.cwidth || oy >= this.cheight || (otherField = fields.get(ox + oy * this.cwidth)) == null) continue;
                    int relOffset = (dir + 2) % 4;
                    int movex = moveDirs[relOffset * 2];
                    int movey = moveDirs[relOffset * 2 + 1];
                    int otherx1 = offsets[relOffset * 2] * 11;
                    int othery1 = offsets[relOffset * 2 + 1] * 11;
                    for (int i = 0; i < 12; ++i) {
                        int x = otherx1 + movex * i;
                        int y = othery1 + movey * i;
                        if (otherField[x + y * 12] <= 0) continue;
                        int worldX = x + ox * 12;
                        int worldY = y + oy * 12;
                        cache.frontier.addFirst(worldX + worldY * Pathfinder.wwidth);
                        if (!showDebug) continue;
                        Core.app.post(() -> Fx.placeBlock.at((float)(worldX * 8), (float)(worldY * 8), 1.0f));
                    }
                }
            }
        }
    }

    private void initializePathRequest(PathRequest request, int team, int costId, int unitX, int unitY, int goalX, int goalY) {
        Pathfinder.PathCost pcost = this.idToCost(costId);
        int goalPos = goalX + goalY * Pathfinder.wwidth;
        int node = this.findClosestNode(team, costId, unitX, unitY);
        int dest = this.findClosestNode(team, costId, goalX, goalY);
        if (dest == Integer.MAX_VALUE) {
            request.notFound = true;
            return;
        }
        IntSeq nodePath = this.clusterAstar(request, costId, node, dest);
        if (nodePath == null) {
            request.notFound = true;
            request.oldCache = null;
            return;
        }
        FieldCache cache = this.fields.get(FieldIndex.get(goalPos, costId, team));
        boolean addingFrontier = true;
        if (cache == null) {
            cache = new FieldCache(pcost, costId, team, goalPos);
            this.fields.put(cache.mapKey, cache);
            FieldCache fcache = cache;
            Core.app.post(() -> this.fieldList.add(fcache));
            cache.frontier.addFirst(goalPos);
            addingFrontier = false;
        }
        if (nodePath != null) {
            int cx = unitX / 12;
            int cy = unitY / 12;
            this.addFlowCluster(cache, cx, cy, addingFrontier);
            for (int i = -1; i < nodePath.size; ++i) {
                int current = i == -1 ? node : nodePath.items[i];
                int cluster = NodeIndex.cluster(current);
                int dir = NodeIndex.dir(current);
                int dx = Geometry.d4[dir].x;
                int dy = Geometry.d4[dir].y;
                int ox = cluster % this.cwidth + dx;
                int oy = cluster / this.cwidth + dy;
                this.addFlowCluster(cache, cluster, addingFrontier);
                if (ox < 0 || oy < 0 || ox >= this.cwidth || oy >= this.cheight) continue;
                int other = ox + oy * this.cwidth;
                this.addFlowCluster(cache, other, addingFrontier);
            }
        }
    }

    private Pathfinder.PathCost idToCost(int costId) {
        return costTypes.get(costId);
    }

    public static boolean isNearObstacle(Unit unit, int x1, int y1, int x2, int y2) {
        return ControlPathfinder.raycast(unit.team().id, unit.type.pathCost, x1, y1, x2, y2);
    }

    public boolean getPathPosition(Unit unit, Vec2 destination, Vec2 out, @Nullable boolean[] noResultFound) {
        return this.getPathPosition(unit, destination, destination, out, noResultFound);
    }

    public boolean getPathPosition(Unit unit, Vec2 destination, Vec2 mainDestination, Vec2 out, @Nullable boolean[] noResultFound) {
        boolean raycastResult;
        if (noResultFound != null) {
            noResultFound[0] = false;
        }
        int costId = unit.type.pathCostId;
        Pathfinder.PathCost cost = this.idToCost(costId);
        Tile tileOn = unit.tileOn();
        int team = unit.team.id;
        int tileX = unit.tileX();
        int tileY = unit.tileY();
        int packedPos = Vars.world.packArray(tileX, tileY);
        int destX = World.toTile(mainDestination.x);
        int destY = World.toTile(mainDestination.y);
        int actualDestX = World.toTile(destination.x);
        int actualDestY = World.toTile(destination.y);
        int actualDestPos = actualDestX + actualDestY * Pathfinder.wwidth;
        int initialCost = tileOn == null ? 0 : cost.getCost(team, Vars.pathfinder.tiles[tileOn.array()]);
        int destPos = destX + destY * Pathfinder.wwidth;
        PathRequest request = this.unitRequests.get(unit);
        unit.hitboxTile(Tmp.r3);
        float tileRectSize = 8.0f + Tmp.r3.height;
        int lastRaycastTile = request == null || Vars.world.tileChanges != request.lastWorldUpdate ? -1 : request.lastRaycastTile;
        boolean bl = raycastResult = request != null && request.lastRaycastResult;
        if (lastRaycastTile != packedPos) {
            boolean bl2 = unit.within(destination, 20.0f) ? !ControlPathfinder.raycastRect(initialCost, unit.x, unit.y, destination.x, destination.y, team, cost, tileX, tileY, actualDestX, actualDestY, tileRectSize) : (raycastResult = !ControlPathfinder.raycast(team, cost, tileX, tileY, actualDestX, actualDestY));
            if (request != null) {
                request.lastRaycastTile = packedPos;
                request.lastRaycastResult = raycastResult;
                request.lastWorldUpdate = Vars.world.tileChanges;
            }
        }
        if (raycastResult) {
            out.set(destination);
            return true;
        }
        boolean any = false;
        long fieldKey = FieldIndex.get(destPos, costId, team);
        if (request != null && request.destination == destPos) {
            request.lastUpdateId = Vars.state.updateId;
            Tile initialTileOn = tileOn;
            FieldCache fieldCache = null;
            try {
                fieldCache = this.fields.get(fieldKey);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (fieldCache == null) {
                fieldCache = request.oldCache;
            }
            if (fieldCache != null && tileOn != null) {
                boolean requeue;
                FieldCache old = request.oldCache;
                FieldCache targetCache = old != null ? old : fieldCache;
                boolean bl3 = requeue = old == null;
                if (fieldCache != request.oldCache && fieldCache.frontier.isEmpty() && old != null) {
                    request.oldCache = null;
                }
                fieldCache.lastUpdateId = Vars.state.updateId;
                int maxIterations = 30;
                int i = 0;
                boolean recalc = false;
                if (packedPos == actualDestPos) {
                    request.lastTargetTile = tileOn;
                } else if (initialTileOn.pos() != request.lastTile || request.lastTargetTile == null) {
                    boolean anyNearSolid = false;
                    while (i++ < maxIterations) {
                        int value = this.getCost(targetCache, tileOn.x, tileOn.y, requeue);
                        Tile current = null;
                        int minCost = 0;
                        for (int dir = 0; dir < 4; ++dir) {
                            Point2 point = Geometry.d4[dir];
                            int dx = tileOn.x + point.x;
                            int dy = tileOn.y + point.y;
                            Tile other = Vars.world.tile(dx, dy);
                            if (other == null) continue;
                            int packed = Vars.world.packArray(dx, dy);
                            int otherCost = this.getCost(targetCache, dx, dy, requeue);
                            int relCost = otherCost - value;
                            if (relCost > 2 || otherCost <= 0) {
                                anyNearSolid = true;
                            }
                            if (value != 0 && otherCost >= value || otherCost == -1 || (otherCost == 0 || current != null && otherCost >= minCost) && packed != actualDestPos && packed != destPos || !ControlPathfinder.passable(team, cost, packed)) continue;
                            current = other;
                            minCost = otherCost;
                            if (packed == destPos || packed == actualDestPos) break;
                        }
                        if (current == null || unit.type.canDrown && current.dangerous() && !tileOn.dangerous()) break;
                        if (anyNearSolid && (!tileOn.dangerous() || costId != 0) && ControlPathfinder.raycastRect(initialCost, unit.x, unit.y, current.x * 8, current.y * 8, team, cost, initialTileOn.x, initialTileOn.y, current.x, current.y, tileRectSize)) {
                            if (tileOn != initialTileOn) break;
                            recalc = true;
                            any = true;
                            break;
                        }
                        tileOn = current;
                        any = true;
                        int a = current.array();
                        if (a != destPos && a != actualDestPos) continue;
                        break;
                    }
                    Tile tile = request.lastTargetTile = any ? tileOn : null;
                    if (showDebug && tileOn != null && Core.graphics.getFrameId() % 30L == 0L) {
                        Fx.placeBlock.at(tileOn.worldx(), tileOn.worldy(), 1.0f);
                    }
                }
                if (request.lastTargetTile != null) {
                    if (showDebug && Core.graphics.getFrameId() % 30L == 0L) {
                        Fx.breakBlock.at(request.lastTargetTile.worldx(), request.lastTargetTile.worldy(), 1.0f);
                    }
                    out.set(request.lastTargetTile.worldx(), request.lastTargetTile.worldy());
                    request.lastTile = recalc ? -1 : initialTileOn.pos();
                    return true;
                }
            }
        } else {
            if (request != null) {
                request.lastUpdateId = -1000L;
            }
            request = new PathRequest(unit, team, costId, destPos);
            this.unitRequests.put(unit, request);
            PathRequest f = request;
            this.queue.post(() -> {
                this.threadPathRequests.add(f);
                this.recalculatePath(f);
            });
            return false;
        }
        if (noResultFound != null) {
            noResultFound[0] = request.notFound;
        }
        return false;
    }

    private void recalculatePath(PathRequest request) {
        this.initializePathRequest(request, request.team, request.costId, request.unit.tileX(), request.unit.tileY(), request.destination % Pathfinder.wwidth, request.destination / Pathfinder.wwidth);
    }

    private int getCost(FieldCache cache, int x, int y, boolean requeue) {
        try {
            int[] field = cache.fields.get(x / 12 + y / 12 * this.cwidth);
            if (field == null) {
                if (!requeue) {
                    return 0;
                }
                this.queue.post(() -> this.addFlowCluster(cache, x / 12, y / 12, true));
                return 0;
            }
            return field[x % 12 + y % 12 * 12];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    private static boolean raycast(int team, Pathfinder.PathCost type, int x1, int y1, int x2, int y2) {
        int ww = Pathfinder.wwidth;
        int wh = Pathfinder.wheight;
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            if (ControlPathfinder.avoid(team, type, x + y * Pathfinder.wwidth)) {
                return true;
            }
            if (x == x2 && y == y2) {
                return false;
            }
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
        return true;
    }

    public static int raycastFast(int team, Pathfinder.PathCost type, int x1, int y1, int x2, int y2) {
        int ww = Vars.world.width();
        int wh = Vars.world.height();
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            if (ControlPathfinder.solid(team, type, x + y * Pathfinder.wwidth, true)) {
                return Point2.pack(x, y);
            }
            if (x == x2 && y == y2) {
                return 0;
            }
            if (2 * err + dy > dx - 2 * err) {
                err -= dy;
                x += sx;
                continue;
            }
            err += dx;
            y += sy;
        }
        return 0;
    }

    public static int raycastFastAvoid(int team, Pathfinder.PathCost type, int x1, int y1, int x2, int y2) {
        int ww = Vars.world.width();
        int wh = Vars.world.height();
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            if (ControlPathfinder.avoid(team, type, x + y * Pathfinder.wwidth)) {
                return Point2.pack(x, y);
            }
            if (x == x2 && y == y2) {
                return 0;
            }
            if (2 * err + dy > dx - 2 * err) {
                err -= dy;
                x += sx;
                continue;
            }
            err += dx;
            y += sy;
        }
        return 0;
    }

    private static boolean overlap(int initialCost, int team, Pathfinder.PathCost type, int x, int y, float startX, float startY, float endX, float endY, float rectSize) {
        if (x < 0 || y < 0 || x >= Pathfinder.wwidth || y >= Pathfinder.wheight) {
            return false;
        }
        if (!ControlPathfinder.nearPassable(initialCost, team, type, x + y * Pathfinder.wwidth)) {
            return Intersector.intersectSegmentRectangleFast(startX, startY, endX, endY, (float)(x * 8) - rectSize / 2.0f, (float)(y * 8) - rectSize / 2.0f, rectSize, rectSize);
        }
        return false;
    }

    private static boolean raycastRect(int initialCost, float startX, float startY, float endX, float endY, int team, Pathfinder.PathCost type, int x1, int y1, int x2, int y2, float rectSize) {
        int ww = Pathfinder.wwidth;
        int wh = Pathfinder.wheight;
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            if (!ControlPathfinder.nearPassable(initialCost, team, type, x + y * Pathfinder.wwidth) || ControlPathfinder.overlap(initialCost, team, type, x + 1, y, startX, startY, endX, endY, rectSize) || ControlPathfinder.overlap(initialCost, team, type, x - 1, y, startX, startY, endX, endY, rectSize) || ControlPathfinder.overlap(initialCost, team, type, x, y + 1, startX, startY, endX, endY, rectSize) || ControlPathfinder.overlap(initialCost, team, type, x, y - 1, startX, startY, endX, endY, rectSize)) {
                return true;
            }
            if (x == x2 && y == y2) {
                return false;
            }
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
        return true;
    }

    private static boolean avoid(int team, Pathfinder.PathCost type, int tilePos) {
        int cost = ControlPathfinder.cost(team, type, tilePos);
        return cost == -1 || cost >= 2;
    }

    private static boolean passable(int team, Pathfinder.PathCost cost, int pos) {
        int amount = cost.getCost(team, Vars.pathfinder.tiles[pos]);
        return amount != -1 && amount < 7000;
    }

    private static boolean nearPassable(int initialCost, int team, Pathfinder.PathCost cost, int pos) {
        int amount = cost.getCost(team, Vars.pathfinder.tiles[pos]);
        return amount != -1 && amount < Math.min(Math.max(50, initialCost + 1), 7000);
    }

    private static boolean solid(int team, Pathfinder.PathCost type, int x, int y) {
        return x < 0 || y < 0 || x >= Pathfinder.wwidth || y >= Pathfinder.wheight || ControlPathfinder.solid(team, type, x + y * Pathfinder.wwidth, true);
    }

    private static boolean solid(int team, Pathfinder.PathCost type, int tilePos, boolean checkWall) {
        int cost = ControlPathfinder.cost(team, type, tilePos);
        return cost == -1 || cost >= 7000;
    }

    private static int cost(int team, Pathfinder.PathCost cost, int tilePos) {
        if (Vars.state.rules.limitMapArea && !Team.get(team).isAI()) {
            int x = tilePos % Pathfinder.wwidth;
            int y = tilePos / Pathfinder.wwidth;
            if (x < Vars.state.rules.limitX || y < Vars.state.rules.limitY || x > Vars.state.rules.limitX + Vars.state.rules.limitWidth || y > Vars.state.rules.limitY + Vars.state.rules.limitHeight) {
                return -1;
            }
        }
        return cost.getCost(team, Vars.pathfinder.tiles[tilePos]);
    }

    private void clusterChanged(int team, int pathCost, int cx, int cy) {
        int index = cx + cy * this.cwidth;
        for (PathRequest req : this.threadPathRequests) {
            long mapKey = FieldIndex.get(req.destination, pathCost, team);
            FieldCache field = this.fields.get(mapKey);
            if ((field == null || !field.fields.containsKey(index)) && !req.notFound) continue;
            this.invalidRequests.add(req);
        }
    }

    private void updateClustersComplete(int clusterIndex) {
        for (int team = 0; team < this.clusters.length; ++team) {
            Cluster[][] dim1 = this.clusters[team];
            if (dim1 == null) continue;
            for (int pathCost = 0; pathCost < dim1.length; ++pathCost) {
                Cluster cluster;
                Cluster[] dim2 = dim1[pathCost];
                if (dim2 == null || (cluster = dim2[clusterIndex]) == null) continue;
                this.updateCluster(team, pathCost, clusterIndex % this.cwidth, clusterIndex / this.cwidth);
                this.clusterChanged(team, pathCost, clusterIndex % this.cwidth, clusterIndex / this.cwidth);
            }
        }
    }

    private void updateClustersInner(int clusterIndex) {
        for (int team = 0; team < this.clusters.length; ++team) {
            Cluster[][] dim1 = this.clusters[team];
            if (dim1 == null) continue;
            for (int pathCost = 0; pathCost < dim1.length; ++pathCost) {
                Cluster cluster;
                Cluster[] dim2 = dim1[pathCost];
                if (dim2 == null || (cluster = dim2[clusterIndex]) == null) continue;
                this.updateInnerEdges(team, pathCost, clusterIndex % this.cwidth, clusterIndex / this.cwidth, cluster);
                this.clusterChanged(team, pathCost, clusterIndex % this.cwidth, clusterIndex / this.cwidth);
            }
        }
    }

    @Override
    public void run() {
        long lastInvalidCheck = Time.millis() + 1000L;
        while (!Vars.net.client() && !this.invalidated) {
            try {
                if (Vars.state.isPlaying()) {
                    this.queue.run();
                    this.clustersToUpdate.each(cluster -> {
                        this.updateClustersComplete(cluster);
                        this.clustersToInnerUpdate.remove(cluster);
                    });
                    this.clustersToInnerUpdate.each(cluster -> this.updateClustersInner(cluster));
                    this.clustersToInnerUpdate.clear();
                    this.clustersToUpdate.clear();
                    if (Time.timeSinceMillis(lastInvalidCheck) > 1000L) {
                        lastInvalidCheck = Time.millis();
                        ObjectSet.ObjectSetIterator it = this.invalidRequests.iterator();
                        while (it.hasNext()) {
                            PathRequest request = (PathRequest)it.next();
                            if (request.invalidated) {
                                it.remove();
                                continue;
                            }
                            long mapKey = FieldIndex.get(request.destination, request.costId, request.team);
                            FieldCache field = this.fields.get(mapKey);
                            if (field != null) {
                                if (!field.frontier.isEmpty()) continue;
                                this.fields.remove(field.mapKey);
                                Core.app.post(() -> this.fieldList.remove(field));
                                for (PathRequest otherRequest : this.threadPathRequests) {
                                    if (otherRequest.destination != request.destination) continue;
                                    otherRequest.oldCache = field;
                                    if (otherRequest == request) continue;
                                    this.queue.post(() -> this.recalculatePath(otherRequest));
                                }
                                this.queue.post(() -> this.recalculatePath(request));
                                it.remove();
                                continue;
                            }
                            this.queue.post(() -> this.recalculatePath(request));
                            it.remove();
                        }
                    }
                    this.fields.eachValue(cache -> {
                        if (cache != null) {
                            this.updateFields((FieldCache)cache, maxUpdate);
                        }
                    });
                }
                try {
                    Thread.sleep(33L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (Throwable e) {
                if (!this.invalidated) {
                    Log.err(e);
                    continue;
                }
                return;
            }
            break;
        }
        return;
    }

    static {
        costGround = (team, tile) -> PathTile.allDeep(tile) ? -1 : (PathTile.solid(tile) && (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) ? -1 : (PathTile.team(tile) != team && PathTile.team(tile) != 0 && PathTile.solid(tile) ? 1000000 : 0) + 1 + (PathTile.nearSolid(tile) ? 6 : 0) + (PathTile.nearLiquid(tile) ? 8 : 0) + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.damages(tile) ? 50 : 0));
        costHover = (team, tile) -> PathTile.solid(tile) && (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) ? -1 : (PathTile.team(tile) != team && PathTile.team(tile) != 0 && PathTile.solid(tile) ? 1000000 : 0) + 1 + (PathTile.nearSolid(tile) ? 6 : 0);
        costLegs = (team, tile) -> PathTile.legSolid(tile) ? -1 : 1 + (PathTile.nearDeep(tile) ? 8 : 0) + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.nearLegSolid(tile) ? 3 : 0);
        costNaval = (team, tile) -> PathTile.solid(tile) && (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) ? -1 : (!PathTile.liquid(tile) ? 6000 : 1) + (PathTile.team(tile) != team && PathTile.team(tile) != 0 && PathTile.solid(tile) ? 1000000 : 0) + (PathTile.nearGround(tile) || PathTile.nearSolid(tile) ? 6 : 0);
        costTypes = Seq.with(costGround, costHover, costLegs, costNaval);
        maxUpdate = Time.millisToNanos(12L);
        offsets = new int[]{1, 0, 0, 1, 0, 0, 0, 0};
        moveDirs = new int[]{0, 1, 1, 0, 0, 1, 1, 0};
        nextOffsets = new int[]{1, 0, 0, 1, -1, 0, 0, -1};
    }

    static class Cluster {
        IntSeq[] portals = new IntSeq[4];
        LongSeq[][] portalConnections = new LongSeq[4][];

        Cluster() {
        }
    }

    static class PathRequest {
        final Unit unit;
        final int destination;
        final int team;
        final int costId;
        final IntSeq resultPath = new IntSeq();
        @Nullable
        IntFloatMap costs = new IntFloatMap();
        @Nullable
        IntIntMap cameFrom = new IntIntMap();
        @Nullable
        PathfindQueue frontier = new PathfindQueue();
        long lastUpdateId;
        volatile boolean notFound;
        volatile boolean invalidated;
        @Nullable
        volatile FieldCache oldCache;
        boolean lastRaycastResult;
        int lastRaycastTile;
        int lastWorldUpdate;
        int lastTile;
        @Nullable
        Tile lastTargetTile;

        PathRequest(Unit unit, int team, int costId, int destination) {
            this.lastUpdateId = Vars.state.updateId;
            this.notFound = false;
            this.invalidated = false;
            this.lastRaycastResult = false;
            this.unit = unit;
            this.costId = costId;
            this.team = team;
            this.destination = destination;
        }
    }

    static class FieldCache {
        final Pathfinder.PathCost cost;
        final int costId;
        final int team;
        final int goalPos;
        final IntQueue frontier = new IntQueue();
        final IntMap<int[]> fields = new IntMap();
        final long mapKey;
        long lastUpdateId;

        FieldCache(Pathfinder.PathCost cost, int costId, int team, int goalPos) {
            this.lastUpdateId = Vars.state.updateId;
            this.cost = cost;
            this.team = team;
            this.goalPos = goalPos;
            this.costId = costId;
            this.mapKey = FieldIndex.get(goalPos, costId, team);
        }
    }

    static class NodeIndexStruct {
        int cluster;
        int dir;
        int portal;

        NodeIndexStruct() {
        }
    }

    static class IntraEdgeStruct {
        int dir;
        int portal;
        float cost;

        IntraEdgeStruct() {
        }
    }

    static class FieldIndexStruct {
        int pos;
        int costId;
        int team;

        FieldIndexStruct() {
        }
    }
}

