/*
 * Decompiled with CFR 0.152.
 */
package arc.util.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferInput
implements DataInput {
    public ByteBuffer buffer;

    public ByteBufferInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferInput() {
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void readFully(byte[] bytes) {
        this.buffer.get(bytes);
    }

    @Override
    public void readFully(byte[] bytes, int f, int to) {
        this.buffer.get(bytes, f, to);
    }

    @Override
    public int skipBytes(int i) {
        this.buffer.position(this.buffer.position() + i);
        return i;
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.get() == 1;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.get() & 0xFF;
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    @Override
    public char readChar() {
        return this.buffer.getChar();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public String readLine() {
        throw new RuntimeException("Stub!");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

