/*
 * Decompiled with CFR 0.152.
 */
package arc.struct;

import arc.util.ArcRuntimeException;
import java.util.Comparator;

public class PQueue<E> {
    private static final float CAPACITY_RATIO_LOW = 1.5f;
    private static final float CAPACITY_RATIO_HI = 2.0f;
    public Object[] queue;
    public int size = 0;
    public Comparator<E> comparator;

    public PQueue() {
        this(12, null);
    }

    public PQueue(int initialCapacity, Comparator<E> comparator) {
        this.queue = new Object[initialCapacity];
        this.comparator = comparator;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public boolean add(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Element cannot be null.");
        }
        int i = this.size;
        if (i >= this.queue.length) {
            this.growToSize(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(i, e);
        }
        return true;
    }

    public E peek() {
        return (E)(this.size == 0 ? null : this.queue[0]);
    }

    public E get(int index) {
        return (E)(index >= this.size ? null : this.queue[index]);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    public E poll() {
        if (this.size == 0) {
            return null;
        }
        int s = --this.size;
        Object result = this.queue[0];
        Object x = this.queue[s];
        this.queue[s] = null;
        if (s != 0) {
            this.siftDown(0, x);
        }
        return (E)result;
    }

    private void siftUp(int k, E x) {
        int parent;
        Object e;
        while (k > 0 && this.compare(x, e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = x;
    }

    private void siftDown(int k, E x) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.compare(c, this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (this.compare(x, c) <= 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = x;
    }

    private int compare(E a, E b) {
        return this.comparator == null ? ((Comparable)a).compareTo(b) : this.comparator.compare(a, b);
    }

    private void growToSize(int minCapacity) {
        if (minCapacity < 0) {
            throw new ArcRuntimeException("Capacity upper limit exceeded.");
        }
        int oldCapacity = this.queue.length;
        int newCapacity = (int)(oldCapacity < 64 ? (float)(oldCapacity + 1) * 2.0f : (float)oldCapacity * 1.5f);
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        Object[] newQueue = new Object[newCapacity];
        System.arraycopy(this.queue, 0, newQueue, 0, this.size);
        this.queue = newQueue;
    }
}

