/*
 * Decompiled with CFR 0.152.
 */
package arc.net;

import arc.net.ArcNetException;
import arc.net.TcpIdleSender;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputStreamSender
extends TcpIdleSender {
    private final InputStream input;
    private final byte[] chunk;

    public InputStreamSender(InputStream input, int chunkSize) {
        this.input = input;
        this.chunk = new byte[chunkSize];
    }

    @Override
    protected final Object next() {
        try {
            int count;
            for (int total = 0; total < this.chunk.length; total += count) {
                count = this.input.read(this.chunk, total, this.chunk.length - total);
                if (count >= 0) continue;
                if (total == 0) {
                    return null;
                }
                byte[] partial = new byte[total];
                System.arraycopy(this.chunk, 0, partial, 0, total);
                return this.next(partial);
            }
        }
        catch (IOException ex) {
            throw new ArcNetException(ex);
        }
        return this.next(this.chunk);
    }

    protected abstract Object next(byte[] var1);
}

