/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.geom.BoundingBox;
import arc.math.geom.Mat3D;
import arc.math.geom.Plane;
import arc.math.geom.Vec3;

public class Frustum {
    protected static final Vec3[] clipSpacePlanePoints = new Vec3[]{new Vec3(-1.0f, -1.0f, -1.0f), new Vec3(1.0f, -1.0f, -1.0f), new Vec3(1.0f, 1.0f, -1.0f), new Vec3(-1.0f, 1.0f, -1.0f), new Vec3(-1.0f, -1.0f, 1.0f), new Vec3(1.0f, -1.0f, 1.0f), new Vec3(1.0f, 1.0f, 1.0f), new Vec3(-1.0f, 1.0f, 1.0f)};
    protected static final float[] clipSpacePlanePointsArray = new float[24];
    private static final Vec3 tmpV = new Vec3();
    public final Plane[] planes = new Plane[6];
    public final Vec3[] planePoints = new Vec3[]{new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3()};
    protected final float[] planePointsArray = new float[24];

    public Frustum() {
        for (int i = 0; i < 6; ++i) {
            this.planes[i] = new Plane(new Vec3(), 0.0f);
        }
    }

    public void update(Mat3D inverseProjectionView) {
        System.arraycopy(clipSpacePlanePointsArray, 0, this.planePointsArray, 0, clipSpacePlanePointsArray.length);
        Mat3D.prj(inverseProjectionView.val, this.planePointsArray, 0, 8, 3);
        int j = 0;
        for (int i = 0; i < 8; ++i) {
            Vec3 v = this.planePoints[i];
            v.x = this.planePointsArray[j++];
            v.y = this.planePointsArray[j++];
            v.z = this.planePointsArray[j++];
        }
        this.planes[0].set(this.planePoints[1], this.planePoints[0], this.planePoints[2]);
        this.planes[1].set(this.planePoints[4], this.planePoints[5], this.planePoints[7]);
        this.planes[2].set(this.planePoints[0], this.planePoints[4], this.planePoints[3]);
        this.planes[3].set(this.planePoints[5], this.planePoints[1], this.planePoints[6]);
        this.planes[4].set(this.planePoints[2], this.planePoints[3], this.planePoints[6]);
        this.planes[5].set(this.planePoints[4], this.planePoints[0], this.planePoints[1]);
    }

    public boolean containsPoint(Vec3 point) {
        for (Plane plane : this.planes) {
            if (plane.testPoint(point) != Plane.PlaneSide.back) continue;
            return false;
        }
        return true;
    }

    public boolean containsPoint(float x, float y, float z) {
        for (Plane plane : this.planes) {
            if (plane.testPoint(x, y, z) != Plane.PlaneSide.back) continue;
            return false;
        }
        return true;
    }

    public boolean containsSphere(Vec3 center, float radius) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.planes[i].normal.x * center.x + this.planes[i].normal.y * center.y + this.planes[i].normal.z * center.z < -radius - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean containsSphere(float x, float y, float z, float radius) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.planes[i].normal.x * x + this.planes[i].normal.y * y + this.planes[i].normal.z * z < -radius - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean containsSphereWithoutNearFar(Vec3 center, float radius) {
        for (int i = 2; i < 6; ++i) {
            if (!(this.planes[i].normal.x * center.x + this.planes[i].normal.y * center.y + this.planes[i].normal.z * center.z < -radius - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean containsSphereWithoutNearFar(float x, float y, float z, float radius) {
        for (int i = 2; i < 6; ++i) {
            if (!(this.planes[i].normal.x * x + this.planes[i].normal.y * y + this.planes[i].normal.z * z < -radius - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean containsBounds(BoundingBox bounds) {
        for (Plane plane : this.planes) {
            if (plane.testPoint(bounds.getCorner000(tmpV)) != Plane.PlaneSide.back || plane.testPoint(bounds.getCorner001(tmpV)) != Plane.PlaneSide.back || plane.testPoint(bounds.getCorner010(tmpV)) != Plane.PlaneSide.back || plane.testPoint(bounds.getCorner011(tmpV)) != Plane.PlaneSide.back || plane.testPoint(bounds.getCorner100(tmpV)) != Plane.PlaneSide.back || plane.testPoint(bounds.getCorner101(tmpV)) != Plane.PlaneSide.back || plane.testPoint(bounds.getCorner110(tmpV)) != Plane.PlaneSide.back || plane.testPoint(bounds.getCorner111(tmpV)) != Plane.PlaneSide.back) continue;
            return false;
        }
        return true;
    }

    public boolean containsBounds(Vec3 center, Vec3 dimensions) {
        return this.containsBounds(center.x, center.y, center.z, dimensions.x / 2.0f, dimensions.y / 2.0f, dimensions.z / 2.0f);
    }

    public boolean containsBounds(float x, float y, float z, float halfWidth, float halfHeight, float halfDepth) {
        for (Plane plane : this.planes) {
            if (plane.testPoint(x + halfWidth, y + halfHeight, z + halfDepth) != Plane.PlaneSide.back || plane.testPoint(x + halfWidth, y + halfHeight, z - halfDepth) != Plane.PlaneSide.back || plane.testPoint(x + halfWidth, y - halfHeight, z + halfDepth) != Plane.PlaneSide.back || plane.testPoint(x + halfWidth, y - halfHeight, z - halfDepth) != Plane.PlaneSide.back || plane.testPoint(x - halfWidth, y + halfHeight, z + halfDepth) != Plane.PlaneSide.back || plane.testPoint(x - halfWidth, y + halfHeight, z - halfDepth) != Plane.PlaneSide.back || plane.testPoint(x - halfWidth, y - halfHeight, z + halfDepth) != Plane.PlaneSide.back || plane.testPoint(x - halfWidth, y - halfHeight, z - halfDepth) != Plane.PlaneSide.back) continue;
            return false;
        }
        return true;
    }

    static {
        int j = 0;
        for (Vec3 v : clipSpacePlanePoints) {
            Frustum.clipSpacePlanePointsArray[j++] = v.x;
            Frustum.clipSpacePlanePointsArray[j++] = v.y;
            Frustum.clipSpacePlanePointsArray[j++] = v.z;
        }
    }
}

